/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.client.music;

import java.util.Map;
import java.util.Random;
import net.minecraft.class_2766;
import org.cneko.toneko.common.mod.client.music.MusicRecord;
import org.cneko.toneko.common.mod.client.music.ToNekoMusic;
import org.cneko.toneko.common.util.ConfigUtil;

public class ClientMusicPlayer {
    private static final Map<class_2766, Integer> INSTRUMENT_BASE_NOTE = Map.of(class_2766.field_12648, 60);
    private MusicRecord currentMusic;
    private int currentIndex;
    private long lastNoteTime;

    public ClientMusicPlayer() {
        this.randomSwitchMusic();
    }

    public void randomSwitchMusic() {
        if (ConfigUtil.IS_FOOL_DAY) {
            this.currentMusic = ToNekoMusic.NEVER_GONNA_GIVE_YOU_UP;
        }
        Random random = new Random();
        this.currentMusic = ToNekoMusic.MUSICS.get(random.nextInt(ToNekoMusic.MUSICS.size()));
        this.currentIndex = 0;
        this.lastNoteTime = 0L;
    }

    public void tryPlayNextNote(NotePlayer player) {
        int noteValue;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastNoteTime < (long)(this.currentMusic.noteDuration() / 2)) {
            return;
        }
        if (this.currentIndex >= this.currentMusic.music().length) {
            this.currentIndex = 0;
        }
        if ((noteValue = this.currentMusic.music()[this.currentIndex]) != 0) {
            int midiNote = ToNekoMusic.NOTE_MAP.getOrDefault(noteValue, 0);
            int baseMidiNote = INSTRUMENT_BASE_NOTE.getOrDefault(this.currentMusic.instrument(), 60);
            float pitch = (float)Math.pow(2.0, (double)(midiNote - baseMidiNote) / 12.0);
            class_2766 instrument = this.currentMusic.instrument();
            player.playNote(instrument, pitch, 1.0f);
        }
        this.currentIndex = (this.currentIndex + 1) % this.currentMusic.music().length;
        this.lastNoteTime = currentTime;
    }

    public void restart() {
        this.currentIndex = 0;
        this.lastNoteTime = 0L;
    }

    public static interface NotePlayer {
        public void playNote(class_2766 var1, float var2, float var3);
    }
}

