/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.client.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8130;
import net.minecraft.class_9017;
import org.cneko.toneko.common.util.ConfigBuilder;
import org.cneko.toneko.common.util.ConfigUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen
extends class_437 {
    private final class_437 lastScreen;
    private ScrollPanel scrollPanel;
    private ConfigWidget randomText;
    private static int randoms = 29;
    private List<ConfigNode> configTree;

    public ConfigScreen(class_437 lastScreen) {
        super((class_2561)class_2561.method_43473());
        this.lastScreen = lastScreen;
    }

    public ConfigScreen() {
        this(null);
    }

    public void method_25426() {
        super.method_25426();
        class_5250 titleText = class_2561.method_43471((String)"screen.toneko.config.title");
        int titleX = (this.field_22789 - this.field_22793.method_27525((class_5348)titleText)) / 2;
        int titleY = (int)((double)this.field_22790 * 0.05);
        this.method_37063((class_364)new TextWidget(titleX, titleY, (class_2561)titleText, this.field_22793));
        int scrollX = (int)((double)this.field_22789 * 0.1);
        int scrollY = (int)((double)this.field_22790 * 0.15);
        int scrollWidth = (int)((double)this.field_22789 * 0.8);
        int scrollHeight = (int)((double)this.field_22790 * 0.65);
        this.scrollPanel = new ScrollPanel(scrollX, scrollY, scrollWidth, scrollHeight, (class_2561)class_2561.method_43473());
        this.configTree = this.buildConfigTree();
        this.rebuildScrollPanel();
        this.method_37063((class_364)this.scrollPanel);
        int btnWidth = (int)((double)this.field_22789 * 0.3);
        int btnHeight = 20;
        int btnY = (int)((double)this.field_22790 * 0.9);
        int btnSpacing = (int)((double)this.field_22789 * 0.05);
        class_4185 leftButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.toneko.config.button.quit"), btn -> this.field_22787.method_1507(this.lastScreen)).method_46434(this.field_22789 / 2 - btnWidth - btnSpacing / 2, btnY, btnWidth, btnHeight).method_46431();
        class_4185 rightButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.toneko.config.button.apply"), btn -> {
            ConfigUtil.CONFIG.save();
            ConfigUtil.load();
        }).method_46434(this.field_22789 / 2 + btnSpacing / 2, btnY, btnWidth, btnHeight).method_46431();
        this.method_37063((class_364)leftButton);
        this.method_37063((class_364)rightButton);
    }

    private void rebuildScrollPanel() {
        this.scrollPanel.clearWidgets();
        int indent = 0;
        for (ConfigNode node : this.configTree) {
            this.addNodeWidgets(node, indent);
        }
        int scrollWidth = this.scrollPanel.method_25368();
        int textWidth = (int)((double)scrollWidth * 0.35);
        int random = new Random().nextInt(randoms);
        this.randomText = new ConfigWidget(this.scrollPanel.method_46426() + 5, 0, textWidth, 20, (class_2561)class_2561.method_43471((String)("screen.toneko.config.random." + random)), this.field_22793);
        this.scrollPanel.addTextWidget((class_339)this.randomText);
        this.scrollPanel.addWidget((class_339)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screen.toneko.config.button.random"), btn -> this.modifyRandomText()).method_46437(textWidth, 20).method_46431());
        this.scrollPanel.updateChildrenPositions();
    }

    private void addNodeWidgets(ConfigNode node, int indent) {
        int widgetHeight = 20;
        int space = 10;
        int scrollWidth = this.scrollPanel.method_25368();
        int textWidth = (int)((double)scrollWidth * 0.35) - indent;
        if (textWidth < 50) {
            textWidth = 50;
        }
        if (node.isGroupHeader()) {
            String arrow = node.collapsed ? " [+] " : " [-] ";
            class_5250 headerText = class_2561.method_43470((String)(arrow + node.name));
            FoldableGroupHeaderWidget groupHeader = new FoldableGroupHeaderWidget(this.scrollPanel.method_46426() + 5 + indent, 0, textWidth, widgetHeight, (class_2561)headerText, this.field_22793, node, this::rebuildScrollPanel);
            this.scrollPanel.addTextWidget(groupHeader);
            if (!node.collapsed) {
                for (ConfigNode child : node.children) {
                    this.addNodeWidgets(child, indent + 20);
                }
            }
        } else if (node.fullKey != null) {
            ConfigButton inputComponent;
            class_5250 labelText = class_2561.method_43471((String)("screen.toneko.config.key." + node.fullKey));
            ConfigWidget configWidget = new ConfigWidget(0, 0, textWidth, widgetHeight, (class_2561)labelText, this.field_22793, node.entry.url());
            configWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("screen.toneko.config.key." + node.fullKey + ".des"))));
            configWidget.method_46421(this.scrollPanel.method_46426() + 5 + indent);
            this.scrollPanel.addTextWidget((class_339)configWidget);
            if (node.entry.type() == ConfigBuilder.Entry.Types.BOOLEAN) {
                inputComponent = new ConfigButton.Builder(node.fullKey, ConfigUtil.CONFIG_BUILDER).bounds(0, 0, textWidth, widgetHeight).build();
            } else if (node.entry.type() == ConfigBuilder.Entry.Types.STRING) {
                class_342 editBox = new class_342(this.field_22793, 0, 0, textWidth, widgetHeight, (class_2561)class_2561.method_43470((String)node.fullKey));
                editBox.method_1880(1000);
                editBox.method_1852(ConfigUtil.CONFIG.getString(node.fullKey));
                editBox.method_1863(text -> ConfigUtil.CONFIG.set(node.fullKey, text));
                inputComponent = editBox;
            } else {
                return;
            }
            inputComponent.method_46421(configWidget.method_46426() + textWidth + space);
            inputComponent.method_46419(configWidget.method_46427() + (widgetHeight - inputComponent.method_25364()) / 2);
            this.scrollPanel.addWidget((class_339)inputComponent);
            this.scrollPanel.totalContentHeight += widgetHeight;
        }
    }

    private List<ConfigNode> buildConfigTree() {
        ArrayList<ConfigNode> roots = new ArrayList<ConfigNode>();
        List<String> keys = ConfigUtil.CONFIG_BUILDER.getKeys();
        for (String key : keys) {
            String[] parts = key.split("\\.");
            this.insertNode(roots, parts, 0, key);
        }
        return roots;
    }

    private void insertNode(List<ConfigNode> nodes, String[] parts, int index, String fullKey) {
        String part = parts[index];
        ConfigNode node = null;
        for (ConfigNode n : nodes) {
            if (!n.name.equals(part)) continue;
            node = n;
            break;
        }
        if (node == null) {
            node = new ConfigNode(part);
            nodes.add(node);
        }
        if (index == parts.length - 1) {
            node.fullKey = fullKey;
            node.entry = ConfigUtil.CONFIG_BUILDER.get(fullKey);
        } else {
            if (node.fullKey != null) {
                return;
            }
            if (node.children == null) {
                node.children = new ArrayList<ConfigNode>();
            }
            this.insertNode(node.children, parts, index + 1, fullKey);
        }
    }

    public void modifyRandomText() {
        int random = new Random().nextInt(randoms);
        this.randomText.method_25355((class_2561)class_2561.method_43471((String)("screen.toneko.config.random." + random)));
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public static class TextWidget
    extends class_339 {
        private final class_327 font;

        public TextWidget(int x, int y, class_2561 message, class_327 font) {
            int n = font.method_27525((class_5348)message);
            Objects.requireNonNull(font);
            super(x, y, n, 9, message);
            this.font = font;
        }

        public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_51439(this.font, this.method_25369(), this.method_46426(), this.method_46427(), 0xFFFFFF, false);
        }

        protected void method_47399(@NotNull class_6382 narrationElementOutput) {
        }
    }

    public static class ScrollPanel
    extends class_9017 {
        private final List<class_339> children = new ArrayList<class_339>();
        private final int panelWidth;
        private final int panelHeight;
        private int scrollAmount = 0;
        public int totalContentHeight = 0;
        private final int scrollbarWidth = 6;
        private boolean isDragging = false;

        public ScrollPanel(int x, int y, int width, int height, class_2561 title) {
            super(x, y, width, height, title);
            this.panelWidth = width;
            this.panelHeight = height;
        }

        public void clearWidgets() {
            this.children.clear();
            this.totalContentHeight = 0;
            this.scrollAmount = 0;
        }

        public void addWidget(class_339 widget) {
            widget.method_46421((int)((double)this.method_46426() + (double)this.field_22758 * 0.5));
            widget.method_46419(this.method_46427() + this.totalContentHeight - this.scrollAmount + 5);
            this.children.add(widget);
        }

        public void addTextWidget(class_339 widget) {
            widget.method_46419(this.method_46427() + this.totalContentHeight - this.scrollAmount + 5);
            this.children.add(widget);
            this.totalContentHeight += widget.method_25364() + 10;
        }

        public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.panelWidth, this.method_46427() + this.panelHeight);
            for (class_339 widget : this.children) {
                int widgetY = widget.method_46427();
                if (widgetY + widget.method_25364() < this.method_46427() || widgetY > this.method_46427() + this.panelHeight) continue;
                widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
            guiGraphics.method_44380();
            guiGraphics.method_51448().method_22909();
            if (this.totalContentHeight > this.panelHeight) {
                int scrollbarHeight = Math.max((int)((double)this.panelHeight / (double)this.totalContentHeight * (double)this.panelHeight), 10);
                int scrollbarX = this.method_46426() + this.panelWidth - 6;
                int scrollbarY = this.method_46427() + (int)((double)this.scrollAmount / (double)this.totalContentHeight * (double)this.panelHeight);
                guiGraphics.method_25294(scrollbarX, this.method_46427(), scrollbarX + 6, this.method_46427() + this.panelHeight, 0x33000000);
                int color = this.isDragging ? -2236963 : -5592406;
                guiGraphics.method_25294(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, color);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.totalContentHeight > this.panelHeight) {
                int scrollbarHeight = Math.max((int)((double)this.panelHeight / (double)this.totalContentHeight * (double)this.panelHeight), 10);
                int scrollbarX = this.method_46426() + this.panelWidth - 6;
                int scrollbarY = this.method_46427() + (int)((double)this.scrollAmount / (double)this.totalContentHeight * (double)this.panelHeight);
                if (mouseX >= (double)(scrollbarX - 2) && mouseX <= (double)(scrollbarX + 6 + 2) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                    this.isDragging = true;
                    return true;
                }
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.isDragging && this.totalContentHeight > this.panelHeight) {
                double scale = (double)this.totalContentHeight / (double)this.panelHeight;
                this.scrollAmount += (int)(deltaY * scale);
                this.scrollAmount = Math.max(0, Math.min(this.totalContentHeight - this.panelHeight, this.scrollAmount));
                this.updateChildrenPositions();
                return true;
            }
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
            if (this.totalContentHeight > this.panelHeight) {
                int scrollSpeed = 20;
                this.scrollAmount = (int)Math.max(0.0, Math.min((double)(this.totalContentHeight - this.panelHeight), (double)this.scrollAmount - scrollY * (double)scrollSpeed));
                this.updateChildrenPositions();
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.isDragging = false;
            }
            return super.method_25406(mouseX, mouseY, button);
        }

        public void updateChildrenPositions() {
            int currentY = this.method_46427() + 5 - this.scrollAmount;
            for (int i = 0; i < this.children.size(); ++i) {
                class_339 widget = this.children.get(i);
                if (widget instanceof ConfigWidget && i + 1 < this.children.size() && (this.children.get(i + 1) instanceof class_342 || this.children.get(i + 1) instanceof class_4185)) {
                    widget.method_46419(currentY);
                    class_339 inputWidget = this.children.get(i + 1);
                    int labelHeight = widget.method_25364();
                    inputWidget.method_46419(currentY + (labelHeight - inputWidget.method_25364()) / 2);
                    currentY += Math.max(labelHeight, inputWidget.method_25364()) + 10;
                    ++i;
                    continue;
                }
                widget.method_46419(currentY);
                currentY += widget.method_25364() + 10;
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public void method_47399(@NotNull class_6382 narrationElementOutput) {
        }
    }

    public static class ConfigNode {
        String name;
        @Nullable
        String fullKey = null;
        @Nullable
        ConfigBuilder.Entry entry = null;
        List<ConfigNode> children = new ArrayList<ConfigNode>();
        boolean collapsed = false;

        public ConfigNode(String name) {
            this.name = name;
        }

        public boolean isGroupHeader() {
            return this.entry == null && !this.children.isEmpty();
        }
    }

    public static class ConfigWidget
    extends class_8130 {
        private String url;

        public ConfigWidget(int x, int y, int width, int height, class_2561 message, class_327 font) {
            super(x, y, width, height, message, font);
        }

        public ConfigWidget(int x, int y, int width, int height, class_2561 message, class_327 font, @Nullable String url) {
            this(x, y, width, height, message, font);
            this.url = url;
        }

        public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_51439(this.method_48977(), this.method_25369(), this.method_46426() + 5, this.method_46427() + (this.field_22759 - 8) / 2, 0xFFFFFF, false);
        }

        public void method_25348(double mouseX, double mouseY) {
            if (this.url != null) {
                class_407.method_49623((class_437)class_310.method_1551().field_1755, (String)this.url);
            }
        }
    }

    public static class FoldableGroupHeaderWidget
    extends class_339 {
        private final ConfigNode node;
        private final Runnable onToggle;
        private final class_327 font;

        public FoldableGroupHeaderWidget(int x, int y, int width, int height, class_2561 message, class_327 font, ConfigNode node, Runnable onToggle) {
            super(x, y, width, height, message);
            this.font = font;
            this.node = node;
            this.onToggle = onToggle;
        }

        public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            String arrow = this.node.collapsed ? " [+] " : " [-] ";
            class_5250 text = class_2561.method_43470((String)arrow).method_27692(class_124.field_1080);
            class_5250 headerText = class_2561.method_43471((String)("screen.toneko.config.group." + this.node.name));
            text = text.method_10852((class_2561)headerText);
            int n = this.method_46426() + 5;
            int n2 = this.method_46427();
            int n3 = this.method_25364();
            Objects.requireNonNull(this.font);
            guiGraphics.method_51439(this.font, (class_2561)text, n, n2 + (n3 - 9) / 2, 0xFFFFFF, false);
        }

        public void method_25348(double mouseX, double mouseY) {
            this.node.collapsed = !this.node.collapsed;
            this.onToggle.run();
        }

        protected void method_47399(@NotNull class_6382 narrationElementOutput) {
        }
    }

    public static class ConfigButton
    extends class_4185 {
        public ConfigButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, class_4185.class_7841 createNarration) {
            super(x, y, width, height, message, onPress, createNarration);
        }

        protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }

        public static class Builder {
            private final ConfigBuilder.Entry entry;
            private int x;
            private int y;
            private int width;
            private int height;
            private final String key;
            public boolean value;

            public Builder(String key, ConfigBuilder cfg) {
                this.entry = cfg.getExist(key);
                this.key = key;
                this.value = ConfigUtil.CONFIG.getBoolean(key);
            }

            public Builder pos(int x, int y) {
                this.x = x;
                this.y = y;
                return this;
            }

            public Builder width(int width) {
                this.width = width;
                return this;
            }

            public Builder size(int width, int height) {
                this.width = width;
                this.height = height;
                return this;
            }

            public Builder bounds(int x, int y, int width, int height) {
                return this.pos(x, y).size(width, height);
            }

            public ConfigButton build() {
                class_5250 message = this.value ? class_2561.method_43471((String)"screen.toneko.config.button.true") : class_2561.method_43471((String)"screen.toneko.config.button.false");
                return new ConfigButton(this.x, this.y, this.width, this.height, (class_2561)message, btn -> {
                    ConfigUtil.CONFIG.set(this.key, !this.value);
                    this.value = !this.value;
                    btn.method_25355((class_2561)(this.value ? class_2561.method_43471((String)"screen.toneko.config.button.true") : class_2561.method_43471((String)"screen.toneko.config.button.false")));
                }, field_40754);
            }
        }
    }
}

