/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.client.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import org.cneko.toneko.common.mod.client.screens.InteractionScreen;

public class NekoScreenBuilder
implements Cloneable {
    private List<WidgetFactory> widgets = new ArrayList<WidgetFactory>();
    private int startY = 15;

    public NekoScreenBuilder setStartY(int startY) {
        this.startY = startY + 15;
        return this;
    }

    public NekoScreenBuilder addButton(ButtonFactory button) {
        return this.addWidget(button);
    }

    public NekoScreenBuilder addTooltip(TooltipFactory tooltip) {
        return this.addWidget(tooltip);
    }

    public NekoScreenBuilder addWidget(WidgetFactory widget) {
        this.widgets.add(widget);
        return this;
    }

    public NekoScreenBuilder addWidget(WidgetFactory widget, WidgetFactory targetWidget, InsertPosition position) {
        return this.addWidget(widget, targetWidget, position, 1);
    }

    public NekoScreenBuilder addWidget(WidgetFactory widget, WidgetFactory targetWidget, InsertPosition position, int count) {
        count = Math.max(count, 1);
        int targetIndex = -1;
        for (int i = 0; i < this.widgets.size(); ++i) {
            if (!this.widgets.get(i).equals(targetWidget)) continue;
            targetIndex = i;
            break;
        }
        if (targetIndex != -1) {
            if (position == InsertPosition.AFTER) {
                this.widgets.add(targetIndex + count, widget);
            } else if (position == InsertPosition.BEFORE) {
                this.widgets.add(targetIndex - count, widget);
            }
        } else {
            this.widgets.add(widget);
        }
        return this;
    }

    public List<WidgetFactory> getWidgets() {
        return this.widgets;
    }

    public List<TooltipFactory> getTooltips() {
        ArrayList<TooltipFactory> tooltips = new ArrayList<TooltipFactory>();
        for (WidgetFactory widget : this.widgets) {
            if (!(widget instanceof TooltipFactory)) continue;
            tooltips.add((TooltipFactory)widget);
        }
        return tooltips;
    }

    public List<ButtonFactory> getButtons() {
        ArrayList<ButtonFactory> buttons = new ArrayList<ButtonFactory>();
        for (WidgetFactory widget : this.widgets) {
            if (!(widget instanceof ButtonFactory)) continue;
            buttons.add((ButtonFactory)widget);
        }
        return buttons;
    }

    public int getStartY() {
        return this.startY;
    }

    public NekoScreenBuilder clone() {
        try {
            NekoScreenBuilder clone = (NekoScreenBuilder)super.clone();
            clone.widgets = new ArrayList<WidgetFactory>(this.widgets);
            clone.startY = this.startY;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static interface WidgetFactory {
    }

    public static enum InsertPosition {
        BEFORE,
        AFTER;

    }

    @FunctionalInterface
    public static interface TooltipFactory
    extends WidgetFactory {
        public class_2561 build(InteractionScreen var1);
    }

    @FunctionalInterface
    public static interface ButtonFactory
    extends WidgetFactory {
        public class_4185.class_7840 build(InteractionScreen var1);
    }
}

