/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.client.screens;

import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.cneko.toneko.common.mod.client.music.ClientMusicPlayer;
import org.jetbrains.annotations.NotNull;

public class RouletteScreen
extends class_437
implements ClientMusicPlayer.NotePlayer {
    private static final int MAX_VISIBLE_OPTIONS = 7;
    private static final int RADIUS = 60;
    private static final int OPTION_SIZE = 24;
    private final List<IRouletteAction> rouletteActions;
    private int selectedIndex;
    private long lastInputTime;
    private final ClientMusicPlayer clientMusicPlayer = new ClientMusicPlayer();

    public RouletteScreen(List<IRouletteAction> rouletteActions) {
        super((class_2561)class_2561.method_43473());
        this.rouletteActions = rouletteActions;
        this.selectedIndex = 0;
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        for (int offset = -3; offset <= 3; ++offset) {
            int index = Math.floorMod(this.selectedIndex + offset, this.rouletteActions.size());
            double angle = Math.toRadians(90 - offset * 30);
            int x = centerX + (int)(Math.cos(angle) * 60.0);
            int y = centerY - (int)(Math.sin(angle) * 60.0);
            boolean isSelected = offset == 0;
            this.drawOption(guiGraphics, x, y, this.rouletteActions.get(index), isSelected);
        }
        class_5250 tip = class_2561.method_43471((String)"gui.toneko.roulette.tip");
        guiGraphics.method_27534(this.field_22793, (class_2561)tip, centerX, centerY - 60 - 30, 0xFFFFFF);
        String count = this.selectedIndex + 1 + "/" + this.rouletteActions.size();
        guiGraphics.method_25300(this.field_22793, count, centerX, centerY + 60 + 10, 0xFFFFFF);
    }

    private void drawOption(class_332 guiGraphics, int x, int y, IRouletteAction action, boolean selected) {
        int color = selected ? -2147418368 : -2139062144;
        guiGraphics.method_25294(x - 12, y - 12, x + 12, y + 12, color);
        guiGraphics.method_25290(action.getIcon(), x - 8, y - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        class_2561 name = action.getName();
        guiGraphics.method_27534(this.field_22793, name, x, y + 12 + 2, 0xFFFFFF);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.navigate(-1);
            return true;
        }
        if (keyCode == 262) {
            this.navigate(1);
            return true;
        }
        if (keyCode == 265 || keyCode == 264) {
            this.clientMusicPlayer.randomSwitchMusic();
        }
        if (keyCode == 82) {
            this.clientMusicPlayer.restart();
        }
        if (keyCode == 257 || keyCode == 32) {
            this.executeSelected();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void playNote(class_2766 instrument, float pitch, float volume) {
        class_310.method_1551().method_1483().method_4873((class_1113)new class_1109((class_3414)instrument.method_11886().comp_349(), class_3419.field_15247, volume, pitch, class_1113.method_43221(), class_310.method_1551().field_1724.method_24515()));
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.clientMusicPlayer.tryPlayNextNote(this);
        this.navigate(deltaY > 0.0 ? -1 : 1);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.executeSelected();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void navigate(int direction) {
        this.clientMusicPlayer.tryPlayNextNote(this);
        if (System.currentTimeMillis() - this.lastInputTime < 100L) {
            return;
        }
        this.lastInputTime = System.currentTimeMillis();
        this.selectedIndex = Math.floorMod(this.selectedIndex + direction, this.rouletteActions.size());
    }

    private void executeSelected() {
        this.clientMusicPlayer.tryPlayNextNote(this);
        if (!this.rouletteActions.isEmpty()) {
            this.rouletteActions.get(this.selectedIndex).rouletteAction();
            this.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public static void open() {
        class_310.method_1551().method_1507((class_437)new RouletteScreen(RouletteScreen.getRouletteActions()));
    }

    private static List<IRouletteAction> getRouletteActions() {
        return List.of(new DefaultRouletteAction(class_2960.method_60656((String)"textures/item/barrier.png"), (class_2561)class_2561.method_43471((String)"gui.toneko.roulette.option.close"), () -> class_310.method_1551().method_1507(null)), RouletteScreen.createAction("mob_effect/speed.png", "speed", "neko speed"), RouletteScreen.createAction("mob_effect/jump_boost.png", "jump", "neko jump"), RouletteScreen.createAction("mob_effect/night_vision.png", "vision", "neko vision"), RouletteScreen.createAction("item/leather.png", "lie", "neko lie"), RouletteScreen.createAction("item/pink_dye.png", "get_down", "neko getDown"), RouletteScreen.createAction("item/saddle.png", "ride", "neko ride"), RouletteScreen.createAction("item/red_dye.png", "ride_head", "neko rideHead"));
    }

    private static DefaultRouletteAction createAction(String texturePath, String optionKey, String command) {
        return new DefaultRouletteAction(class_2960.method_60656((String)("textures/" + texturePath)), (class_2561)class_2561.method_43471((String)("gui.toneko.roulette.option." + optionKey)), () -> {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.field_3944.method_45731(command);
            }
        });
    }

    public static interface IRouletteAction {
        public class_2960 getIcon();

        public class_2561 getName();

        public void rouletteAction();
    }

    private record DefaultRouletteAction(class_2960 icon, class_2561 name, Runnable action) implements IRouletteAction
    {
        @Override
        public class_2960 getIcon() {
            return this.icon;
        }

        @Override
        public class_2561 getName() {
            return this.name;
        }

        @Override
        public void rouletteAction() {
            this.action.run();
        }
    }
}

