/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.cneko.toneko.common.api.Permissions;
import org.cneko.toneko.common.mod.api.EntityPoseManager;
import org.cneko.toneko.common.mod.misc.ToNekoAttributes;
import org.cneko.toneko.common.mod.packets.EntityPosePayload;
import org.cneko.toneko.common.mod.util.EntityUtil;
import org.cneko.toneko.common.mod.util.PermissionUtil;
import org.cneko.toneko.common.mod.util.TextUtil;

public class NekoCommand {
    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"neko").requires(class_2168::method_43737)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_HELP))).executes(NekoCommand::helpCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"jump").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_JUMP))).executes(NekoCommand::jumpCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"vision").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_VISION))).executes(NekoCommand::visionCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"speed").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_SPEED))).executes(NekoCommand::speedCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lie").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_LIE))).executes(NekoCommand::lieCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"getDown").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_GET_DOWN))).executes(NekoCommand::getDownCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"nickname").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_NICKNAME))).then(class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(NekoCommand::nicknameCommand)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"removeNickname").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_NICKNAME))).executes(NekoCommand::removeNicknameCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"level").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_LEVEL))).executes(NekoCommand::levelCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lore").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_LORE))).then(class_2170.method_9244((String)"lore", (ArgumentType)StringArgumentType.greedyString()).executes(NekoCommand::loreCommand)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ride").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_NEKO_RIDE))).executes(NekoCommand::rideCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rideHead").requires(source -> PermissionUtil.has(source, "command.neko.ride_head"))).executes(NekoCommand::rideHeadCommand))));
    }

    private static int removeNicknameCommand(CommandContext<class_2168> context) {
        class_3222 neko = ((class_2168)context.getSource()).method_44023();
        neko.setNickName("");
        return 1;
    }

    private static void handleRiding(class_1297 entity, class_1309 target, boolean isRideHead) {
        class_1297 senderEntity;
        if (target != null && target != entity) {
            if (isRideHead) {
                target.method_5873(entity, true);
            } else {
                entity.method_5873((class_1297)target, true);
            }
        }
        Object object = senderEntity = isRideHead ? entity : target;
        if (senderEntity instanceof class_3222) {
            class_3222 sp = (class_3222)senderEntity;
            sp.field_13987.method_14364((class_2596)new class_2752(senderEntity));
        }
    }

    public static int rideCommand(CommandContext<class_2168> context) {
        class_1297 entity = ((class_2168)context.getSource()).method_9228();
        class_3218 world = (class_3218)entity.method_37908();
        float radius = 3.0f;
        class_1309 target = EntityUtil.findNearestEntityInRange(entity, (class_1937)world, radius);
        NekoCommand.handleRiding(entity, target, false);
        return 1;
    }

    private static int rideHeadCommand(CommandContext<class_2168> context) {
        class_1297 entity = ((class_2168)context.getSource()).method_9228();
        class_3218 world = (class_3218)entity.method_37908();
        float radius = 3.0f;
        class_1309 target = EntityUtil.findNearestEntityInRange(entity, (class_1937)world, radius);
        NekoCommand.handleRiding(entity, target, true);
        return 1;
    }

    public static int getDownCommand(CommandContext<class_2168> context) {
        class_1297 entity = ((class_2168)context.getSource()).method_9228();
        NekoCommand.setEntityPose(entity, class_4050.field_18079, (class_2168)context.getSource());
        return 1;
    }

    public static int lieCommand(CommandContext<class_2168> context) {
        class_1297 entity = ((class_2168)context.getSource()).method_9228();
        NekoCommand.setEntityPose(entity, class_4050.field_18078, (class_2168)context.getSource());
        return 1;
    }

    private static void setEntityPose(class_1297 entity, class_4050 pose, class_2168 source) {
        if (EntityPoseManager.contains(entity)) {
            EntityPoseManager.remove(entity);
            NekoCommand.sendPosePacket(entity, pose, false);
        } else {
            EntityPoseManager.setPose(entity, pose);
            NekoCommand.sendPosePacket(entity, pose, true);
        }
    }

    private static void sendPosePacket(class_1297 entity, class_4050 pose, boolean isSet) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ServerPlayNetworking.send((class_3222)player, (class_8710)new EntityPosePayload(pose, entity.method_5667().toString(), isSet));
        }
    }

    public static int loreCommand(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!player.isNeko()) {
            ((class_2168)context.getSource()).method_44023().method_43496(TextUtil.translatable("command.neko.not_neko"));
        } else {
            class_1799 stack = player.method_6047();
            if (stack.method_7960()) {
                ((class_2168)context.getSource()).method_44023().method_43496(TextUtil.translatable("command.neko.lore.no_item"));
                return 1;
            }
            String lore = StringArgumentType.getString(context, (String)"lore");
            class_2561 text = class_2561.method_30163((String)lore);
            ArrayList<class_2561> loreList = new ArrayList<class_2561>();
            loreList.add(text);
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreList));
        }
        return 1;
    }

    public static int levelCommand(CommandContext<class_2168> context) {
        class_3222 neko = ((class_2168)context.getSource()).method_44023();
        if (neko.isNeko()) {
            double level = neko.getNekoLevel();
            level = (double)Math.round(level * 100.0) / 100.0;
            ((class_2168)context.getSource()).method_44023().method_43496(TextUtil.translatable("command.neko.level.success", level));
        } else {
            ((class_2168)context.getSource()).method_44023().method_43496(TextUtil.translatable("command.neko.not_neko"));
        }
        return 1;
    }

    public static int nicknameCommand(CommandContext<class_2168> context) {
        class_3222 neko = ((class_2168)context.getSource()).method_44023();
        String nickname = StringArgumentType.getString(context, (String)"nickname");
        neko.setNickName(nickname);
        neko.method_43496(TextUtil.translatable("command.neko.nickname.success", nickname));
        return 1;
    }

    public static int speedCommand(CommandContext<class_2168> context) {
        return NekoCommand.giveEffect(context, (class_6880<class_1291>)class_1294.field_5904);
    }

    public static int visionCommand(CommandContext<class_2168> context) {
        return NekoCommand.giveEffect(context, (class_6880<class_1291>)class_1294.field_5925);
    }

    public static int jumpCommand(CommandContext<class_2168> context) {
        return NekoCommand.giveEffect(context, (class_6880<class_1291>)class_1294.field_5913);
    }

    public static int giveEffect(CommandContext<class_2168> context, class_6880<class_1291> effect) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!player.isNeko()) {
            player.method_43496(TextUtil.translatable("command.neko.not_neko"));
            return 1;
        }
        if (player.getNekoEnergy() < 40.0f) {
            player.method_43496(TextUtil.translatable("command.neko.effect.not_enough_energy"));
        }
        player.setNekoEnergy(player.getNekoEnergy() - 40.0f);
        double nekoDegree = player.method_45325(ToNekoAttributes.NEKO_DEGREE);
        double level = player.getNekoLevel();
        int effectLevel = (int)(Math.sqrt(level + nekoDegree) / 2.0);
        int time = (int)(Math.sqrt(level + 1.0) * Math.sqrt(player.field_7495 + 1) / (double)(player.method_6032() / 4.0f) * 100.0 * (nekoDegree + 1.0) / 2.0);
        if (effectLevel > 10) {
            effectLevel = 10;
            time = 72000;
        }
        player.method_6092(new class_1293(effect, time, effectLevel));
        return 1;
    }

    public static int helpCommand(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.neko.help"));
        return 1;
    }
}

