/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.cneko.toneko.common.api.Permissions;
import org.cneko.toneko.common.mod.packets.QuirkQueryPayload;
import org.cneko.toneko.common.mod.quirks.Quirk;
import org.cneko.toneko.common.mod.quirks.QuirkRegister;
import org.cneko.toneko.common.mod.util.CommandUtil;
import org.cneko.toneko.common.mod.util.PermissionUtil;
import org.cneko.toneko.common.mod.util.TextUtil;
import org.cneko.toneko.common.util.QuirkUtil;

public class QuirkCommand {
    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"quirk").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_QUIRK) && source.method_43737())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_QUIRK_HELP))).executes(QuirkCommand::helpCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_QUIRK_ADD))).then(class_2170.method_9244((String)"quirk", (ArgumentType)StringArgumentType.string()).suggests(CommandUtil::getQuirksSuggestions).executes(QuirkCommand::addOrRemoveQuirk)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_QUIRK_REMOVE))).then(class_2170.method_9244((String)"quirk", (ArgumentType)StringArgumentType.string()).suggests(CommandUtil::getQuirksSuggestions).executes(QuirkCommand::addOrRemoveQuirk)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_QUIRK_LIST))).executes(QuirkCommand::listQuirks))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gui").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_QUIRK_GUI))).executes(QuirkCommand::quirkGui))).executes(QuirkCommand::quirkGui)));
    }

    public static int quirkGui(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new QuirkQueryPayload(QuirkUtil.quirkToIds(player.getQuirks()), QuirkRegister.getQuirkIds().stream().toList(), true));
        return 1;
    }

    public static int listQuirks(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player.getQuirks().isEmpty()) {
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.no_any_quirk"));
            return 1;
        }
        List quirks = player.getQuirks();
        List<String> quirkIds = quirks.stream().map(Quirk::getId).toList();
        List<class_2561> quirkTexts = quirkIds.stream().map(id -> TextUtil.translatable("quirk.toneko." + id)).toList();
        ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.list"));
        for (class_2561 text : quirkTexts) {
            ((class_2168)context.getSource()).method_45068(text);
        }
        return 1;
    }

    public static int addOrRemoveQuirk(CommandContext<class_2168> context) {
        class_3222 neko = ((class_2168)context.getSource()).method_44023();
        String quirk = StringArgumentType.getString(context, (String)"quirk");
        if (!QuirkRegister.hasQuirk(quirk)) {
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.not_quirk"));
            return 1;
        }
        context.getNodes().stream().filter(node -> node.getNode().getName().equals("add")).findFirst().ifPresent(arg_0 -> QuirkCommand.lambda$addOrRemoveQuirk$9((class_1657)neko, quirk, context, arg_0));
        context.getNodes().stream().filter(node -> node.getNode().getName().equals("remove")).findFirst().ifPresent(arg_0 -> QuirkCommand.lambda$addOrRemoveQuirk$11((class_1657)neko, quirk, context, arg_0));
        return 1;
    }

    public static int helpCommand(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.help"));
        return 1;
    }

    private static /* synthetic */ void lambda$addOrRemoveQuirk$11(class_1657 neko, String quirk, CommandContext context, ParsedCommandNode node) {
        if (!neko.hasQuirk(QuirkRegister.getById(quirk))) {
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.not_has_quirk"));
        } else {
            neko.removeQuirk(QuirkRegister.getById(quirk));
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.remove", quirk));
        }
    }

    private static /* synthetic */ void lambda$addOrRemoveQuirk$9(class_1657 neko, String quirk, CommandContext context, ParsedCommandNode node) {
        if (neko.hasQuirk(QuirkRegister.getById(quirk))) {
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.already_quirk"));
        } else {
            neko.addQuirk(QuirkRegister.getById(quirk));
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.quirk.add", quirk));
        }
    }
}

