/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.commands;

import com.google.gson.JsonElement;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import org.cneko.toneko.common.api.Permissions;
import org.cneko.toneko.common.mod.util.PermissionUtil;
import org.cneko.toneko.common.mod.util.TextUtil;
import org.cneko.toneko.common.util.ConfigBuilder;
import org.cneko.toneko.common.util.ConfigUtil;
import org.cneko.toneko.common.util.JsonConfiguration;
import org.cneko.toneko.common.util.LanguageUtil;

public class ToNekoAdminCommand {
    private static final SuggestionProvider<class_2168> CONFIG_KEYS = (context, builder) -> {
        ConfigUtil.CONFIG_BUILDER.getKeys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tonekoadmin").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKOADMIN))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKOADMIN_SET))).then(class_2170.method_9244((String)"neko", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"is", (ArgumentType)BoolArgumentType.bool()).executes(ToNekoAdminCommand::set))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKOADMIN_RELOAD))).executes(ToNekoAdminCommand::reload)).then(class_2170.method_9247((String)"config").executes(ToNekoAdminCommand::reloadConfig)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKOADMIN_CONFIG))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).suggests(CONFIG_KEYS).executes(ToNekoAdminCommand::getConfig)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).suggests(CONFIG_KEYS).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).executes(ToNekoAdminCommand::setConfig))))).then(class_2170.method_9247((String)"reload").executes(ToNekoAdminCommand::reloadConfig)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKOADMIN_HELP))).executes(ToNekoAdminCommand::help))));
    }

    private static int setConfig(CommandContext<class_2168> context) {
        String key = StringArgumentType.getString(context, (String)"key");
        String value = StringArgumentType.getString(context, (String)"value");
        try {
            ConfigBuilder builder = ConfigUtil.CONFIG_BUILDER;
            JsonConfiguration config = ConfigUtil.CONFIG;
            if (!config.contains(key)) {
                ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.tonekoadmin.config.not_found", key));
                return 1;
            }
            ConfigBuilder.Entry.Types type = builder.get(key).type();
            if (type == ConfigBuilder.Entry.Types.BOOLEAN && (value.equals("true") || value.equals("false") || value.equals("1") || value.equals("0"))) {
                config.set(key, Boolean.parseBoolean(value));
            } else if (type == ConfigBuilder.Entry.Types.NUMBER && value.matches("[0-9]+")) {
                config.set(key, Integer.parseInt(value));
            } else if (type == ConfigBuilder.Entry.Types.STRING) {
                config.set(key, value);
            } else {
                ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.tonekoadmin.config.type_error"));
                return 1;
            }
            config.save();
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.tonekoadmin.config.set", key, value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private static int getConfig(CommandContext<class_2168> context) {
        String key = StringArgumentType.getString(context, (String)"key");
        try {
            if (!ConfigUtil.CONFIG.contains(key)) {
                ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.tonekoadmin.config.not_found", key));
            }
            JsonElement value = ConfigUtil.CONFIG.get(key);
            ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.tonekoadmin.config.get", key, value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        ConfigUtil.load();
        LanguageUtil.load();
        ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.tonekoadmin.reload"));
        return 1;
    }

    public static int reload(CommandContext<class_2168> context) {
        ToNekoAdminCommand.reloadConfig(context);
        return 1;
    }

    public static int help(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_45068(TextUtil.translatable("command.tonekoadmin.help"));
        return 1;
    }

    public static int set(CommandContext<class_2168> context) {
        class_3222 neko;
        class_2168 source = (class_2168)context.getSource();
        try {
            neko = class_2186.method_9315(context, (String)"neko");
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        boolean isNeko = (Boolean)context.getArgument("is", Boolean.class);
        if (isNeko) {
            neko.setNeko(true);
            source.method_45068(TextUtil.translatable("command.tonekoadmin.set.true", neko.method_5477().getString()));
        } else {
            neko.setNeko(false);
            source.method_45068(TextUtil.translatable("command.tonekoadmin.set.false", neko.method_5477().getString()));
        }
        return 1;
    }
}

