/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.cneko.toneko.common.Bootstrap;
import org.cneko.toneko.common.api.Permissions;
import org.cneko.toneko.common.mod.commands.arguments.CustomStringArgument;
import org.cneko.toneko.common.mod.commands.arguments.NekoArgument;
import org.cneko.toneko.common.mod.commands.arguments.NekoSuggestionProvider;
import org.cneko.toneko.common.mod.commands.arguments.WordSuggestionProvider;
import org.cneko.toneko.common.mod.entities.INeko;
import org.cneko.toneko.common.mod.util.PermissionUtil;
import org.cneko.toneko.common.mod.util.TextUtil;

public class ToNekoCommand {
    private static Map<class_1657, class_1657> ownerMap = new HashMap<class_1657, class_1657>();

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"toneko").requires(class_2168::method_43737)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"player").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_PLAYER))).then(class_2170.method_9244((String)"neko", (ArgumentType)NekoArgument.neko()).suggests((SuggestionProvider)new NekoSuggestionProvider(false)).executes(ToNekoCommand::playerCommand)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"accept").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_ACCEPT))).then(class_2170.method_9244((String)"owner", (ArgumentType)class_2186.method_9305()).executes(ToNekoCommand::acceptCommand)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deny").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_DENY))).then(class_2170.method_9244((String)"owner", (ArgumentType)class_2186.method_9305()).executes(ToNekoCommand::denyCommand)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"aliases").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_ALIAS))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"neko", (ArgumentType)NekoArgument.ownedNeko()).suggests((SuggestionProvider)new NekoSuggestionProvider(true)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"aliases", (ArgumentType)CustomStringArgument.blockWord()).executes(ToNekoCommand::AliasesAdd)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"aliases", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)WordSuggestionProvider.aliases()).executes(ToNekoCommand::AliasesRemove)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"block").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_BLOCK))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"neko", (ArgumentType)NekoArgument.ownedNeko()).suggests((SuggestionProvider)new NekoSuggestionProvider(true)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"block", (ArgumentType)CustomStringArgument.blockWord()).then(class_2170.method_9244((String)"replace", (ArgumentType)CustomStringArgument.replaceWord()).then(class_2170.method_9244((String)"method", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("all");
            builder.suggest("word");
            return builder.buildFuture();
        }).executes(ToNekoCommand::addBlock)))))).then(class_2170.method_9247((String)"remove").then((ArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"block", (ArgumentType)CustomStringArgument.blockWord()).executes(ToNekoCommand::removeBlock)).suggests((SuggestionProvider)WordSuggestionProvider.blockWord())))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"xp").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_XP))).then(class_2170.method_9244((String)"neko", (ArgumentType)NekoArgument.ownedNeko()).suggests((SuggestionProvider)new NekoSuggestionProvider(true)).executes(ToNekoCommand::xp)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_REMOVE))).then(class_2170.method_9244((String)"neko", (ArgumentType)NekoArgument.ownedNeko()).suggests((SuggestionProvider)new NekoSuggestionProvider(true)).executes(ToNekoCommand::remove)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").requires(source -> PermissionUtil.has(source, Permissions.COMMAND_TONEKO_HELP))).executes(ToNekoCommand::help))).executes(ToNekoCommand::help)));
    }

    public static int playerCommand(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_3222 neko = (class_3222)context.getArgument("neko", class_3222.class);
            String nekoName = neko.method_5477().getString();
            assert (player != null);
            if (!neko.isNeko()) {
                player.method_43496(TextUtil.translatable("command.toneko.player.notNeko", nekoName));
                return 1;
            }
            if (neko.hasOwner(player.method_5667())) {
                player.method_43496(TextUtil.translatable("command.toneko.player.alreadyOwner", nekoName));
                return 1;
            }
            ownerMap.put((class_1657)player, (class_1657)neko);
            player.method_43496((class_2561)class_2561.method_43469((String)"command.toneko.player.send_request", (Object[])new Object[]{nekoName}).method_27692(class_124.field_1076));
            class_5250 component = class_2561.method_43469((String)"command.toneko.player.request", (Object[])new Object[]{player.method_5477().getString()}).method_27692(class_124.field_1065);
            class_5250 denyButton = class_2561.method_43471((String)"misc.toneko.deny").method_27692(class_124.field_1061);
            denyButton.method_10862(denyButton.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/toneko deny " + player.method_5477().getString())));
            class_5250 acceptButton = class_2561.method_43471((String)"misc.toneko.accept").method_27692(class_124.field_1060);
            acceptButton.method_10862(acceptButton.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/toneko accept " + player.method_5477().getString())));
            component.method_10852((class_2561)acceptButton);
            component.method_10852((class_2561)denyButton);
            neko.method_43496((class_2561)component);
            return 1;
        }
        catch (Exception e) {
            Bootstrap.LOGGER.error((Object)e);
            return 1;
        }
    }

    private static int denyCommand(CommandContext<class_2168> context) {
        return ToNekoCommand.acceptOwner(context, false);
    }

    private static int acceptCommand(CommandContext<class_2168> context) {
        return ToNekoCommand.acceptOwner(context, true);
    }

    private static int acceptOwner(CommandContext<class_2168> context, boolean accept) {
        class_3222 neko = ((class_2168)context.getSource()).method_44023();
        class_3222 owner = null;
        try {
            owner = class_2186.method_9315(context, (String)"owner");
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (ownerMap.containsKey(owner) && ownerMap.get(owner).equals((Object)neko)) {
            if (accept) {
                neko.addOwner(owner.method_5667(), new INeko.Owner(new ArrayList<String>(), 0));
                neko.method_43496((class_2561)class_2561.method_43469((String)"command.toneko.accept", (Object[])new Object[]{owner.method_5477()}).method_27692(class_124.field_1060));
                owner.method_43496((class_2561)class_2561.method_43469((String)"command.toneko.player.accept", (Object[])new Object[]{neko.method_5477()}).method_27692(class_124.field_1060));
            } else {
                neko.method_43496((class_2561)class_2561.method_43469((String)"command.toneko.accept", (Object[])new Object[]{owner.method_5477()}).method_27692(class_124.field_1061));
                owner.method_43496((class_2561)class_2561.method_43469((String)"command.toneko.player.deny", (Object[])new Object[]{neko.method_5477()}).method_27692(class_124.field_1061));
            }
            ownerMap.remove(owner);
        } else {
            neko.method_43496(TextUtil.translatable("command.toneko.not_request"));
        }
        return 1;
    }

    public static int help(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_45068(TextUtil.translatable("command.toneko.help"));
        return 1;
    }

    public static int remove(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_1657 neko = (class_1657)context.getArgument("neko", class_3222.class);
            neko.removeOwner(player.method_5667());
            player.method_43496(TextUtil.translatable("command.toneko.remove", neko.method_5477().getString()));
            return 1;
        }
        catch (Exception e) {
            Bootstrap.LOGGER.error((Object)e);
            return 1;
        }
    }

    public static int addBlock(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_44023();
            class_3222 neko = (class_3222)context.getArgument("neko", class_3222.class);
            String block = (String)context.getArgument("block", String.class);
            String replace = (String)context.getArgument("replace", String.class);
            String method = (String)context.getArgument("method", String.class);
            neko.addBlockedWord(new INeko.BlockedWord(block, replace, INeko.BlockedWord.BlockMethod.fromString(method)));
            player.method_43496(TextUtil.translatable("messages.toneko.block.add"));
            return 1;
        }
        catch (Exception e) {
            Bootstrap.LOGGER.error((Object)e);
            return 1;
        }
    }

    public static int removeBlock(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_44023();
            class_3222 neko = (class_3222)context.getArgument("neko", class_3222.class);
            String block = (String)context.getArgument("block", String.class);
            neko.removeBlockedWord(block);
            player.method_43496(TextUtil.translatable("messages.toneko.block.remove"));
            return 1;
        }
        catch (Exception e) {
            Bootstrap.LOGGER.error((Object)e);
            return 1;
        }
    }

    public static int xp(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_3222 neko = (class_3222)context.getArgument("neko", class_3222.class);
            player.method_43496(TextUtil.translatable("command.toneko.xp", neko.method_5477().getString(), neko.getXpWithOwner(player.method_5667())));
            return 1;
        }
        catch (Exception e) {
            Bootstrap.LOGGER.error((Object)e);
            return 1;
        }
    }

    public static int AliasesRemove(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_3222 neko = (class_3222)context.getArgument("neko", class_3222.class);
            String aliases = StringArgumentType.getString(context, (String)"aliases");
            neko.getOwner(player.method_5667()).getAliases().remove(aliases);
            player.method_43496(TextUtil.translatable("command.toneko.aliases.remove", aliases));
            return 1;
        }
        catch (Exception e) {
            Bootstrap.LOGGER.error((Object)e);
            return 1;
        }
    }

    public static int AliasesAdd(CommandContext<class_2168> context) {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_3222 neko = (class_3222)context.getArgument("neko", class_3222.class);
            String aliases = StringArgumentType.getString(context, (String)"aliases");
            neko.getOwner(player.method_5667()).getAliases().add(aliases);
            player.method_43496(TextUtil.translatable("command.toneko.aliases.add", aliases));
            return 1;
        }
        catch (Exception e) {
            Bootstrap.LOGGER.error((Object)e);
            return 1;
        }
    }
}

