/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.regex.Pattern;
import net.minecraft.class_2561;

public class CustomStringArgument
implements ArgumentType<String> {
    private final Pattern pattern;
    private final boolean allowEmpty;
    public static final Pattern ALLOW_EMOJI = Pattern.compile("^.{1,40}$");

    private CustomStringArgument(Pattern pattern, boolean allowEmpty) {
        this.pattern = pattern;
        this.allowEmpty = allowEmpty;
    }

    public static CustomStringArgument blockWord() {
        return new CustomStringArgument(ALLOW_EMOJI, false);
    }

    public static CustomStringArgument replaceWord() {
        return new CustomStringArgument(ALLOW_EMOJI, true);
    }

    public static CustomStringArgument string(Pattern pattern) {
        return new CustomStringArgument(pattern, false);
    }

    public static CustomStringArgument string(Pattern pattern, boolean allowEmpty) {
        return new CustomStringArgument(pattern, allowEmpty);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        while (reader.canRead() && !Character.isWhitespace(reader.peek())) {
            reader.skip();
        }
        String result = reader.getString().substring(start, reader.getCursor());
        if (!this.allowEmpty && result.isEmpty()) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"\u8f93\u5165\u4e0d\u80fd\u4e3a\u7a7a")).create();
        }
        if (this.pattern == null || !this.pattern.matcher(result).matches()) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"\u8f93\u5165\u683c\u5f0f\u65e0\u6548")).create();
        }
        return result;
    }
}

