/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.commands.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class WordSuggestionProvider
implements SuggestionProvider<class_2168> {
    private final Types type;

    private WordSuggestionProvider(Types type) {
        this.type = type;
    }

    public static WordSuggestionProvider blockWord() {
        return new WordSuggestionProvider(Types.BLOCK);
    }

    public static WordSuggestionProvider aliases() {
        return new WordSuggestionProvider(Types.ALIASES);
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        class_2168 source = (class_2168)context.getSource();
        class_3222 commander = source.method_44023();
        class_3222 neko = (class_3222)context.getArgument("neko", class_3222.class);
        if (neko == null) {
            return builder.buildFuture();
        }
        if (!this.isValidNeko(neko, commander)) {
            return builder.buildFuture();
        }
        if (this.type == Types.BLOCK) {
            neko.getBlockedWords().forEach(blockWord -> {
                if (blockWord.replace().toLowerCase().startsWith(remaining)) {
                    builder.suggest(blockWord.replace());
                }
            });
        } else if (this.type == Types.ALIASES) {
            neko.getOwner(commander.method_5667()).getAliases().forEach(alias -> {
                if (alias.toLowerCase().startsWith(remaining)) {
                    builder.suggest(alias);
                }
            });
        }
        return builder.buildFuture();
    }

    private boolean isValidNeko(class_3222 neko, class_3222 commander) {
        if (!neko.isNeko()) {
            return false;
        }
        return commander != null && neko.hasOwner(commander.method_5667());
    }

    static enum Types {
        BLOCK,
        ALIASES;

    }
}

