/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import org.cneko.toneko.common.mod.misc.Messaging;
import org.cneko.toneko.common.mod.misc.ToNekoAttributes;
import org.cneko.toneko.common.mod.quirks.Quirk;
import org.cneko.toneko.common.mod.quirks.QuirkRegister;
import org.cneko.toneko.common.mod.util.EntityUtil;
import org.cneko.toneko.common.mod.util.ResourceLocationUtil;
import org.jetbrains.annotations.NotNull;

public interface INeko {
    public static final class_2960 ATTACK_MODIFIER_ID = ResourceLocationUtil.toNekoLoc("neko_level_attack_modifier");
    public static final class_2960 MAX_NEKO_ENERGY_MODIFIER_ID = ResourceLocationUtil.toNekoLoc("neko_level_max_neko_energy_modifier");
    public static final class_2960 MAX_HEALTH_MODIFIER_ID = ResourceLocationUtil.toNekoLoc("neko_level_max_health_modifier");

    default public class_1309 getEntity() {
        throw new RuntimeException("You should implements in your entity");
    }

    default public boolean isPlayer() {
        return this.getEntity() instanceof class_1657;
    }

    default public boolean allowMateIfNotNeko() {
        return false;
    }

    default public boolean isNeko() {
        return false;
    }

    default public void setNeko(boolean isNeko) {
    }

    default public int getNekoAbility() {
        return (int)((double)this.getNekoLevel() * this.getEntity().method_45325(ToNekoAttributes.NEKO_DEGREE));
    }

    default public float getNekoLevel() {
        return 0.0f;
    }

    default public void setNekoLevel(float level) {
    }

    default public float getMaxNekoEnergy() {
        return (float)this.getEntity().method_45325(ToNekoAttributes.MAX_NEKO_ENERGY);
    }

    default public float getNekoEnergy() {
        return 0.0f;
    }

    default public void setNekoEnergy(float energy) {
    }

    default public Owner getOwner(UUID uuid) {
        return this.getOwners().get(uuid);
    }

    default public void addOwner(UUID uuid, Owner owner) {
        this.getOwners().put(uuid, owner);
    }

    default public void addOwnerIfNotExist(UUID uuid) {
        if (!this.hasOwner(uuid)) {
            this.addOwner(uuid, new Owner(List.of(), 0));
        }
    }

    default public void removeOwner(UUID uuid) {
        this.getOwners().remove(uuid);
    }

    default public Map<UUID, Owner> getOwners() {
        return Map.of();
    }

    default public boolean hasOwner(UUID uuid) {
        return this.getOwners().containsKey(uuid);
    }

    default public int getXpWithOwner(UUID uuid) {
        return this.getOwner(uuid).getXp();
    }

    default public void setXpWithOwner(UUID uuid, int xp) {
        this.getOwner(uuid).setXp(xp);
    }

    default public List<BlockedWord> getBlockedWords() {
        return List.of();
    }

    default public void addBlockedWord(BlockedWord word) {
        if (!this.getBlockedWords().contains(word)) {
            this.getBlockedWords().add(word);
        }
    }

    default public void removeBlockedWord(String word) {
        this.getBlockedWords().removeIf(blockedWord -> blockedWord.block.equals(word));
    }

    @NotNull
    default public String getNickName() {
        return "";
    }

    default public void setNickName(String name) {
    }

    default public List<Quirk> getQuirks() {
        return List.of();
    }

    default public boolean hasQuirk(Quirk quirk) {
        return this.getQuirks().contains(quirk);
    }

    default public void addQuirk(Quirk quirk) {
        if (!this.hasQuirk(quirk)) {
            this.getQuirks().add(quirk);
        }
    }

    default public void removeQuirk(Quirk quirk) {
        this.getQuirks().remove(quirk);
    }

    default public void fixQuirks() {
        this.getQuirks().removeIf(quirk -> QuirkRegister.hasQuirk(quirk.getId()));
    }

    default public void saveNekoNBTData(@NotNull class_2487 nbt) {
        nbt.method_10556("IsNeko", this.isNeko());
        nbt.method_10549("NekoEnergy", (double)this.getNekoEnergy());
        nbt.method_10569("NekoLevel", (int)this.getNekoLevel());
        class_2487 owners = new class_2487();
        this.getOwners().forEach((uuid, owner) -> {
            class_2487 ownerInfo = new class_2487();
            ownerInfo.method_10569("Xp", owner.getXp());
            class_2499 aliasTags = new class_2499();
            owner.getAliases().stream().map(class_2519::method_23256).forEach(arg_0 -> aliasTags.add(arg_0));
            ownerInfo.method_10566("Aliases", (class_2520)aliasTags);
            owners.method_10566(uuid.toString(), (class_2520)ownerInfo);
        });
        nbt.method_10582("NickName", this.getNickName());
        nbt.method_10566("Owners", (class_2520)owners);
    }

    default public void loadNekoNBTData(@NotNull class_2487 nbt) {
        if (nbt.method_10545("IsNeko")) {
            this.setNeko(nbt.method_10577("IsNeko"));
        }
        if (nbt.method_10545("NekoEnergy")) {
            this.setNekoEnergy(nbt.method_10583("NekoEnergy"));
        }
        if (nbt.method_10545("NekoLevel")) {
            this.setNekoLevel(nbt.method_10583("NekoLevel"));
        }
        if (nbt.method_10545("Owners")) {
            class_2487 owners = nbt.method_10562("Owners");
            for (String key : owners.method_10541()) {
                class_2487 ownerInfo = owners.method_10562(key);
                List<Object> aliases = ownerInfo.method_10545("Aliases") ? ownerInfo.method_10554("Aliases", 8).stream().map(class_2520::toString).toList() : new ArrayList();
                int xp = ownerInfo.method_10545("Xp") ? ownerInfo.method_10550("Xp") : 0;
                this.addOwner(UUID.fromString(key), new Owner(aliases, xp));
            }
        }
        if (nbt.method_10545("NickName")) {
            this.setNickName(this.getNickName());
        }
    }

    default public void updateNekoLevelModifiers() {
        float nekoLevel = this.getNekoLevel();
        INeko.applyModifier(this.getEntity().method_5996(class_5134.field_23721), ATTACK_MODIFIER_ID, (double)nekoLevel * 0.005);
        INeko.applyModifier(this.getEntity().method_5996(ToNekoAttributes.MAX_NEKO_ENERGY), MAX_NEKO_ENERGY_MODIFIER_ID, nekoLevel * 2.0f);
        INeko.applyModifier(this.getEntity().method_5996(class_5134.field_23716), MAX_HEALTH_MODIFIER_ID, (double)nekoLevel * 0.02);
    }

    public static void applyModifier(class_1324 attr, class_2960 id, double bonus) {
        if (attr != null) {
            attr.method_6200(id);
            if (bonus > 0.0) {
                class_1322 modifier = new class_1322(id, bonus, class_1322.class_1323.field_6328);
                attr.method_26837(modifier);
            }
        }
    }

    default public void serverNekoSlowTick() {
        if (this.isNeko()) {
            this.increaseEnergy();
        }
    }

    default public void increaseEnergy() {
        float max = this.getMaxNekoEnergy();
        float energy = this.getNekoEnergy();
        if (energy >= max) {
            this.setNekoEnergy(max);
            return;
        }
        float increase = (float)((double)this.getNekoAbility() * 0.1);
        List<INeko> nekoes = EntityUtil.getNekoInRange((class_1297)this.getEntity(), this.getEntity().method_37908(), 3.0f);
        for (INeko neko : nekoes) {
            if (!neko.isNeko()) continue;
            increase += (float)((double)neko.getNekoAbility() * 0.05);
        }
        this.setNekoEnergy(energy + increase);
        if (this.getNekoEnergy() >= max) {
            this.setNekoEnergy(max);
        }
    }

    default public void sendMessageToTarget(String message, class_1297 target) {
        Messaging.modifyAndSendMessage(this, message, target);
    }

    default public void sendMessageToAll(String message) {
        Messaging.modifyAndSendMessageToAll(this, message);
    }

    public static class Owner {
        private List<String> aliases;
        private int xp;

        @Generated
        public List<String> getAliases() {
            return this.aliases;
        }

        @Generated
        public int getXp() {
            return this.xp;
        }

        @Generated
        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        @Generated
        public void setXp(int xp) {
            this.xp = xp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Owner)) {
                return false;
            }
            Owner other = (Owner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getXp() != other.getXp()) {
                return false;
            }
            List<String> this$aliases = this.getAliases();
            List<String> other$aliases = other.getAliases();
            return !(this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Owner;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getXp();
            List<String> $aliases = this.getAliases();
            result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "INeko.Owner(aliases=" + String.valueOf(this.getAliases()) + ", xp=" + this.getXp() + ")";
        }

        @Generated
        public Owner(List<String> aliases, int xp) {
            this.aliases = aliases;
            this.xp = xp;
        }
    }

    public record BlockedWord(String block, String replace, BlockMethod method) {

        public static enum BlockMethod {
            WORD("word"),
            ALL("all");

            private final String method;

            private BlockMethod(String word) {
                this.method = word;
            }

            public static BlockMethod fromString(String method) {
                for (BlockMethod value : BlockMethod.values()) {
                    if (!value.method.equals(method)) continue;
                    return value;
                }
                return null;
            }

            @Generated
            public String getMethod() {
                return this.method;
            }
        }
    }
}

