/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.entities;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.cneko.toneko.common.mod.entities.NekoEntity;
import org.jetbrains.annotations.NotNull;

public class NekoInventory
implements class_1263,
class_1275 {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    private static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int NOT_FOUND_INDEX = -1;
    public static final int[] ALL_ARMOR_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] HELMET_SLOT_ONLY = new int[]{3};
    public final class_2371<class_1799> items = class_2371.method_10213((int)36, (Object)class_1799.field_8037);
    public final class_2371<class_1799> armor = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public final class_2371<class_1799> offhand = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final List<class_2371<class_1799>> compartments = ImmutableList.of(this.items, this.armor, this.offhand);
    public int selected = 0;
    public final NekoEntity neko;
    private int timesChanged;

    public NekoInventory(NekoEntity neko) {
        this.neko = neko;
    }

    public class_1799 getSelected() {
        return NekoInventory.isHotbarSlot(this.selected) ? (class_1799)this.items.get(this.selected) : class_1799.field_8037;
    }

    public static int getSelectionSize() {
        return 9;
    }

    private boolean hasRemainingSpaceForItem(class_1799 destination, class_1799 origin) {
        return !destination.method_7960() && class_1799.method_31577((class_1799)destination, (class_1799)origin) && destination.method_7946() && destination.method_7947() < this.method_58350(destination);
    }

    public int getFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((class_1799)this.items.get(i)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public void setPickedItem(class_1799 stack) {
        int i = this.findSlotMatchingItem(stack);
        if (NekoInventory.isHotbarSlot(i)) {
            this.selected = i;
        } else if (i == -1) {
            int j;
            this.selected = this.getSuitableHotbarSlot();
            if (!((class_1799)this.items.get(this.selected)).method_7960() && (j = this.getFreeSlot()) != -1) {
                this.items.set(j, (Object)((class_1799)this.items.get(this.selected)));
            }
            this.items.set(this.selected, (Object)stack);
        } else {
            this.pickSlot(i);
        }
    }

    public void pickSlot(int index) {
        this.selected = this.getSuitableHotbarSlot();
        class_1799 itemStack = (class_1799)this.items.get(this.selected);
        this.items.set(this.selected, (Object)((class_1799)this.items.get(index)));
        this.items.set(index, (Object)itemStack);
    }

    public static boolean isHotbarSlot(int index) {
        return index >= 0 && index < 9;
    }

    public int findSlotMatchingItem(class_1799 stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((class_1799)this.items.get(i)).method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)this.items.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int findSlotMatchingUnusedItem(class_1799 stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (itemStack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || itemStack.method_7986() || itemStack.method_7942() || itemStack.method_57826(class_9334.field_49631)) continue;
            return i;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int j;
        int i;
        for (i = 0; i < 9; ++i) {
            j = (this.selected + i) % 9;
            if (!((class_1799)this.items.get(j)).method_7960()) continue;
            return j;
        }
        for (i = 0; i < 9; ++i) {
            j = (this.selected + i) % 9;
            if (((class_1799)this.items.get(j)).method_7942()) continue;
            return j;
        }
        return this.selected;
    }

    public void swapPaint(double direction) {
        int i = (int)Math.signum(direction);
        while (this.selected >= 9) {
            this.selected -= 9;
        }
    }

    private int addResource(class_1799 stack) {
        int i = this.getSlotWithRemainingSpace(stack);
        if (i == -1) {
            i = this.getFreeSlot();
        }
        return i == -1 ? stack.method_7947() : this.addResource(i, stack);
    }

    private int addResource(int slot, class_1799 stack) {
        int j;
        int k;
        int i = stack.method_7947();
        class_1799 itemStack = this.method_5438(slot);
        if (itemStack.method_7960()) {
            itemStack = stack.method_46651(0);
            this.method_5447(slot, itemStack);
        }
        if ((k = Math.min(i, j = this.method_58350(itemStack) - itemStack.method_7947())) != 0) {
            i -= k;
            itemStack.method_7933(k);
            itemStack.method_7912(5);
        }
        return i;
    }

    public int getSlotWithRemainingSpace(class_1799 stack) {
        if (this.hasRemainingSpaceForItem(this.method_5438(this.selected), stack)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.method_5438(40), stack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.hasRemainingSpaceForItem((class_1799)this.items.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void tick() {
        for (class_2371<class_1799> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                if (((class_1799)compartment.get(i)).method_7960()) continue;
                ((class_1799)compartment.get(i)).method_7917(this.neko.method_37908(), (class_1297)this.neko, i, this.selected == i);
            }
        }
    }

    public boolean add(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        for (class_1799 currentStack : this.items) {
            int maxStackSize;
            int availableSpace;
            if (currentStack.method_7960() || !class_1799.method_31577((class_1799)currentStack, (class_1799)stack) || (availableSpace = (maxStackSize = stack.method_7914()) - currentStack.method_7947()) <= 0) continue;
            int toAdd = Math.min(availableSpace, stack.method_7947());
            currentStack.method_7933(toAdd);
            stack.method_7934(toAdd);
            if (!stack.method_7960()) continue;
            return true;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((class_1799)this.items.get(i)).method_7960()) continue;
            this.items.set(i, (Object)stack.method_7972());
            stack.method_7939(0);
            return true;
        }
        return false;
    }

    public boolean add(int slot, class_1799 stack) {
        int i;
        block18: {
            block17: {
                if (stack.method_7960()) {
                    return false;
                }
                try {
                    if (stack.method_7986()) break block17;
                    do {
                        i = stack.method_7947();
                        if (slot == -1) {
                            stack.method_7939(this.addResource(stack));
                            continue;
                        }
                        stack.method_7939(this.addResource(slot, stack));
                    } while (!stack.method_7960() && stack.method_7947() < i);
                    if (stack.method_7947() == i && this.neko.method_56992()) {
                        stack.method_7939(0);
                        return true;
                    }
                    break block18;
                }
                catch (Throwable var10) {
                    Throwable throwable = var10;
                    class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Adding item to inventory");
                    class_129 crashReportCategory = crashReport.method_562("Item being added");
                    crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
                    crashReportCategory.method_578("Item data", (Object)stack.method_7919());
                    crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
                    throw new class_148(crashReport);
                }
            }
            try {
                if (slot == -1) {
                    slot = this.getFreeSlot();
                }
                if (slot >= 0) {
                    this.items.set(slot, (Object)stack.method_51164());
                    ((class_1799)this.items.get(slot)).method_7912(5);
                    return true;
                }
            }
            catch (Throwable var9) {
                Throwable throwable = var9;
                class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Adding item to inventory");
                class_129 crashReportCategory = crashReport.method_562("Item being added");
                crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
                crashReportCategory.method_578("Item data", (Object)stack.method_7919());
                crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
                throw new class_148(crashReport);
            }
            try {
                if (this.neko.method_56992()) {
                    stack.method_7939(0);
                    return true;
                }
            }
            catch (Throwable var8) {
                Throwable throwable = var8;
                class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Adding item to inventory");
                class_129 crashReportCategory = crashReport.method_562("Item being added");
                crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
                crashReportCategory.method_578("Item data", (Object)stack.method_7919());
                crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
                throw new class_148(crashReport);
            }
            try {
                return false;
            }
            catch (Throwable var7) {
                Throwable throwable = var7;
                class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Adding item to inventory");
                class_129 crashReportCategory = crashReport.method_562("Item being added");
                crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
                crashReportCategory.method_578("Item data", (Object)stack.method_7919());
                crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
                throw new class_148(crashReport);
            }
        }
        try {
            return stack.method_7947() < i;
        }
        catch (Throwable var6) {
            Throwable throwable = var6;
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Adding item to inventory");
            class_129 crashReportCategory = crashReport.method_562("Item being added");
            crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
            crashReportCategory.method_578("Item data", (Object)stack.method_7919());
            crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
            throw new class_148(crashReport);
        }
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_2371<class_1799> list = null;
        for (class_2371<class_1799> nonNullList : this.compartments) {
            if (slot < nonNullList.size()) {
                list = nonNullList;
                break;
            }
            slot -= nonNullList.size();
        }
        return list != null && !((class_1799)list.get(slot)).method_7960() ? class_1262.method_5430(list, (int)slot, (int)amount) : class_1799.field_8037;
    }

    public void removeItem(class_1799 stack) {
        block0: for (class_2371<class_1799> nonNullList : this.compartments) {
            for (int i = 0; i < nonNullList.size(); ++i) {
                if (nonNullList.get(i) != stack) continue;
                nonNullList.set(i, (Object)class_1799.field_8037);
                continue block0;
            }
        }
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        class_2371<class_1799> nonNullList = null;
        for (class_2371<class_1799> nonNullList2 : this.compartments) {
            if (slot < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            slot -= nonNullList2.size();
        }
        if (nonNullList != null && !((class_1799)nonNullList.get(slot)).method_7960()) {
            class_1799 itemStack = (class_1799)nonNullList.get(slot);
            nonNullList.set(slot, (Object)class_1799.field_8037);
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        class_2371<class_1799> nonNullList = null;
        for (class_2371<class_1799> nonNullList2 : this.compartments) {
            if (slot < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            slot -= nonNullList2.size();
        }
        if (nonNullList != null) {
            nonNullList.set(slot, (Object)stack);
        }
    }

    public float getDestroySpeed(class_2680 state) {
        return ((class_1799)this.items.get(this.selected)).method_7924(state);
    }

    public class_2499 save(class_2499 listTag) {
        class_2487 compoundTag;
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            if (((class_1799)this.items.get(i)).method_7960()) continue;
            compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)i);
            listTag.add((Object)((class_1799)this.items.get(i)).method_57376((class_7225.class_7874)this.neko.method_56673(), (class_2520)compoundTag));
        }
        for (i = 0; i < this.armor.size(); ++i) {
            if (((class_1799)this.armor.get(i)).method_7960()) continue;
            compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)(i + 100));
            listTag.add((Object)((class_1799)this.armor.get(i)).method_57376((class_7225.class_7874)this.neko.method_56673(), (class_2520)compoundTag));
        }
        for (i = 0; i < this.offhand.size(); ++i) {
            if (((class_1799)this.offhand.get(i)).method_7960()) continue;
            compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)(i + 150));
            listTag.add((Object)((class_1799)this.offhand.get(i)).method_57376((class_7225.class_7874)this.neko.method_56673(), (class_2520)compoundTag));
        }
        return listTag;
    }

    public void load(class_2499 listTag) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag = listTag.method_10602(i);
            int j = compoundTag.method_10571("Slot") & 0xFF;
            class_1799 itemStack = class_1799.method_57360((class_7225.class_7874)this.neko.method_56673(), (class_2520)compoundTag).orElse(class_1799.field_8037);
            if (j >= 0 && j < this.items.size()) {
                this.items.set(j, (Object)itemStack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemStack);
                continue;
            }
            if (j < 150 || j >= this.offhand.size() + 150) continue;
            this.offhand.set(j - 150, (Object)itemStack);
        }
    }

    public int method_5439() {
        return this.items.size() + this.armor.size() + this.offhand.size();
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            var1 = this.armor.iterator();
            do {
                if (var1.hasNext()) continue;
                var1 = this.offhand.iterator();
                do {
                    if (var1.hasNext()) continue;
                    return true;
                } while ((itemStack = (class_1799)var1.next()).method_7960());
                return false;
            } while ((itemStack = (class_1799)var1.next()).method_7960());
            return false;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        class_2371<class_1799> list = null;
        for (class_2371<class_1799> nonNullList : this.compartments) {
            if (slot < nonNullList.size()) {
                list = nonNullList;
                break;
            }
            slot -= nonNullList.size();
        }
        return list == null ? class_1799.field_8037 : (class_1799)list.get(slot);
    }

    @NotNull
    public class_2561 method_5477() {
        return class_2561.method_43471((String)"container.inventory");
    }

    public class_1799 getArmor(int slot) {
        return (class_1799)this.armor.get(slot);
    }

    public void dropAll() {
        for (class_2371<class_1799> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                class_1799 itemStack = (class_1799)compartment.get(i);
                if (itemStack.method_7960()) continue;
                this.neko.drop(itemStack, true, false);
                compartment.set(i, class_1799.field_8037);
            }
        }
    }

    public void method_5431() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    public boolean method_5443(class_1657 player) {
        return player.method_56094((class_1297)this.neko, 4.0);
    }

    public boolean contains(class_1799 stack) {
        for (class_2371<class_1799> compartment : this.compartments) {
            for (class_1799 itemStack : compartment) {
                if (itemStack.method_7960() || !class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(class_6862<class_1792> tag) {
        for (class_2371<class_1799> compartment : this.compartments) {
            for (class_1799 itemStack : compartment) {
                if (itemStack.method_7960() || !itemStack.method_31573(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Predicate<class_1799> predicate) {
        for (class_2371<class_1799> compartment : this.compartments) {
            for (class_1799 itemStack : compartment) {
                if (!predicate.test(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAdd() {
        for (class_2371<class_1799> compartment : this.compartments) {
            for (class_1799 stack : compartment) {
                if (!stack.method_7960()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFull() {
        return !this.canAdd();
    }

    public void method_5448() {
        for (class_2371<class_1799> compartment : this.compartments) {
            compartment.clear();
        }
    }

    public class_1799 removeFromSelected(boolean removeStack) {
        class_1799 itemStack = this.getSelected();
        return itemStack.method_7960() ? class_1799.field_8037 : this.method_5434(this.selected, removeStack ? itemStack.method_7947() : 1);
    }
}

