/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.entities.ai.goal;

import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1569;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import org.cneko.toneko.common.mod.entities.FightingNekoEntity;
import org.cneko.toneko.common.mod.entities.NekoEntity;
import org.cneko.toneko.common.mod.items.BazookaItem;

public class NekoAttackGoal
extends class_1352 {
    protected final NekoEntity neko;
    protected class_1309 target;
    private final class_4051 targetConditions;
    private static final double RANGED_ATTACK_RANGE = 15.0;
    private static final double MELEE_ATTACK_RANGE = 4.0;
    private static final double TARGETING_RANGE = 100.0;
    private static final double RANGED_MAINTAIN_DISTANCE = 10.0;
    protected int attackCooldown;
    protected int seeTime;
    protected int attackInterval = 20;

    public NekoAttackGoal(NekoEntity neko) {
        this.neko = neko;
        this.targetConditions = class_4051.method_36625().method_18418(100.0).method_36627();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        boolean hasWeapon;
        class_1309 revengeTarget = this.neko.method_6065();
        if (revengeTarget != null && revengeTarget.method_5805() && !revengeTarget.method_5722((class_1297)this.neko)) {
            this.target = revengeTarget;
            return true;
        }
        boolean bl = hasWeapon = this.hasUsableRangedWeapon() || this.hasMeleeWeapon();
        if (hasWeapon) {
            class_238 area = this.neko.method_5829().method_1014(100.0);
            List monsters = this.neko.method_37908().method_8390(class_1309.class, area, e -> e instanceof class_1569 && e.method_5805() && !e.method_5722((class_1297)this.neko));
            class_1309 closestVisible = null;
            double closestDistSq = Double.MAX_VALUE;
            for (class_1309 m : monsters) {
                double distSq;
                if (!this.neko.method_6057((class_1297)m) || !((distSq = this.neko.method_5858((class_1297)m)) < closestDistSq)) continue;
                closestVisible = m;
                closestDistSq = distSq;
            }
            this.target = closestVisible;
            return this.target != null;
        }
        this.target = null;
        return false;
    }

    public boolean method_6266() {
        if (this.target == null || !this.target.method_5805()) {
            return false;
        }
        if (this.neko.method_5858((class_1297)this.target) > 10000.0) {
            return false;
        }
        return this.neko.method_6057((class_1297)this.target) || this.neko.method_5858((class_1297)this.target) < 64.0;
    }

    public void method_6269() {
        this.neko.method_5942().method_6335((class_1297)this.target, this.neko.method_45325(class_5134.field_23719) * 1.2);
        this.attackCooldown = 0;
        this.seeTime = 0;
        this.neko.method_19540(true);
    }

    public void method_6270() {
        this.target = null;
        this.neko.method_5942().method_6340();
        this.neko.method_19540(false);
    }

    public void method_6268() {
        if (this.target == null || !this.target.method_5805()) {
            return;
        }
        this.neko.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
        double distanceSqr = this.neko.method_5858((class_1297)this.target);
        boolean canSee = this.neko.method_6057((class_1297)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        CombatStrategy strategy = this.determineCombatStrategy();
        if (strategy == CombatStrategy.FLEE) {
            this.fleeFromTarget();
            return;
        }
        if (strategy == CombatStrategy.RANGED) {
            this.switchToRangedWeapon();
        } else if (strategy == CombatStrategy.MELEE) {
            this.switchToMeleeWeapon();
        }
        if (canSee) {
            if (strategy == CombatStrategy.RANGED) {
                if (distanceSqr > 225.0) {
                    this.neko.method_5942().method_6335((class_1297)this.target, this.neko.method_45325(class_5134.field_23719) * 1.2);
                } else {
                    double currentDistance = Math.sqrt(distanceSqr);
                    if (currentDistance < 5.0) {
                        this.moveAwayFromTarget(2.0);
                    } else {
                        this.neko.method_5942().method_6340();
                    }
                }
            } else if (distanceSqr > 16.0) {
                this.neko.method_5942().method_6335((class_1297)this.target, this.neko.method_45325(class_5134.field_23719) * 1.2);
            } else {
                this.neko.method_5942().method_6340();
            }
        } else if (distanceSqr > 16.0) {
            this.neko.method_5942().method_6335((class_1297)this.target, this.neko.method_45325(class_5134.field_23719) * 1.1);
        }
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        if (this.attackCooldown == 0 && canSee) {
            if (strategy == CombatStrategy.MELEE && distanceSqr <= 16.0) {
                this.performMeleeAttack();
                this.attackCooldown = this.attackInterval;
            } else if (strategy == CombatStrategy.RANGED && distanceSqr <= 225.0) {
                this.performRangedAttack();
                this.attackCooldown = this.attackInterval * 2;
            }
        }
    }

    protected CombatStrategy determineCombatStrategy() {
        boolean hasRanged = this.hasUsableRangedWeapon();
        boolean hasMelee = this.hasMeleeWeapon();
        float selfHealthRatio = this.getHealthRatio((class_1309)this.neko);
        float targetHealthRatio = this.getHealthRatio(this.target);
        double armorValue = this.neko.method_6096();
        double fleeThreshold = 12.0 - armorValue;
        if ((double)this.neko.method_6032() < fleeThreshold) {
            return CombatStrategy.FLEE;
        }
        if (hasRanged && !hasMelee) {
            return CombatStrategy.RANGED;
        }
        if (!hasRanged && hasMelee) {
            return CombatStrategy.MELEE;
        }
        if (!hasRanged) {
            return targetHealthRatio <= selfHealthRatio ? CombatStrategy.MELEE : CombatStrategy.FLEE;
        }
        return targetHealthRatio > selfHealthRatio ? CombatStrategy.RANGED : CombatStrategy.MELEE;
    }

    protected float getHealthRatio(class_1309 entity) {
        return entity.method_6032() / entity.method_6063();
    }

    protected boolean hasUsableRangedWeapon() {
        boolean hasBazooka = false;
        class_1799 ba = class_1799.field_8037;
        for (int i = 0; i < this.neko.getInventory().method_5439(); ++i) {
            class_1799 stack = this.neko.getInventory().method_5438(i);
            if (!(stack.method_7909() instanceof BazookaItem)) continue;
            hasBazooka = true;
            ba = stack;
            break;
        }
        return hasBazooka && !this.findHarmfulAmmo(ba).method_7960();
    }

    protected boolean hasMeleeWeapon() {
        for (int i = 0; i < this.neko.getInventory().method_5439(); ++i) {
            class_1799 stack = this.neko.getInventory().method_5438(i);
            if (!stack.method_31573(FightingNekoEntity.MELEE_WEAPON) || stack.method_7909() instanceof BazookaItem) continue;
            return true;
        }
        return false;
    }

    protected void fleeFromTarget() {
        double dz;
        double dx = this.neko.method_23317() - this.target.method_23317();
        double distance = Math.sqrt(dx * dx + (dz = this.neko.method_23321() - this.target.method_23321()) * dz);
        if (distance > 0.0) {
            double fleeDistance = 10.0;
            double fleeX = this.neko.method_23317() + (dx /= distance) * fleeDistance;
            double fleeZ = this.neko.method_23321() + (dz /= distance) * fleeDistance;
            this.neko.method_5942().method_6337(fleeX, this.neko.method_23318(), fleeZ, this.neko.method_45325(class_5134.field_23719) * 1.1);
        }
    }

    private boolean hasRangedWeaponInInventory() {
        for (int i = 0; i < this.neko.getInventory().method_5439(); ++i) {
            class_1799 stack = this.neko.getInventory().method_5438(i);
            if (!(stack.method_7909() instanceof BazookaItem)) continue;
            return true;
        }
        return false;
    }

    private void moveAwayFromTarget(double distance) {
        double dz;
        double dx = this.neko.method_23317() - this.target.method_23317();
        double len = Math.sqrt(dx * dx + (dz = this.neko.method_23321() - this.target.method_23321()) * dz);
        if (len > 0.0) {
            double backX = this.neko.method_23317() + (dx /= len) * distance;
            double backZ = this.neko.method_23321() + (dz /= len) * distance;
            this.neko.method_5942().method_6337(backX, this.neko.method_23318(), backZ, this.neko.method_45325(class_5134.field_23719) * 1.1);
        }
    }

    protected void switchToRangedWeapon() {
        if (this.isUsingRangedWeapon()) {
            return;
        }
        for (int i = 0; i < this.neko.getInventory().method_5439(); ++i) {
            class_1799 stack = this.neko.getInventory().method_5438(i);
            if (!(stack.method_7909() instanceof BazookaItem)) continue;
            this.neko.getInventory().selected = i;
            this.neko.method_5673(class_1304.field_6173, stack);
            return;
        }
        this.switchToMeleeWeapon();
    }

    protected void switchToMeleeWeapon() {
        if (this.isUsingMeleeWeapon()) {
            return;
        }
        int i = 0;
        for (class_1799 stack : this.neko.getInventory().items) {
            ++i;
            if (!stack.method_31573(FightingNekoEntity.MELEE_WEAPON) || stack.method_7909() instanceof BazookaItem) continue;
            class_1799 oldStack = this.neko.getItemInHand();
            this.neko.method_5673(class_1304.field_6173, stack);
            this.neko.getInventory().method_5447(i, oldStack);
            return;
        }
    }

    private boolean isUsingMeleeWeapon() {
        class_1799 held = this.neko.getInventory().method_5438(this.neko.getInventory().selected);
        return held.method_31573(FightingNekoEntity.MELEE_WEAPON) && !(held.method_7909() instanceof BazookaItem);
    }

    private boolean isUsingRangedWeapon() {
        class_1799 held = this.neko.getInventory().getSelected();
        return held.method_7909() instanceof BazookaItem;
    }

    protected void performMeleeAttack() {
        this.neko.method_6121((class_1297)this.target);
    }

    protected void performRangedAttack() {
        double dx = this.target.method_23317() - this.neko.method_23317();
        double dz = this.target.method_23321() - this.neko.method_23321();
        float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        double dy = this.target.method_23318() - this.neko.method_23318();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float targetPitch = (float)(-Math.atan2(dy, horizontalDistance) * 57.29577951308232);
        this.neko.method_36456(targetYaw);
        this.neko.method_36457(targetPitch);
        this.neko.field_6241 = targetYaw;
        this.neko.field_6283 = targetYaw;
        class_1799 bazooka = this.neko.getInventory().getSelected();
        if (bazooka.method_7909() instanceof BazookaItem) {
            this.reloadIfNeeded(bazooka);
            class_1799 ammo = this.findHarmfulAmmo(bazooka);
            if (!ammo.method_7960()) {
                ((BazookaItem)bazooka.method_7909()).fire((class_1309)this.neko, bazooka, ammo);
            }
        }
    }

    protected void reloadIfNeeded(class_1799 bazooka) {
        BazookaItem bazookaItem = (BazookaItem)bazooka.method_7909();
        BazookaItem.Ammunition currentAmmo = bazookaItem.getAmmunition(bazooka);
        if (currentAmmo == null || !currentAmmo.isHarmful(bazooka, class_1799.field_8037)) {
            for (int i = 0; i < this.neko.getInventory().method_5439(); ++i) {
                BazookaItem.Ammunition ammo;
                class_1799 stack = this.neko.getInventory().method_5438(i);
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof BazookaItem.Ammunition) || !(ammo = (BazookaItem.Ammunition)class_17922).isHarmful(bazooka, stack)) continue;
                bazookaItem.setAmmunitionType(stack.method_7909(), bazooka);
                stack.method_7934(1);
                return;
            }
        }
    }

    protected class_1799 findHarmfulAmmo(class_1799 bazooka) {
        for (int i = 0; i < this.neko.getInventory().method_5439(); ++i) {
            BazookaItem.Ammunition item;
            class_1799 stack = this.neko.getInventory().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof BazookaItem.Ammunition) || !(item = (BazookaItem.Ammunition)class_17922).isHarmful(bazooka, stack)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    @Generated
    public class_1309 getTarget() {
        return this.target;
    }

    @Generated
    public void setTarget(class_1309 target) {
        this.target = target;
    }

    public static enum CombatStrategy {
        RANGED,
        MELEE,
        FLEE;

    }
}

