/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.entities.ai.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_8567;
import org.cneko.toneko.common.mod.entities.NekoEntity;

public class NekoCropGatheringGoal
extends class_1352 {
    private final NekoEntity neko;
    private final class_1937 level;
    private int cooldownTicks = 0;
    private class_2338 targetPos = null;
    private TargetType targetType = null;
    private final double SCAN_RADIUS = 10.0;
    private final double OPERATION_RADIUS = 2.0;
    private final int CHEST_SEARCH_RADIUS = 8;

    public NekoCropGatheringGoal(NekoEntity neko) {
        this.neko = neko;
        this.level = neko.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.neko.getGatheringPower() > 0;
    }

    public void method_6269() {
        this.cooldownTicks = 0;
        this.targetPos = null;
        this.targetType = null;
    }

    public void method_6270() {
        this.targetPos = null;
        this.targetType = null;
    }

    public void method_6268() {
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
            return;
        }
        if (this.neko.getGatheringPower() == 1) {
            this.depositCropsIntoNearbyChest();
            this.neko.consumeGatheringPower(1);
            this.cooldownTicks = 20;
            return;
        }
        if (this.targetPos != null) {
            double distanceSq = this.neko.method_5649((double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.5, (double)this.targetPos.method_10260() + 0.5);
            if (distanceSq <= 4.0) {
                boolean success = false;
                if (this.targetType == TargetType.HARVEST) {
                    success = this.attemptHarvestAt(this.targetPos);
                } else if (this.targetType == TargetType.PLANT) {
                    success = this.attemptPlantingAt(this.targetPos);
                }
                this.targetPos = null;
                this.targetType = null;
                if (success) {
                    this.neko.consumeGatheringPower(1);
                    this.cooldownTicks = 20;
                    return;
                }
            } else {
                this.neko.method_5942().method_6337((double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.5, (double)this.targetPos.method_10260() + 0.5, 0.3);
                this.cooldownTicks = 10;
                return;
            }
        }
        class_2338 foundTarget = null;
        TargetType foundType = null;
        class_238 scanBox = new class_238(this.neko.method_23317() - 10.0, this.neko.method_23318() - 10.0, this.neko.method_23321() - 10.0, this.neko.method_23317() + 10.0, this.neko.method_23318() + 10.0, this.neko.method_23321() + 10.0);
        for (class_2338 pos : class_2338.method_10094((int)((int)scanBox.field_1323), (int)((int)scanBox.field_1322), (int)((int)scanBox.field_1321), (int)((int)scanBox.field_1320), (int)((int)scanBox.field_1325), (int)((int)scanBox.field_1324))) {
            class_2302 crop;
            class_2680 state = this.level.method_8320(pos);
            if (state.method_26204() != class_2246.field_10362) continue;
            class_2338 above = pos.method_10084();
            class_2680 aboveState = this.level.method_8320(above);
            class_2248 class_22482 = aboveState.method_26204();
            if (class_22482 instanceof class_2302 && (crop = (class_2302)class_22482).method_9825(aboveState)) {
                foundTarget = above;
                foundType = TargetType.HARVEST;
                break;
            }
            if (!this.level.method_22347(above) || !this.hasSeedInInventory()) continue;
            foundTarget = above;
            foundType = TargetType.PLANT;
            break;
        }
        if (foundTarget != null) {
            double distanceSq = this.neko.method_5649((double)foundTarget.method_10263() + 0.5, (double)foundTarget.method_10264() + 0.5, (double)foundTarget.method_10260() + 0.5);
            if (distanceSq <= 4.0) {
                boolean success = foundType == TargetType.HARVEST ? this.attemptHarvestAt(foundTarget) : this.attemptPlantingAt(foundTarget);
                if (success) {
                    this.neko.consumeGatheringPower(1);
                    this.cooldownTicks = 20;
                    return;
                }
            } else {
                this.targetPos = foundTarget;
                this.targetType = foundType;
                this.neko.method_5942().method_6337((double)foundTarget.method_10263() + 0.5, (double)foundTarget.method_10264() + 0.5, (double)foundTarget.method_10260() + 0.5, 0.3);
                this.cooldownTicks = 10;
                return;
            }
        }
        this.depositCropsIntoNearbyChest();
        this.neko.consumeGatheringPower(1);
        this.cooldownTicks = 20;
    }

    private boolean attemptHarvestAt(class_2338 target) {
        class_2302 crop;
        class_2680 state = this.level.method_8320(target);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302 && (crop = (class_2302)class_22482).method_9825(state)) {
            this.level.method_8652(target, crop.method_9828(0), 3);
            class_1937 class_19372 = this.level;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_8567.class_8568 builder = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)target)).method_51874(class_181.field_1224, (Object)state).method_51877(class_181.field_1226, (Object)this.neko).method_51874(class_181.field_1229, (Object)class_1799.field_8037);
                List drops = state.method_26189(builder);
                for (class_1799 drop : drops) {
                    this.neko.addItem(drop);
                }
            }
            this.level.method_20290(2001, target, class_2248.method_9507((class_2680)state));
            return true;
        }
        return false;
    }

    private boolean attemptPlantingAt(class_2338 target) {
        class_2248 class_22482;
        class_1798 seedItem;
        class_2338 farmlandPos = target.method_10074();
        class_2680 farmlandState = this.level.method_8320(farmlandPos);
        if (farmlandState.method_26204() == class_2246.field_10362 && this.level.method_22347(target) && (seedItem = this.getSeedFromInventory()) != null && (class_22482 = seedItem.method_7711()) instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            class_2680 cropState = cropBlock.method_9564();
            this.level.method_8652(target, cropState, 3);
            this.removeSeedFromInventory(seedItem);
            return true;
        }
        return false;
    }

    private boolean hasSeedInInventory() {
        return this.getSeedFromInventory() != null;
    }

    private class_1798 getSeedFromInventory() {
        for (class_1799 stack : this.neko.getInventory().items) {
            class_1798 i;
            class_1792 class_17922;
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1798) || !((i = (class_1798)class_17922).method_7711() instanceof class_2302)) continue;
            return i;
        }
        return null;
    }

    private void removeSeedFromInventory(class_1798 seedItem) {
        for (int i = 0; i < this.neko.getInventory().items.size(); ++i) {
            class_1799 stack = (class_1799)this.neko.getInventory().items.get(i);
            if (stack.method_7960() || stack.method_7909() != seedItem) continue;
            stack.method_7934(1);
            if (stack.method_7947() <= 0) {
                this.neko.getInventory().items.set(i, (Object)class_1799.field_8037);
            }
            return;
        }
    }

    private boolean depositCropsIntoNearbyChest() {
        class_2338 nekoPos = this.neko.method_24515();
        class_1937 class_19372 = this.level;
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        Optional<class_2595> chestOpt = this.findNearbyChest(serverLevel, nekoPos, 8);
        if (chestOpt.isPresent()) {
            class_2595 chest = chestOpt.get();
            for (int i = 0; i < this.neko.getInventory().items.size(); ++i) {
                class_1799 chestStack;
                int slot;
                class_1799 depositStack = (class_1799)this.neko.getInventory().items.get(i);
                if (depositStack.method_7960()) continue;
                for (slot = 0; slot < chest.method_5439(); ++slot) {
                    int maxStack;
                    int availableSpace;
                    chestStack = chest.method_5438(slot);
                    if (chestStack.method_7960() || !class_1799.method_31577((class_1799)chestStack, (class_1799)depositStack) || (availableSpace = (maxStack = depositStack.method_7914()) - chestStack.method_7947()) <= 0) continue;
                    int depositCount = depositStack.method_7947();
                    if (depositCount <= availableSpace) {
                        chestStack.method_7933(depositCount);
                        depositStack.method_7939(0);
                    } else {
                        chestStack.method_7939(maxStack);
                        depositStack.method_7934(availableSpace);
                    }
                    chest.method_5447(slot, chestStack);
                    if (depositStack.method_7960()) break;
                }
                if (!depositStack.method_7960()) {
                    for (slot = 0; slot < chest.method_5439(); ++slot) {
                        chestStack = chest.method_5438(slot);
                        if (!chestStack.method_7960()) continue;
                        chest.method_5447(slot, depositStack.method_7972());
                        depositStack.method_7939(0);
                        break;
                    }
                }
                this.neko.getInventory().items.set(i, (Object)depositStack);
            }
            return true;
        }
        return false;
    }

    private Optional<class_2595> findNearbyChest(class_3218 level, class_2338 center, int radius) {
        class_2595 closestChest = null;
        double minDistanceSq = Double.MAX_VALUE;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 pos = center.method_10069(dx, dy, dz);
                    class_2586 blockEntity = level.method_8321(pos);
                    if (!(blockEntity instanceof class_2595)) continue;
                    class_2595 chest = (class_2595)blockEntity;
                    double distanceSq = center.method_10262((class_2382)pos);
                    if (!(distanceSq < minDistanceSq)) continue;
                    minDistanceSq = distanceSq;
                    closestChest = chest;
                }
            }
        }
        return Optional.ofNullable(closestChest);
    }

    private static enum TargetType {
        HARVEST,
        PLANT;

    }
}

