/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.entities.ai.goal;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4050;
import org.cneko.toneko.common.mod.api.EntityPoseManager;
import org.cneko.toneko.common.mod.entities.NekoEntity;

public class NekoSleepInBedGoal
extends class_1352 {
    private final NekoEntity neko;
    private final class_1937 level;
    private final class_1408 navigation;
    private class_2338 targetBedPos;
    private int cooldown;

    public NekoSleepInBedGoal(NekoEntity neko) {
        this.neko = neko;
        this.level = neko.method_37908();
        this.navigation = neko.method_5942();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (!this.shouldSleep()) {
            return false;
        }
        Optional<class_2338> bedPos = this.findNearbyBed();
        if (bedPos.isEmpty()) {
            return false;
        }
        this.targetBedPos = bedPos.get();
        return true;
    }

    public boolean method_6266() {
        return this.isSleeping() && this.shouldContinueSleeping();
    }

    public void method_6269() {
        this.navigation.method_6334(this.navigation.method_6348(this.targetBedPos, 1), 1.2);
        this.neko.method_5988().method_20248((double)this.targetBedPos.method_10263(), (double)this.targetBedPos.method_10264(), (double)this.targetBedPos.method_10260());
    }

    public void method_6268() {
        if (this.neko.method_5649(this.targetBedPos.method_10263(), this.targetBedPos.method_10264(), this.targetBedPos.method_10260()) < 2.5) {
            this.startSleeping();
        }
    }

    public void method_6270() {
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        this.targetBedPos = null;
        this.navigation.method_6340();
        this.cooldown = 200;
    }

    private boolean shouldSleep() {
        return this.isNightTime() && !this.neko.method_5799() && !this.neko.isSitting();
    }

    private boolean shouldContinueSleeping() {
        return this.isNightTime() || this.level.method_8546() || this.level.method_8419();
    }

    private boolean isNightTime() {
        long time = this.level.method_8532() % 24000L;
        return time > 12500L && time < 23000L;
    }

    private Optional<class_2338> findNearbyBed() {
        class_2338 currentPos = this.neko.method_24515();
        int range = 16;
        for (int x = -range; x <= range; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 pos = currentPos.method_10069(x, y, z);
                    class_2680 state = this.level.method_8320(pos);
                    if (!(state.method_26204() instanceof class_2244) || !this.level.method_22347(pos.method_10084())) continue;
                    return Optional.of(pos);
                }
            }
        }
        return Optional.empty();
    }

    private void startSleeping() {
        EntityPoseManager.setPose((class_1297)this.neko, class_4050.field_18078);
        this.neko.method_18402(this.targetBedPos);
        this.neko.method_5942().method_6340();
    }

    private void stopSleeping() {
        EntityPoseManager.remove((class_1297)this.neko);
        this.neko.method_18402(null);
    }

    private boolean isSleeping() {
        return this.neko.method_18376() == class_4050.field_18078;
    }
}

