/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.entities.boss.mouflet;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_5134;
import org.cneko.toneko.common.mod.entities.AmmunitionEntity;
import org.cneko.toneko.common.mod.entities.ToNekoEntities;
import org.cneko.toneko.common.mod.entities.ai.goal.NekoAttackGoal;
import org.cneko.toneko.common.mod.entities.boss.mouflet.MoufletNekoBoss;
import org.cneko.toneko.common.mod.items.BazookaItem;

public class MoufletAttackGoal
extends NekoAttackGoal {
    protected MoufletNekoBoss neko;

    public MoufletAttackGoal(MoufletNekoBoss neko) {
        super(neko);
        this.neko = (MoufletNekoBoss)((NekoAttackGoal)this).neko;
    }

    @Override
    public boolean method_6264() {
        if (this.neko.isPetMode() && this.target != null && this.neko.hasOwner(this.target.method_5667())) {
            return false;
        }
        if (this.neko.isCharmed()) {
            return false;
        }
        return super.method_6264();
    }

    @Override
    protected NekoAttackGoal.CombatStrategy determineCombatStrategy() {
        boolean hasRanged = this.hasUsableRangedWeapon();
        boolean hasMelee = this.hasMeleeWeapon();
        float selfHealthRatio = this.getHealthRatio((class_1309)this.neko);
        float targetHealthRatio = this.getHealthRatio(this.target);
        if (this.neko.method_6032() < 20.0f) {
            return NekoAttackGoal.CombatStrategy.FLEE;
        }
        if (hasRanged && hasMelee) {
            return targetHealthRatio > selfHealthRatio ? NekoAttackGoal.CombatStrategy.RANGED : NekoAttackGoal.CombatStrategy.MELEE;
        }
        if (hasRanged) {
            return NekoAttackGoal.CombatStrategy.RANGED;
        }
        if (hasMelee) {
            return NekoAttackGoal.CombatStrategy.MELEE;
        }
        return (double)targetHealthRatio - 0.3 <= (double)selfHealthRatio ? NekoAttackGoal.CombatStrategy.MELEE : NekoAttackGoal.CombatStrategy.FLEE;
    }

    @Override
    protected void fleeFromTarget() {
        if (this.neko.getNekoEnergy() > 0.1f) {
            double dx = this.neko.method_23317() - this.target.method_23317();
            double dz = this.neko.method_23321() - this.target.method_23321();
            double distance = Math.sqrt(dx * dx + dz * dz);
            if (this.neko.method_23318() - (double)this.neko.method_37908().method_8598(class_2902.class_2903.field_13202, this.neko.method_23312()).method_10264() < 3.0) {
                this.neko.method_18800(dx * 0.3, 0.2, dz * 0.3);
                this.neko.field_6017 = 0.0f;
                this.neko.setNekoEnergy(this.neko.getNekoEnergy() - 0.1f);
                return;
            }
            if (distance > 0.0) {
                this.neko.method_18800((dx /= distance) * 0.7, 0.0, (dz /= distance) * 0.7);
                this.neko.field_6017 = 0.0f;
                this.neko.setNekoEnergy(this.neko.getNekoEnergy() - 0.1f);
                this.neko.method_6092(new class_1293(class_1294.field_5906, 40, 0, true, false));
            }
        } else {
            super.fleeFromTarget();
        }
    }

    @Override
    public void method_6268() {
        if (this.target == null || !this.target.method_5805()) {
            return;
        }
        this.neko.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
        double distanceSqr = this.neko.method_5858((class_1297)this.target);
        boolean canSee = this.neko.method_6057((class_1297)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        NekoAttackGoal.CombatStrategy strategy = this.determineCombatStrategy();
        if (strategy == NekoAttackGoal.CombatStrategy.FLEE) {
            this.fleeFromTarget();
            return;
        }
        if (strategy == NekoAttackGoal.CombatStrategy.RANGED) {
            this.switchToRangedWeapon();
        } else if (strategy == NekoAttackGoal.CombatStrategy.MELEE) {
            this.switchToMeleeWeapon();
        }
        this.neko.method_5942().method_6335((class_1297)this.target, this.neko.method_45325(class_5134.field_23719) * 1.2);
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        if (this.attackCooldown == 0 && canSee) {
            if (strategy == NekoAttackGoal.CombatStrategy.MELEE && distanceSqr <= 16.0) {
                this.performMeleeAttack();
                this.attackCooldown = this.attackInterval;
            } else if (strategy == NekoAttackGoal.CombatStrategy.RANGED && distanceSqr <= 225.0) {
                this.performRangedAttack();
                this.attackCooldown = this.attackInterval * 2;
            }
        }
    }

    @Override
    protected void performRangedAttack() {
        double dx = this.target.method_23317() - this.neko.method_23317();
        double dz = this.target.method_23321() - this.neko.method_23321();
        float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        double dy = this.target.method_23318() - this.neko.method_23318();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float targetPitch = (float)(-Math.atan2(dy, horizontalDistance) * 57.29577951308232);
        this.neko.method_36456(targetYaw);
        this.neko.method_36457(targetPitch);
        this.neko.field_6241 = targetYaw;
        this.neko.field_6283 = targetYaw;
        class_1799 bazooka = this.neko.getInventory().getSelected();
        if (bazooka.method_7909() instanceof BazookaItem) {
            this.reloadIfNeeded(bazooka);
            class_1799 ammo = this.findHarmfulAmmo(bazooka);
            if (!ammo.method_7960()) {
                AmmunitionEntity projectile = new AmmunitionEntity(ToNekoEntities.AMMUNITION_ENTITY, this.neko.method_37908());
                projectile.setBazookaStack(bazooka);
                projectile.setAmmunitionStack(ammo);
                projectile.method_7432((class_1297)this.neko);
                projectile.setHomingTarget(this.target);
                class_243 spawnPos = this.neko.method_19538().method_1019(this.neko.method_5720().method_1021(0.5)).method_1031(0.0, (double)this.neko.method_5751(), 0.0);
                projectile.method_33574(spawnPos);
                class_243 lookAngle = this.neko.method_5720().method_1029();
                float speed = 2.0f;
                projectile.shootWithInitialPos(lookAngle.field_1352, lookAngle.field_1351, lookAngle.field_1350, speed, 0.0f);
                this.neko.method_37908().method_8649((class_1297)projectile);
                ammo.method_7934(1);
            }
        }
    }

    @Override
    public void method_6270() {
        this.neko.method_5942().method_6340();
        this.neko.method_19540(false);
    }
}

