/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.cneko.ai.core.AIResponse;
import org.cneko.toneko.common.api.Permissions;
import org.cneko.toneko.common.api.TickTasks;
import org.cneko.toneko.common.mod.api.EntityPoseManager;
import org.cneko.toneko.common.mod.entities.CrystalNekoEntity;
import org.cneko.toneko.common.mod.entities.INeko;
import org.cneko.toneko.common.mod.entities.NekoEntity;
import org.cneko.toneko.common.mod.misc.Messaging;
import org.cneko.toneko.common.mod.packets.MateWithCrystalNekoPayload;
import org.cneko.toneko.common.mod.packets.PlayerLeadByPlayerPayload;
import org.cneko.toneko.common.mod.packets.PluginDetectPayload;
import org.cneko.toneko.common.mod.packets.QuirkQueryPayload;
import org.cneko.toneko.common.mod.packets.TTSSendPayload;
import org.cneko.toneko.common.mod.packets.interactives.ChatWithNekoPayload;
import org.cneko.toneko.common.mod.packets.interactives.FollowOwnerPayload;
import org.cneko.toneko.common.mod.packets.interactives.GiftItemPayload;
import org.cneko.toneko.common.mod.packets.interactives.NekoMatePayload;
import org.cneko.toneko.common.mod.packets.interactives.NekoPosePayload;
import org.cneko.toneko.common.mod.packets.interactives.RideEntityPayload;
import org.cneko.toneko.common.mod.quirks.QuirkRegister;
import org.cneko.toneko.common.mod.util.PermissionUtil;
import org.cneko.toneko.common.mod.util.PlayerUtil;
import org.cneko.toneko.common.mod.util.TickTaskQueue;
import org.cneko.toneko.common.util.AIUtil;
import org.cneko.toneko.common.util.ConfigUtil;
import org.cneko.toneko.common.util.LanguageUtil;
import org.jetbrains.annotations.Nullable;

public class ToNekoNetworkEvents {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver(QuirkQueryPayload.ID, ToNekoNetworkEvents::onQuirkQueryNetWorking);
        ServerPlayNetworking.registerGlobalReceiver(GiftItemPayload.ID, ToNekoNetworkEvents::onGiftItem);
        ServerPlayNetworking.registerGlobalReceiver(FollowOwnerPayload.ID, ToNekoNetworkEvents::onFollowOwner);
        ServerPlayNetworking.registerGlobalReceiver(RideEntityPayload.ID, ToNekoNetworkEvents::onRideEntity);
        ServerPlayNetworking.registerGlobalReceiver(NekoPosePayload.ID, ToNekoNetworkEvents::onSetPose);
        ServerPlayNetworking.registerGlobalReceiver(NekoMatePayload.ID, ToNekoNetworkEvents::onBreed);
        ServerPlayNetworking.registerGlobalReceiver(ChatWithNekoPayload.ID, ToNekoNetworkEvents::onChatWithNeko);
        ServerPlayNetworking.registerGlobalReceiver(MateWithCrystalNekoPayload.ID, ToNekoNetworkEvents::onMateWithCrystalNeko);
        ServerPlayNetworking.registerGlobalReceiver(PlayerLeadByPlayerPayload.ID, ToNekoNetworkEvents::onPlayerLeadByPlayer);
        ServerPlayNetworking.registerGlobalReceiver(PluginDetectPayload.ID, (a, b) -> {});
    }

    public static void onPlayerLeadByPlayer(PlayerLeadByPlayerPayload payload, ServerPlayNetworking.Context context) {
        try {
            class_1657 holder = PlayerUtil.getPlayerByUUID(UUID.fromString(payload.holder()));
            class_1657 target = PlayerUtil.getPlayerByUUID(UUID.fromString(payload.target()));
            ServerPlayNetworking.send((class_3222)((class_3222)holder), (class_8710)new PlayerLeadByPlayerPayload(holder.method_5667().toString(), target.method_5667().toString()));
            ServerPlayNetworking.send((class_3222)((class_3222)target), (class_8710)new PlayerLeadByPlayerPayload(holder.method_5667().toString(), target.method_5667().toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void onMateWithCrystalNeko(MateWithCrystalNekoPayload mateWithCrystalNekoPayload, ServerPlayNetworking.Context context) {
        ToNekoNetworkEvents.processNekoInteractive(context.player(), mateWithCrystalNekoPayload.uuid(), neko -> {
            if (neko instanceof CrystalNekoEntity) {
                CrystalNekoEntity cneko = (CrystalNekoEntity)neko;
                cneko.tryMating((class_3218)neko.method_37908(), (INeko)context.player());
            }
        });
    }

    public static void onChatWithNeko(ChatWithNekoPayload payload, ServerPlayNetworking.Context context) {
        ToNekoNetworkEvents.processNekoInteractive(context.player(), payload.uuid(), neko -> {
            if (!ConfigUtil.isAIEnabled()) {
                context.player().method_43496((class_2561)class_2561.method_43471((String)"messages.toneko.ai.not_enabled"));
            } else {
                class_3222 player = context.player();
                AIUtil.sendMessage(neko.method_5667(), player.method_5667(), neko.generateAIPrompt((class_1657)context.player()), payload.message(), response -> {
                    if (ConfigUtil.isAIShowThink() && response.hasThink()) {
                        class_3218 world = (class_3218)neko.method_37908();
                        int totalDelay = ToNekoNetworkEvents.spawnFloatingText(neko, response, world);
                        TickTaskQueue task = new TickTaskQueue();
                        task.addTask(totalDelay, () -> {
                            String r = Messaging.format(response.getResponse(), neko, Collections.singletonList(LanguageUtil.prefix), ConfigUtil.getChatFormat());
                            player.method_43496((class_2561)class_2561.method_43470((String)r));
                        });
                        TickTasks.add(task);
                    } else {
                        String r = Messaging.format(response.getResponse(), neko, Collections.singletonList(LanguageUtil.prefix), ConfigUtil.getChatFormat());
                        context.player().method_43496((class_2561)class_2561.method_43470((String)r));
                    }
                    if (ConfigUtil.isAITTSEnabled()) {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new TTSSendPayload(response.getResponse()));
                    }
                });
            }
        });
    }

    public static List<String> splitText(String text, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        int currentLength = 0;
        StringBuilder currentLine = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int charLength;
            char c = text.charAt(i);
            if (c == '\n') {
                lines.add(currentLine.toString());
                currentLine.setLength(0);
                currentLength = 0;
                continue;
            }
            int n = charLength = Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == ',' || c == '?' || c == '!' || c == ';' || c == ':' || c == '\"' ? 1 : 2;
            if (currentLength + charLength > lineLength) {
                lines.add(currentLine.toString());
                currentLine.setLength(0);
                currentLength = 0;
            }
            currentLine.append(c);
            currentLength += charLength;
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static int spawnFloatingText(NekoEntity neko, AIResponse response, class_3218 world) {
        double baseY = neko.method_23318() + (double)neko.method_17682() + 0.5;
        double baseX = neko.method_23317();
        double baseZ = neko.method_23321();
        List<String> lines = null;
        if (response.getThink() != null) {
            lines = ToNekoNetworkEvents.splitText(response.getThink(), 40);
        }
        ArrayList<class_1531> armorStands = new ArrayList<class_1531>();
        int gap = 1;
        int cumulativeDelay = 0;
        if (lines != null) {
            int i = 0;
            while (i < lines.size()) {
                class_1531 lineStand = new class_1531((class_1937)world, baseX, baseY, baseZ);
                lineStand.method_5648(true);
                lineStand.method_5875(true);
                lineStand.method_6902(true);
                lineStand.method_5880(true);
                lineStand.method_5665((class_2561)class_2561.method_43470((String)""));
                world.method_8649((class_1297)lineStand);
                armorStands.add(lineStand);
                String line = lines.get(i);
                ToNekoNetworkEvents.animateLine(lineStand, line, cumulativeDelay);
                int currentIndex = i++;
                int lineEndTime = cumulativeDelay + line.length();
                TickTaskQueue moveUpQueue = new TickTaskQueue();
                moveUpQueue.addTask(lineEndTime, () -> {
                    for (int j = 0; j <= currentIndex; ++j) {
                        class_1531 as = (class_1531)armorStands.get(j);
                        as.method_5814(as.method_23317(), as.method_23318() + 0.3, as.method_23321());
                    }
                });
                TickTasks.add(moveUpQueue);
                cumulativeDelay += line.length() + gap;
            }
        }
        if (lines != null && !lines.isEmpty()) {
            int lastLineLength = lines.getLast().length();
            int lastLineEndTime = cumulativeDelay - gap + lastLineLength;
            int removalTime = lastLineEndTime + 100;
            TickTaskQueue removalQueue = new TickTaskQueue();
            removalQueue.addTask(removalTime, () -> {
                for (class_1531 as : armorStands) {
                    as.method_5650(class_1297.class_5529.field_26999);
                }
            });
            TickTasks.add(removalQueue);
        }
        TickTaskQueue syncQueue = new TickTaskQueue();
        int syncDuration = 0;
        if (lines != null) {
            syncDuration = !lines.isEmpty() ? cumulativeDelay - gap + lines.getLast().length() + 100 : 0;
        }
        syncQueue.addRepeatingTask(0, syncDuration, () -> {
            double currentBaseX = neko.method_23317();
            double currentBaseZ = neko.method_23321();
            for (class_1531 as : armorStands) {
                as.method_5814(currentBaseX, as.method_23318(), currentBaseZ);
            }
        });
        TickTasks.add(syncQueue);
        return cumulativeDelay;
    }

    private static void animateLine(class_1531 stand, String fullLine, int delayOffset) {
        int totalLength = fullLine.length();
        TickTaskQueue queue = new TickTaskQueue();
        for (int i = 0; i < totalLength; ++i) {
            int currentIndex = i;
            queue.addTask(delayOffset + i, () -> {
                String currentText = fullLine.substring(0, currentIndex + 1);
                stand.method_5665((class_2561)class_2561.method_43470((String)currentText).method_27692(class_124.field_1065));
            });
        }
        TickTasks.add(queue);
    }

    public static void onBreed(NekoMatePayload payload, ServerPlayNetworking.Context context) {
        ToNekoNetworkEvents.processNekoInteractive(context.player(), payload.uuid(), neko -> {
            INeko m;
            class_1297 mate = ToNekoNetworkEvents.findNearbyEntityByUuid(context.player(), UUID.fromString(payload.mateUuid()), 10.0);
            if (mate instanceof INeko && neko != (m = (INeko)mate)) {
                neko.tryMating((class_3218)context.player().method_37908(), m);
            }
        });
    }

    public static void onSetPose(NekoPosePayload payload, ServerPlayNetworking.Context context) {
        ToNekoNetworkEvents.processNekoInteractive(context.player(), payload.uuid(), neko -> {
            if (!EntityPoseManager.contains((class_1297)neko)) {
                EntityPoseManager.setPose((class_1297)neko, payload.pose());
            } else {
                EntityPoseManager.remove((class_1297)neko);
            }
        });
    }

    public static void onRideEntity(RideEntityPayload payload, ServerPlayNetworking.Context context) {
        ToNekoNetworkEvents.processNekoInteractive(context.player(), payload.uuid(), neko -> {
            class_1297 entity = ToNekoNetworkEvents.findNearbyEntityByUuid(context.player(), UUID.fromString(payload.vehicleUuid()), 5.0);
            if (entity != null) {
                if (neko.isSitting()) {
                    neko.method_5848();
                } else {
                    neko.method_5873(entity, true);
                    if (entity instanceof class_3222) {
                        class_3222 sp = (class_3222)entity;
                        sp.field_13987.method_14364((class_2596)new class_2752(entity));
                    }
                }
            }
        });
    }

    public static void onFollowOwner(FollowOwnerPayload payload, ServerPlayNetworking.Context context) {
        ToNekoNetworkEvents.processNekoInteractive(context.player(), payload.uuid(), neko -> neko.followOwner((class_1657)context.player()));
    }

    public static void onGiftItem(GiftItemPayload payload, ServerPlayNetworking.Context context) {
        ToNekoNetworkEvents.processNekoInteractive(context.player(), payload.uuid(), neko -> neko.giftItem((class_1657)context.player(), payload.slot()));
    }

    private static void processNekoInteractive(class_3222 player, String uuid, EntityFinder finder) {
        try {
            UUID targetUuid = UUID.fromString(uuid);
            NekoEntity nekoEntity = ToNekoNetworkEvents.findNearbyNekoByUuid(player, targetUuid, NekoEntity.DEFAULT_FIND_RANGE);
            if (nekoEntity != null && !(nekoEntity.method_5858((class_1297)player) > 64.0)) {
                finder.find(nekoEntity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void onQuirkQueryNetWorking(QuirkQueryPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        if (!PermissionUtil.has((class_1297)player, Permissions.COMMAND_QUIRK)) {
            return;
        }
        List quirks = player.getQuirks();
        quirks.clear();
        quirks.addAll(payload.getQuirks().stream().map(QuirkRegister::getById).toList());
    }

    private static class_1297 findNearbyEntityByUuid(class_3222 player, UUID targetUuid, double range) {
        class_3218 world = (class_3218)player.method_37908();
        return world.method_14190(targetUuid);
    }

    @Nullable
    public static NekoEntity findNearbyNekoByUuid(class_3222 player, UUID targetUuid, double range) {
        class_1297 entity = ToNekoNetworkEvents.findNearbyEntityByUuid(player, targetUuid, range);
        if (entity instanceof NekoEntity) {
            NekoEntity nekoEntity = (NekoEntity)entity;
            return nekoEntity;
        }
        return null;
    }

    @FunctionalInterface
    public static interface EntityFinder {
        public void find(NekoEntity var1);
    }
}

