/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.impl;

import java.nio.file.Path;
import java.util.List;
import org.cneko.toneko.common.Bootstrap;
import org.cneko.toneko.common.util.ConfigUtil;
import org.cneko.toneko.common.util.FileUtil;
import org.cneko.toneko.common.util.JsonConfiguration;
import org.cneko.toneko.common.util.LanguageUtil;

public class FabricLanguageImpl
implements LanguageUtil.Language {
    @Override
    public void load() {
        try {
            List<String> languages = List.of("en_us", "zh_cn", "zh_tw", "ko_kr");
            LanguageUtil.language = ConfigUtil.CONFIG.getString("language");
            FileUtil.CreatePath(LanguageUtil.LANG_PATH);
            for (String lang : languages) {
                FileUtil.DeleteFile(LanguageUtil.LANG_PATH + lang + ".json");
            }
            for (String lang : languages) {
                String file = LanguageUtil.LANG_PATH + lang + ".json";
                FileUtil.CreateFile(file);
                FileUtil.copyResource("assets/toneko/lang/" + lang + ".json", file);
            }
            LanguageUtil.LANG = JsonConfiguration.fromFile(Path.of(LanguageUtil.LANG_PATH + LanguageUtil.language + ".json", new String[0]));
            LanguageUtil.EN_US_LANG = JsonConfiguration.fromFile(Path.of(LanguageUtil.LANG_PATH + "en_us.json", new String[0]));
        }
        catch (Exception e) {
            LanguageUtil.LANG = JsonConfiguration.of("{}");
            Bootstrap.LOGGER.error("Failed to load language file", (Throwable)e);
        }
        LanguageUtil.phrase = this.translatable(LanguageUtil.LANG.getString("misc.toneko.nya"));
        LanguageUtil.prefix = this.translatable(LanguageUtil.LANG.getString("misc.toneko.prefix"));
    }
}

