/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.items;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.cneko.toneko.common.mod.entities.AmmunitionEntity;
import org.cneko.toneko.common.mod.entities.ToNekoEntities;
import org.cneko.toneko.common.mod.misc.ToNekoComponents;
import org.cneko.toneko.common.mod.misc.ToNekoSoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazookaItem
extends class_1792 {
    public static final String ID = "bazooka";
    private static final class_2960 EMPTY = class_2960.method_60656((String)"empty");

    public BazookaItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltips, tooltipFlag);
        Ammunition ammo = this.getAmmunition(stack);
        if (ammo instanceof class_1792) {
            class_1792 ammoItem = (class_1792)ammo;
            tooltips.add((class_2561)class_2561.method_43471((String)"item.toneko.bazooka.tip.ammo_type").method_27693(" ").method_10852(ammoItem.method_7848()));
        } else {
            tooltips.add((class_2561)class_2561.method_43471((String)"item.toneko.bazooka.tip.no_ammo"));
        }
        tooltips.add((class_2561)class_2561.method_43471((String)"item.toneko.bazooka.tip.reload"));
    }

    public boolean isAmmunitionLegal(class_1792 item) {
        return item instanceof Ammunition;
    }

    @Nullable
    public Ammunition getAmmunition(class_1799 stack) {
        Ammunition am;
        class_2960 res = (class_2960)stack.method_57825(ToNekoComponents.ITEM_ID_COMPONENT, (Object)EMPTY);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(res);
        return item instanceof Ammunition ? (am = (Ammunition)item) : null;
    }

    public class_1799 foundAmmunitionInventory(class_1657 shooter, Ammunition am) {
        for (class_1799 stack : shooter.method_31548().field_7547) {
            if (stack.method_7909() != am) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    @Nullable
    private Ammunition findNextAmmoType(class_1657 player, class_1799 bazookaStack) {
        ArrayList<Ammunition> availableAmmo = new ArrayList<Ammunition>();
        for (class_1799 stack : player.method_31548().field_7547) {
            Ammunition ammo;
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof Ammunition) || availableAmmo.contains(ammo = (Ammunition)class_17922)) continue;
            availableAmmo.add(ammo);
        }
        if (availableAmmo.isEmpty()) {
            return null;
        }
        Ammunition current = this.getAmmunition(bazookaStack);
        int currentIndex = current != null ? availableAmmo.indexOf(current) : -1;
        int nextIndex = (currentIndex + 1) % availableAmmo.size();
        return (Ammunition)availableAmmo.get(nextIndex);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 bazookaStack = player.method_5998(hand);
        if (player.method_5715()) {
            Ammunition newAmmo;
            if (!level.field_9236 && (newAmmo = this.findNextAmmoType(player, bazookaStack)) != null) {
                this.setAmmunitionType((class_1792)newAmmo, bazookaStack);
                player.method_7353((class_2561)class_2561.method_43471((String)"item.toneko.bazooka.reloaded").method_27693(" ").method_10852(((class_1792)newAmmo).method_7848()), true);
            }
        } else {
            if (!level.field_9236) {
                Ammunition ammoType = this.getAmmunition(bazookaStack);
                if (ammoType == null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"item.toneko.bazooka.no_ammo_selected"), true);
                    return class_1271.method_22431((Object)bazookaStack);
                }
                class_1799 ammoStack = this.foundAmmunitionInventory(player, ammoType);
                if (ammoStack.method_7960()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"item.toneko.bazooka.out_of_ammo"), true);
                    return class_1271.method_22431((Object)bazookaStack);
                }
                this.fire((class_1309)player, bazookaStack, ammoStack);
                player.method_7357().method_7906((class_1792)this, ammoType.getCooldownTicks(bazookaStack, ammoStack));
            }
            player.method_37908().method_8396(player, player.method_24515(), ToNekoSoundEvents.BAZOOKA_BIU, class_3419.field_15248, 1.0f, 1.0f);
        }
        return class_1271.method_22427((Object)bazookaStack);
    }

    public int method_7881(@NotNull class_1799 stack, @NotNull class_1309 entity) {
        return 0;
    }

    public void setAmmunitionType(class_1792 ammoItem, class_1799 bazookaStack) {
        if (ammoItem instanceof Ammunition) {
            class_2960 ammoId = class_7923.field_41178.method_10221((Object)ammoItem);
            bazookaStack.method_57379(ToNekoComponents.ITEM_ID_COMPONENT, (Object)ammoId);
        }
    }

    public class_1271<class_1799> reload(class_1657 player, class_1799 bazooka, class_1799 ammoStack) {
        if (ammoStack.method_7909() instanceof Ammunition) {
            this.setAmmunitionType(ammoStack.method_7909(), bazooka);
            if (!player.method_7337()) {
                ammoStack.method_7934(1);
            }
            return class_1271.method_22427((Object)bazooka);
        }
        return class_1271.method_22430((Object)bazooka);
    }

    public void fire(class_1309 shooter, class_1799 bazookaStack, class_1799 ammunition) {
        if (ammunition.method_7960()) {
            return;
        }
        class_1792 ammoItem = ammunition.method_7909();
        if (ammoItem instanceof Ammunition) {
            Ammunition ammo = (Ammunition)ammoItem;
            if (!shooter.method_37908().method_8608()) {
                class_1657 player;
                if (shooter instanceof class_1657 && !(player = (class_1657)shooter).method_7337() || !(shooter instanceof class_1657)) {
                    ammunition.method_7934(1);
                }
                AmmunitionEntity projectile = new AmmunitionEntity(ToNekoEntities.AMMUNITION_ENTITY, shooter.method_37908());
                projectile.setBazookaStack(bazookaStack);
                projectile.setAmmunitionStack(ammunition);
                projectile.method_7432((class_1297)shooter);
                class_243 spawnPos = shooter.method_19538().method_1019(shooter.method_5720().method_1021(0.5)).method_1031(0.0, (double)shooter.method_5751(), 0.0);
                projectile.method_33574(spawnPos);
                float inaccuracy = 1.0f - shooter.method_36455() / 90.0f;
                class_243 lookAngle = shooter.method_5720().method_1029();
                float speed = ammo.getSpeed(bazookaStack, ammunition) * 1.5f;
                projectile.shootWithInitialPos(lookAngle.field_1352, lookAngle.field_1351, lookAngle.field_1350, speed, inaccuracy);
                shooter.method_37908().method_8649((class_1297)projectile);
            }
        }
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        if (enchantment.method_40225(class_1893.field_9120)) {
            return true;
        }
        return super.canBeEnchantedWith(stack, enchantment, context);
    }

    public boolean method_7870(@NotNull class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 10;
    }

    public static interface Ammunition {
        public void hitOnEntity(class_1309 var1, class_1309 var2, class_1799 var3, class_1799 var4);

        public void hitOnBlock(class_1309 var1, class_2338 var2, class_1799 var3, class_1799 var4);

        public void hitOnAir(class_1309 var1, class_2338 var2, class_1799 var3, class_1799 var4);

        default public float getSpeed(class_1799 bazooka, class_1799 ammunition) {
            return 1.0f;
        }

        default public float getMaxDistance(class_1799 bazooka, class_1799 ammunition) {
            return 32.0f;
        }

        default public int getCooldownTicks(class_1799 bazooka, class_1799 ammunition) {
            return 20;
        }

        default public boolean isHarmful(class_1799 bazooka, class_1799 ammunition) {
            return false;
        }
    }
}

