/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import org.cneko.toneko.common.mod.api.events.ChatEvents;
import org.cneko.toneko.common.mod.entities.INeko;
import org.cneko.toneko.common.mod.events.CommonChatEvent;
import org.cneko.toneko.common.mod.util.PlayerUtil;
import org.cneko.toneko.common.util.ConfigUtil;
import org.cneko.toneko.common.util.LanguageUtil;

public class Messaging {
    private static final String PREFIX_FORMAT = "[\u00a7a%s\u00a7f\u00a7r]";

    public static void modifyAndSendMessage(INeko sender, String message, class_1297 target) {
        message = Messaging.nekoModify(message, sender);
        message = CommonChatEvent.modify(message, sender);
        String chatFormat = ConfigUtil.getChatFormat();
        List<String> prefixes = Messaging.getChatPrefixes(sender);
        String formattedMessage = Messaging.format(message, sender, prefixes, chatFormat);
        target.method_43496((class_2561)class_2561.method_43470((String)formattedMessage));
    }

    public static void modifyAndSendMessageToAll(INeko sender, String message) {
        message = Messaging.nekoModify(message, sender);
        message = CommonChatEvent.modify(message, sender);
        String chatFormat = ConfigUtil.getChatFormat();
        List<String> prefixes = Messaging.getChatPrefixes(sender);
        String formattedMessage = Messaging.format(message, sender, prefixes, chatFormat);
        for (class_1657 class_16572 : PlayerUtil.getPlayerList()) {
            class_16572.method_43496((class_2561)class_2561.method_43470((String)message));
        }
    }

    public static String format(String message, INeko sender, List<String> prefixes, String chatFormat) {
        Object nickname = sender.getNickName();
        nickname = ((String)nickname).isBlank() ? sender.getEntity().method_5477().getString() : "\u00a76~\u00a7f" + (String)nickname;
        message = ((ChatEvents.OnChatFormat)ChatEvents.ON_CHAT_FORMAT.invoker()).onFormat(message, sender, prefixes, chatFormat);
        return chatFormat.replace("%prefix%", Messaging.formatPrefixes(prefixes)).replace("%msg%", message).replace("%name%", (CharSequence)nickname).replace("%c%", "\u00a7");
    }

    public static List<String> getChatPrefixes(INeko sender) {
        ArrayList<String> prefixes = new ArrayList<String>();
        if (sender.isNeko()) {
            prefixes.add(LanguageUtil.prefix);
        }
        ((ChatEvents.CreateChatPrefixes)ChatEvents.CREATE_CHAT_PREFIXES.invoker()).onCreate(sender, prefixes);
        return prefixes;
    }

    public static String replacePhrase(String message, String phrase) {
        return PhraseProcessor.runPetPhrases(message, phrase);
    }

    private static String formatPrefixes(List<String> prefixes) {
        StringBuilder formatted = new StringBuilder();
        for (String prefix : prefixes) {
            formatted.append(String.format(PREFIX_FORMAT, prefix));
        }
        return formatted.toString();
    }

    public static String nekoModify(String message, INeko neko) {
        for (INeko.BlockedWord block : neko.getBlockedWords()) {
            if (!message.contains(block.block())) continue;
            if (block.method() == INeko.BlockedWord.BlockMethod.ALL) {
                message = block.replace();
                break;
            }
            if (block.method() != INeko.BlockedWord.BlockMethod.WORD) continue;
            message = message.replace(block.block(), block.replace());
        }
        String phrase = LanguageUtil.translatable(LanguageUtil.phrase);
        if (neko.isNeko()) {
            message = Messaging.replacePhrase(message, phrase);
        }
        message = CommonChatEvent.modify(message, neko);
        return message;
    }

    public static class PhraseProcessor {
        private static final Set<Character> PUNCTUATIONS = Set.of(Character.valueOf('.'), Character.valueOf(','), Character.valueOf('?'), Character.valueOf('!'), Character.valueOf('\u3002'), Character.valueOf('\uff0c'), Character.valueOf('\uff1f'), Character.valueOf('\uff01'));
        private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();
        private static final double REPLACE_PROBABILITY = 0.4;

        public static String replaceCharWithRandom(String text, char targetChar, String replacement, double probability) {
            if (text.isEmpty() || probability <= 0.0) {
                return text;
            }
            return IntStream.range(0, text.length()).collect(StringBuilder::new, (sb, i) -> {
                char c = text.charAt(i);
                if (c == targetChar && RANDOM.nextDouble() < probability) {
                    sb.append(replacement);
                } else {
                    sb.append(c);
                }
            }, StringBuilder::append).toString();
        }

        public static String runPetPhrases(String text, String petPhrase) {
            if (text.isEmpty() || petPhrase.isEmpty()) {
                return text;
            }
            text = PhraseProcessor.processTextEnding(text, petPhrase);
            return PUNCTUATIONS.parallelStream().filter(punct -> !petPhrase.endsWith(String.valueOf(punct))).reduce(text, (current, punct) -> PhraseProcessor.replaceCharWithRandom(current, punct.charValue(), petPhrase + punct, 0.4), (s1, s2) -> s2);
        }

        private static String processTextEnding(String text, String petPhrase) {
            return Optional.of(text).filter(t -> !t.endsWith(petPhrase)).map(t -> {
                char lastChar = t.charAt(t.length() - 1);
                return PUNCTUATIONS.contains(Character.valueOf(lastChar)) ? t.substring(0, t.length() - 1) + petPhrase + lastChar : t + petPhrase;
            }).orElse(text);
        }
    }
}

