/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.recipes;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_9695;

public class NekoAggregatorInput
implements class_9695 {
    public static final NekoAggregatorInput EMPTY = new NekoAggregatorInput(0, 0, List.of(), 0.0);
    private final int width;
    private final int height;
    private final List<class_1799> items;
    private final class_1662 stackedContents = new class_1662();
    private final int ingredientCount;
    private final double energy;

    private NekoAggregatorInput(int width, int height, List<class_1799> item, double energy) {
        this.width = width;
        this.height = height;
        this.items = item;
        this.energy = energy;
        int i = 0;
        for (class_1799 itemStack : item) {
            if (itemStack.method_7960()) continue;
            ++i;
            this.stackedContents.method_20478(itemStack, 1);
        }
        this.ingredientCount = i;
    }

    public static NekoAggregatorInput of(int width, int height, List<class_1799> items, double energy) {
        return NekoAggregatorInput.ofPositioned(width, height, items, energy).input();
    }

    public static Positioned ofPositioned(int width, int height, List<class_1799> items, double energy) {
        if (width != 0 && height != 0) {
            int m;
            int i = width - 1;
            int j = 0;
            int k = height - 1;
            int l = 0;
            for (m = 0; m < height; ++m) {
                boolean bl = true;
                for (int n = 0; n < width; ++n) {
                    class_1799 itemStack = items.get(n + m * width);
                    if (itemStack.method_7960()) continue;
                    i = Math.min(i, n);
                    j = Math.max(j, n);
                    bl = false;
                }
                if (bl) continue;
                k = Math.min(k, m);
                l = Math.max(l, m);
            }
            m = j - i + 1;
            int o = l - k + 1;
            if (m > 0 && o > 0) {
                if (m == width && o == height) {
                    return new Positioned(new NekoAggregatorInput(width, height, items, energy), i, k);
                }
                ArrayList<class_1799> list = new ArrayList<class_1799>(m * o);
                for (int p = 0; p < o; ++p) {
                    for (int q = 0; q < m; ++q) {
                        int r = q + i + (p + k) * width;
                        list.add(items.get(r));
                    }
                }
                return new Positioned(new NekoAggregatorInput(m, o, list, energy), i, k);
            }
            return Positioned.EMPTY;
        }
        return Positioned.EMPTY;
    }

    public class_1799 method_59984(int index) {
        return this.items.get(index);
    }

    public class_1799 getItem(int row, int column) {
        return this.items.get(row + column * this.width);
    }

    public int method_59983() {
        return this.items.size();
    }

    public boolean method_59987() {
        return this.ingredientCount == 0;
    }

    public class_1662 stackedContents() {
        return this.stackedContents;
    }

    public List<class_1799> items() {
        return this.items;
    }

    public int ingredientCount() {
        return this.ingredientCount;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NekoAggregatorInput)) {
            return false;
        }
        NekoAggregatorInput craftingInput = (NekoAggregatorInput)object;
        return this.width == craftingInput.width && this.height == craftingInput.height && this.ingredientCount == craftingInput.ingredientCount && class_1799.method_57362(this.items, craftingInput.items);
    }

    public int hashCode() {
        int i = class_1799.method_57361(this.items);
        i = 31 * i + this.width;
        i = 31 * i + this.height;
        return i;
    }

    @Generated
    public double getEnergy() {
        return this.energy;
    }

    public record Positioned(NekoAggregatorInput input, int left, int top) {
        public static final Positioned EMPTY = new Positioned(EMPTY, 0, 0);
    }
}

