/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.recipes;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.cneko.toneko.common.mod.recipes.NekoAggregatorInput;

public class NekoAggregatorRecipePattern {
    private static final int MAX_SIZE = 3;
    public static final MapCodec<NekoAggregatorRecipePattern> MAP_CODEC = Data.MAP_CODEC.flatXmap(NekoAggregatorRecipePattern::unpack, shapedRecipePattern -> shapedRecipePattern.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final class_9139<class_9129, NekoAggregatorRecipePattern> STREAM_CODEC = class_9139.method_56438(NekoAggregatorRecipePattern::toNetwork, NekoAggregatorRecipePattern::fromNetwork);
    private final int width;
    private final int height;
    private final class_2371<class_1856> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public NekoAggregatorRecipePattern(int width, int height, class_2371<class_1856> ingredients, Optional<Data> data) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.data = data;
        int i = 0;
        for (class_1856 ingredient : ingredients) {
            if (ingredient.method_8103()) continue;
            ++i;
        }
        this.ingredientCount = i;
        this.symmetrical = class_156.method_59901((int)width, (int)height, ingredients);
    }

    public static NekoAggregatorRecipePattern of(Map<Character, class_1856> key, String ... pattern) {
        return NekoAggregatorRecipePattern.of(key, List.of(pattern));
    }

    public static NekoAggregatorRecipePattern of(Map<Character, class_1856> key, List<String> pattern) {
        Data data = new Data(key, pattern);
        return (NekoAggregatorRecipePattern)NekoAggregatorRecipePattern.unpack(data).getOrThrow();
    }

    private static DataResult<NekoAggregatorRecipePattern> unpack(Data data) {
        String[] strings = NekoAggregatorRecipePattern.shrink(data.pattern);
        int i = strings[0].length();
        int j = strings.length;
        class_2371 nonNullList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
        CharArraySet charSet = new CharArraySet(data.key.keySet());
        for (int k = 0; k < strings.length; ++k) {
            String string = strings[k];
            for (int l = 0; l < string.length(); ++l) {
                class_1856 ingredient;
                char c = string.charAt(l);
                class_1856 class_18562 = ingredient = c == ' ' ? class_1856.field_9017 : data.key.get(Character.valueOf(c));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                }
                charSet.remove(c);
                nonNullList.set(l + i * k, (Object)ingredient);
            }
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> NekoAggregatorRecipePattern.lambda$unpack$1((CharSet)charSet));
        }
        return DataResult.success((Object)new NekoAggregatorRecipePattern(i, j, (class_2371<class_1856>)nonNullList, Optional.of(data)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.size(); ++m) {
            String string = pattern.get(m);
            i = Math.min(i, NekoAggregatorRecipePattern.firstNonSpace(string));
            int n = NekoAggregatorRecipePattern.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.size() == l) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = pattern.get(o + k).substring(i, j + 1);
        }
        return strings;
    }

    private static int firstNonSpace(String row) {
        int i;
        for (i = 0; i < row.length() && row.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String row) {
        int i;
        for (i = row.length() - 1; i >= 0 && row.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public boolean matches(NekoAggregatorInput input) {
        if (input.ingredientCount() == this.ingredientCount && input.width() == this.width && input.height() == this.height) {
            if (!this.symmetrical && this.matches(input, true)) {
                return true;
            }
            return this.matches(input, false);
        }
        return false;
    }

    private boolean matches(NekoAggregatorInput input, boolean symmetrical) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                class_1799 itemStack;
                class_1856 ingredient = symmetrical ? (class_1856)this.ingredients.get(this.width - j - 1 + i * this.width) : (class_1856)this.ingredients.get(j + i * this.width);
                if (ingredient.method_8093(itemStack = input.getItem(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    private void toNetwork(class_9129 buffer) {
        buffer.method_10804(this.width);
        buffer.method_10804(this.height);
        for (class_1856 ingredient : this.ingredients) {
            class_1856.field_48355.encode((Object)buffer, (Object)ingredient);
        }
    }

    private static NekoAggregatorRecipePattern fromNetwork(class_9129 buffer) {
        int i = buffer.method_10816();
        int j = buffer.method_10816();
        class_2371 nonNullList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
        nonNullList.replaceAll(ingredient -> (class_1856)class_1856.field_48355.decode((Object)buffer));
        return new NekoAggregatorRecipePattern(i, j, (class_2371<class_1856>)nonNullList, Optional.empty());
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public class_2371<class_1856> ingredients() {
        return this.ingredients;
    }

    private static /* synthetic */ String lambda$unpack$1(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
    }

    public record Data(Map<Character, class_1856> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(list -> {
            if (list.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (list.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)list.getFirst()).length();
            for (String string : list) {
                if (string.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (i == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)list);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(string -> {
            if (string.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + string + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(string) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(string.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.method_53703(SYMBOL_CODEC, (Codec)class_1856.field_46096).fieldOf("key").forGetter(data -> data.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)).apply((Applicative)instance, Data::new));
    }
}

