/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.cneko.toneko.common.mod.util.ITickable;

public class TickTaskQueue
implements ITickable {
    private final PriorityQueue<TickTask> tasks = new PriorityQueue<TickTask>(Comparator.comparingInt(t -> t.executeTick));
    private final AtomicInteger currentTick = new AtomicInteger(0);
    private int lastExecutionTick = 0;

    public void addTask(int delayTicks, Runnable task) {
        int executeTick = this.lastExecutionTick + delayTicks;
        this.tasks.offer(new TickTask(executeTick, task));
    }

    public void addTick() {
        this.addTick(1);
    }

    @Override
    public void addTick(int ticks) {
        this.currentTick.addAndGet(ticks);
        while (!this.tasks.isEmpty() && this.currentTick.get() >= this.tasks.peek().executeTick) {
            TickTask nextTask = this.tasks.poll();
            nextTask.runTask();
            this.lastExecutionTick = this.currentTick.get();
        }
    }

    @Override
    public void addRemoveTask() {
        while (!this.tasks.isEmpty() && this.currentTick.get() >= this.tasks.peek().executeTick) {
            this.tasks.poll();
        }
    }

    public void addRepeatingTask(int delayTicks, int durationTicks, Runnable task) {
        int startTick = this.lastExecutionTick + delayTicks;
        int endTick = startTick + durationTicks;
        for (int tick = startTick; tick < endTick; ++tick) {
            this.tasks.offer(new TickTask(tick, task));
        }
    }

    @Override
    public boolean isRemoved() {
        return this.tasks.isEmpty();
    }

    public void clear() {
        this.tasks.clear();
    }

    private static class TickTask {
        int executeTick;
        Runnable task;

        TickTask(int executeTick, Runnable task) {
            this.executeTick = executeTick;
            this.task = task;
        }

        void runTask() {
            this.task.run();
        }
    }
}

