/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cneko.ai.NekoLogger;
import org.cneko.ai.core.AIHistory;
import org.cneko.ai.core.AIRequest;
import org.cneko.ai.core.AIResponse;
import org.cneko.ai.core.NetworkingProxy;
import org.cneko.ai.providers.AbstractAIConfig;
import org.cneko.ai.providers.AbstractNettyAIService;
import org.cneko.ai.providers.gemini.GeminiConfig;
import org.cneko.ai.providers.gemini.GeminiService;
import org.cneko.ai.providers.openai.OpenAIConfig;
import org.cneko.ai.providers.openai.OpenAIService;
import org.cneko.ai.util.FileStorageUtil;
import org.cneko.toneko.common.Bootstrap;
import org.cneko.toneko.common.util.ConfigUtil;
import org.cneko.toneko.common.util.HttpClient;

public class AIUtil {
    private static final ExecutorService executor = Executors.newFixedThreadPool(100, r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        return thread;
    });
    private static final int MAX_MESSAGE_COUNT = 30;
    private static final int REQUEST_TIMEOUT = 60;

    public static void init() {
        if (!ConfigUtil.isAIEnabled()) {
            executor.submit(() -> {
                HttpClient client = new HttpClient();
                CompletableFuture<String> response = client.sendGet("http://localhost:4315/v1/health", null, String.class);
                response.whenComplete((response1, throwable) -> {
                    boolean canUseElefant;
                    boolean bl = canUseElefant = throwable == null;
                    if (canUseElefant) {
                        ConfigUtil.CONFIG.set("ai.service", "player2");
                        ConfigUtil.CONFIG.set("ai.enable", true);
                        ConfigUtil.CONFIG.set("ai.tts.enable", true);
                        ConfigUtil.CONFIG.set("ai.tts.service", "player2");
                        Bootstrap.LOGGER.info("Found Elefant running,set AI to Flefant");
                    }
                });
                response.join();
            });
        }
    }

    public static void sendMessage(UUID uuid, UUID userUuid, String prompt, String message, MessageCallback callback) {
        Future<?> future = executor.submit(() -> {
            try {
                CNekoAIService service;
                GeminiConfig config;
                String s = ConfigUtil.getAIService();
                String model = ConfigUtil.getAIModel();
                String key = ConfigUtil.getAIKey();
                String proxyIp = ConfigUtil.getAIProxyIp();
                String proxyPort = ConfigUtil.getAIProxyPort();
                String uuidStr = uuid.toString();
                String userUuidStr = userUuid.toString();
                boolean useProxy = ConfigUtil.isAIProxyEnabled();
                NetworkingProxy proxy = null;
                if (proxyPort != null && !proxyIp.isEmpty()) {
                    proxy = new NetworkingProxy(proxyIp, Integer.parseInt(proxyPort));
                } else {
                    useProxy = false;
                }
                AIResponse response = null;
                if (s.equalsIgnoreCase("neko")) {
                    config = new GeminiConfig(key);
                    if (useProxy) {
                        config.setProxy(proxy);
                    }
                    config.setModel(model);
                    config.setHost("chat.ai.cneko.org");
                    service = new CNekoAIService(config);
                    response = service.processRequest(new AIRequest(message, uuidStr, userUuidStr, prompt, FileStorageUtil.readConversation((String)uuidStr, (String)userUuidStr)));
                }
                if (s.equalsIgnoreCase("google")) {
                    config = new GeminiConfig(key);
                    if (useProxy) {
                        config.setProxy(proxy);
                    }
                    config.setModel(model);
                    service = new GeminiService(config);
                    response = service.processRequest(new AIRequest(message, uuidStr, userUuidStr, prompt, FileStorageUtil.readConversation((String)uuidStr, (String)userUuidStr)));
                } else if (s.equalsIgnoreCase("openai")) {
                    config = new OpenAIConfig(key);
                    if (useProxy) {
                        config.setProxy(proxy);
                    }
                    config.setModel(model);
                    service = new OpenAIService((OpenAIConfig)config);
                    response = service.processRequest(new AIRequest(message, uuidStr, userUuidStr, prompt, FileStorageUtil.readConversation((String)uuidStr, (String)userUuidStr)));
                } else if (s.equalsIgnoreCase("groq")) {
                    config = new OpenAIConfig(key);
                    if (useProxy) {
                        config.setProxy(proxy);
                    }
                    config.setModel(model);
                    config.setHost("api.groq.com");
                    config.setEndpoint("/openai/v1/chat/completions");
                    service = new OpenAIService((OpenAIConfig)config);
                    response = service.processRequest(new AIRequest(message, uuidStr, userUuidStr, prompt, FileStorageUtil.readConversation((String)uuidStr, (String)userUuidStr)));
                } else if (s.equalsIgnoreCase("siliconflow")) {
                    config = new OpenAIConfig(key);
                    if (useProxy) {
                        config.setProxy(proxy);
                    }
                    config.setModel(model);
                    config.setHost("api.siliconflow.cn");
                    config.setEndpoint("/v1/chat/completions");
                    service = new OpenAIService((OpenAIConfig)config);
                    response = service.processRequest(new AIRequest(message, uuidStr, userUuidStr, prompt, FileStorageUtil.readConversation((String)uuidStr, (String)userUuidStr)));
                } else if (s.equalsIgnoreCase("elefant") || s.equalsIgnoreCase("player2")) {
                    config = new OpenAIConfig("");
                    config.setHost("127.0.0.1");
                    config.setPort(4315);
                    config.setEndpoint("/v1/chat/completions");
                    config.setTls(false);
                    service = new OpenAIService((OpenAIConfig)config);
                    response = service.processRequest(new AIRequest(message, uuidStr, userUuidStr, prompt, FileStorageUtil.readConversation((String)uuidStr, (String)userUuidStr)));
                } else if (!s.isEmpty()) {
                    String host;
                    config = new OpenAIConfig(key);
                    if (s.startsWith("http://")) {
                        s = s.substring("http://".length());
                        config.setTls(false);
                    } else if (s.startsWith("https://")) {
                        s = s.substring("https://".length());
                        config.setTls(true);
                    }
                    String[] hostPortAndPath = s.split("/", 2);
                    String hostPortSection = hostPortAndPath[0];
                    String endpoint = hostPortAndPath.length > 1 ? "/" + hostPortAndPath[1] : "/";
                    Integer port = null;
                    int colonIndex = hostPortSection.indexOf(58);
                    if (colonIndex != -1) {
                        host = hostPortSection.substring(0, colonIndex);
                        try {
                            port = Integer.parseInt(hostPortSection.substring(colonIndex + 1));
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid port number in URL: " + s);
                        }
                    } else {
                        host = hostPortSection;
                    }
                    config.setHost(host);
                    if (port != null) {
                        config.setPort(port.intValue());
                    }
                    config.setEndpoint(endpoint);
                    if (useProxy) {
                        config.setProxy(proxy);
                    }
                    config.setModel(model);
                    OpenAIService service2 = new OpenAIService((OpenAIConfig)config);
                    response = service2.processRequest(new AIRequest(message, uuidStr, userUuidStr, prompt, FileStorageUtil.readConversation((String)uuidStr, (String)userUuidStr)));
                } else {
                    Bootstrap.LOGGER.warn("Unsupported AI service: {} ,please read the docs: https://s.cneko.org/toNekoAI", (Object)s);
                    callback.execute(new AIResponse("Unsupported AI service: {} ,please read the docs: https://s.cneko.org/toNekoAI", 400));
                }
                if (response != null) {
                    if (!response.isSuccess()) {
                        response.setResponse("\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                    }
                    callback.execute(response);
                }
            }
            catch (Exception e) {
                Bootstrap.LOGGER.warn("Failed to send message to AI service,{}", (Object)e.getMessage());
            }
        });
        executor.submit(() -> {
            try {
                future.get(60L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                Bootstrap.LOGGER.warn("Message sending task timed out and was cancelled.");
            }
            catch (Exception e) {
                Bootstrap.LOGGER.error("Unexpected error during message sending task.", (Throwable)e);
            }
        });
    }

    public static void playTTS(String text, String voice) {
        Future<?> future = executor.submit(() -> {
            try {
                ElefantTTSRequestBody body = new ElefantTTSRequestBody();
                body.text = text;
                body.voiceIds.add(voice);
                HttpClient client = new HttpClient();
                CompletableFuture<String> cf = client.sendPost("http://127.0.0.1:4315/v1/tts/speak", body, String.class);
                cf.whenComplete((response, ex) -> {
                    if (ex != null) {
                        Bootstrap.LOGGER.error("Request failed: {}", (Object)ex.getMessage());
                    }
                    client.close();
                });
                cf.join();
            }
            catch (Exception e) {
                Bootstrap.LOGGER.error("Unexpected error during message sending task.", (Throwable)e);
            }
        });
        executor.submit(() -> {
            try {
                future.get(60L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                Bootstrap.LOGGER.warn("TTS sending task timed out and was cancelled.");
            }
            catch (Exception e) {
                Bootstrap.LOGGER.error("Unexpected error during message sending task.", (Throwable)e);
            }
        });
    }

    @FunctionalInterface
    public static interface MessageCallback {
        public void execute(AIResponse var1);
    }

    private static class ElefantTTSRequestBody {
        public static final Gson gson = new Gson();
        @SerializedName(value="play_in_app")
        private boolean playInApp = true;
        @SerializedName(value="speed")
        private int speed = 1;
        @SerializedName(value="text")
        private String text = "";
        @SerializedName(value="voice_ids")
        private List<String> voiceIds = new ArrayList<String>();

        private ElefantTTSRequestBody() {
        }
    }

    public static class CNekoAIService
    extends AbstractNettyAIService<GeminiConfig> {
        public CNekoAIService(GeminiConfig config) throws Exception {
            super((AbstractAIConfig)config);
        }

        protected void initChannel(SocketChannel ch, AIRequest request, CompletableFuture<AIResponse> future) {
            this.configurePipeline(ch, (ChannelHandler)new CnekoHandler(request, future));
        }

        protected void sendRequest(Channel channel, AIRequest request) {
            AIHistory history = this.prepareHistory(request);
            String jsonBody = history.toJson();
            byte[] bodyBytes = jsonBody.getBytes(StandardCharsets.UTF_8);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bodyBytes);
            String msg = request.getQuery().replace("&", "");
            String encodedPrompt = URLEncoder.encode(request.getPrompt() != null ? request.getPrompt() : "\u65e0\u63d0\u793a\u8bcd", StandardCharsets.UTF_8);
            String encodedMessage = URLEncoder.encode(msg, StandardCharsets.UTF_8);
            String encodedKey = URLEncoder.encode(ConfigUtil.getAIKey(), StandardCharsets.UTF_8);
            String encodeModel = URLEncoder.encode(((GeminiConfig)this.config).getModel(), StandardCharsets.UTF_8);
            String query = String.format("p=%s&t=%s&key=%s&model=%s&ver=1", encodedPrompt, encodedMessage, encodedKey, encodeModel);
            String encodedJsonBody = URLEncoder.encode(jsonBody, StandardCharsets.UTF_8);
            DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/?" + query, buf);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)((GeminiConfig)this.config).getHost()).set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buf.readableBytes()).set("msg", (Object)jsonBody);
            channel.writeAndFlush((Object)httpRequest);
        }

        private static class CnekoHandler
        extends SimpleChannelInboundHandler<FullHttpResponse> {
            private final AIRequest request;
            private final CompletableFuture<AIResponse> future;

            public CnekoHandler(AIRequest request, CompletableFuture<AIResponse> future) {
                this.request = request;
                this.future = future;
            }

            protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) {
                String content = response.content().toString(StandardCharsets.UTF_8);
                int code = response.status().code();
                if (code != HttpResponseStatus.OK.code()) {
                    this.future.complete(new AIResponse("API Error: " + content, code));
                    return;
                }
                try {
                    CnekoResponse responseObj = (CnekoResponse)gson.fromJson(content, CnekoResponse.class);
                    String responseText = responseObj.response;
                    responseText = responseText.replace("\\n", "");
                    try {
                        FileStorageUtil.saveConversation((String)this.request.getUserId(), (String)this.request.getSessionId(), (String)this.request.getQuery(), (String)responseText);
                    }
                    catch (Exception e) {
                        NekoLogger.LOGGER.error("Error saving conversation: {}", (Object)e.getMessage());
                    }
                    this.future.complete(new AIResponse(responseText.trim(), code));
                }
                catch (Exception e) {
                    this.future.complete(new AIResponse("Response parsing error: " + e.getMessage(), code));
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                this.future.complete(new AIResponse("Network error: " + cause.getMessage(), 400));
                ctx.close();
            }

            public static class CnekoResponse {
                public String response;
            }
        }
    }
}

