/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util;

import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cneko.toneko.common.Bootstrap;
import org.cneko.toneko.common.util.JsonConfiguration;
import org.jetbrains.annotations.Nullable;

public class ConfigBuilder {
    private final Path path;
    private JsonConfiguration config;
    private final Map<String, Entry> defaults = new LinkedHashMap<String, Entry>();

    public ConfigBuilder(Path path) {
        this.path = path;
        try {
            this.config = new JsonConfiguration(path);
        }
        catch (Exception e) {
            this.config = new JsonConfiguration("{}");
        }
    }

    private ConfigBuilder add(String key, Entry defaultValue, String comment) {
        this.defaults.put(key, defaultValue);
        return this;
    }

    private ConfigBuilder add(String key, Entry defaultValue, String ... comments) {
        String combinedComment = String.join((CharSequence)"\n", comments);
        return this.add(key, defaultValue, combinedComment);
    }

    public ConfigBuilder addString(String key, String value, String url, String comment) {
        return this.add(key, Entry.of(value, comment, url), comment);
    }

    public ConfigBuilder addString(String key, String value, String url, String ... comments) {
        return this.add(key, Entry.of(value, String.join((CharSequence)"\n", comments), url), comments);
    }

    public ConfigBuilder addBoolean(String key, Boolean value, String url, String comment) {
        return this.add(key, Entry.of(value, comment, url), comment);
    }

    public ConfigBuilder addBoolean(String key, Boolean value, String url, String ... comments) {
        return this.add(key, Entry.of(value, String.join((CharSequence)"\n", comments), url), comments);
    }

    public void setBoolean(String key, boolean value) {
        this.config.set(key, value);
        this.config.save(this.path);
    }

    public void setString(String key, String value) {
        this.config.set(key, value);
        this.config.save(this.path);
    }

    public Entry get(String key) {
        return this.defaults.get(key);
    }

    public Entry getExist(String key) {
        Object value = this.config.get(key);
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            value = primitive.isBoolean() ? Boolean.valueOf(primitive.getAsBoolean()) : (primitive.isNumber() ? primitive.getAsNumber() : primitive.getAsString());
        }
        return Entry.of(value, this.get((String)key).comment, this.config.getString("url"));
    }

    public String getKey(Entry entry) {
        for (String key : this.defaults.keySet()) {
            if (!this.defaults.get(key).equals(entry)) continue;
            return key;
        }
        return null;
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.defaults.keySet());
    }

    public ConfigBuilder build() {
        for (String key : this.defaults.keySet()) {
            Entry entry = this.defaults.get(key);
            if (this.config.contains(key)) continue;
            this.config.set(key, entry.get());
        }
        try {
            Path configPath = Path.of("config/", new String[0]);
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            this.config.save(this.path);
        }
        catch (IOException e) {
            Bootstrap.LOGGER.error("Unable to save config file", (Throwable)e);
        }
        return this;
    }

    public JsonConfiguration createConfig() {
        try {
            return new JsonConfiguration(this.path);
        }
        catch (IOException e) {
            return this.config;
        }
    }

    public static ConfigBuilder create(Path path) {
        return new ConfigBuilder(path);
    }

    public static class Entry {
        private final Object value;
        private final Types type;
        private final String comment;
        private String url;

        public Entry(Object value, Types type, String comment) {
            this.value = value;
            this.type = type;
            this.comment = comment;
        }

        public Entry(Object value, Types type, String comment, @Nullable String url) {
            this(value, type, comment);
            this.url = url;
        }

        public Object get() {
            return this.value;
        }

        public Types type() {
            return this.type;
        }

        public String comment() {
            return this.comment;
        }

        public Entry setUrl(String url) {
            this.url = url;
            return this;
        }

        public String url() {
            return this.url;
        }

        public String string() {
            return (String)this.value;
        }

        public Number number() {
            return (Number)this.value;
        }

        public boolean bool() {
            return (Boolean)this.value;
        }

        public ConfigBuilder config() {
            return (ConfigBuilder)this.value;
        }

        public static Entry of(Object value, String comment, String url) {
            if (value instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)value;
                if (primitive.isString()) {
                    return new Entry(primitive.getAsString(), Types.STRING, comment, url);
                }
                if (primitive.isBoolean()) {
                    return new Entry(primitive.getAsBoolean(), Types.BOOLEAN, comment, url);
                }
                if (primitive.isNumber()) {
                    return new Entry(primitive.getAsNumber(), Types.NUMBER, comment, url);
                }
            } else {
                if (value instanceof String) {
                    return new Entry(value, Types.STRING, comment, url);
                }
                if (value instanceof Number) {
                    return new Entry(value, Types.NUMBER, comment, url);
                }
                if (value instanceof Boolean) {
                    return new Entry(value, Types.BOOLEAN, comment, url);
                }
                if (value instanceof List) {
                    return new Entry(value, Types.LIST, comment, url);
                }
                if (value instanceof ConfigBuilder) {
                    return new Entry(value, Types.CONFIG, comment, url);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + (value != null ? value.getClass().getName() : "null"));
        }

        public static enum Types {
            STRING,
            NUMBER,
            BOOLEAN,
            LIST,
            CONFIG;

        }
    }
}

