/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util;

import java.nio.file.Path;
import java.time.LocalDate;
import org.cneko.toneko.common.util.AIUtil;
import org.cneko.toneko.common.util.ConfigBuilder;
import org.cneko.toneko.common.util.JsonConfiguration;

public class ConfigUtil {
    public static String CONFIG_FILE = "config/toneko.json";
    public static String AI_URL = "https://s.cneko.org/toNekoAI";
    public static final ConfigBuilder CONFIG_BUILDER = ConfigBuilder.create(Path.of(CONFIG_FILE, new String[0])).addString("language", "zh_cn", null, "\u8bed\u8a00\u9009\u9879\uff08\u652f\u6301 zh_cn,zh_tw,en_us,ko_kr\uff09,\u53ef\u81ea\u5b9a\u4e49\u8bed\u8a00\uff0c\u8be6\u7ec6\u67e5\u770b https://github.com/CSneko/toNeko/docs/CUSTOM_LANGUAGE.md", "Language Option (Supported zh_cn,zh_tw,en_us,ko_kr), you can customize the language, see https://github.com/CSneko/toNeko/docs/CUSTOM_LANGUAGE.md").addBoolean("chat.enable", (Boolean)true, null, "\u662f\u5426\u542f\u7528\u804a\u5929\u4fee\u6539 \uff08\u5f00\u542f\u540e\u4f1a\u5bf9MCDr\u9020\u6210\u4e00\u5b9a\u5f71\u54cd\uff09", "Whether to enable chat modification (it will cause some effects on MCDr)").addString("chat.format", "%prefix%\u00a7e%name% \u00a7d>> \u00a7f%msg%", null, "\u804a\u5929\u683c\u5f0f\uff0c\u5360\u4f4d\u7b26 %name% = \u73a9\u5bb6\u540d\u79f0, %msg% = \u73a9\u5bb6\u6d88\u606f, %prefix% = \u524d\u7f00", "Chat format, placeholder %name% = player name, %msg% = player message, %prefix% = prefix").addBoolean("ai.enable", (Boolean)false, AI_URL, "\u662f\u5426\u542f\u7528AI", "Enable AI").addString("ai.service", "neko", AI_URL, new String[0]).addString("ai.model", "gemini-2.0-flash", AI_URL, new String[0]).addString("ai.key", "", AI_URL, "AI\u7684\u5bc6\u94a5\uff0c\u8bf7\u53c2\u9605https://s.cneko.org/toNekoAI", "API Key of AI,see https://s.cneko.org/toNekoAI").addString("ai.prompt", "\u4f60\u662f\u4e00\u53ea\u53ef\u7231\u7684%neko_type%\uff08%neko_des%\uff09\uff0c\u4f60\u7684\u540d\u5b57\u662f%neko_name%\uff0c\u4f60\u7684\u8eab\u9ad8\u662f%neko_height%\u7c73\uff0c\u4f60\u7684\u5c5e\u6027\u6709%neko_moe_tags%\u3002\u5728\u56de\u590d\u65f6\u8bf7\u4e0d\u8981\u592a\u957f\u4e14\u4e0d\u8981\u6709\u592a\u591a\u52a8\u4f5c\u3002\u6211%player_is_owner%\u4f60\u7684\u4e3b\u4eba\uff0c\u6211\u7684\u540d\u5b57\u662f%player_name%\uff0c\u6211%player_is_neko%\u4e00\u53ea\u732b\u5a18\u3002\u73b0\u5728\u662f%world_time%\uff0c\u5929\u6c14\u4e3a%world_weather%\u3002", AI_URL, "AI\u63d0\u793a\u8bcd\uff0c\u53c2\u9605 https://s.cneko.org/toNekoAI", "AI prompt,see https://s.cneko.org/toNekoAI").addBoolean("ai.show_think", (Boolean)true, AI_URL, new String[0]).addBoolean("ai.tts.enable", (Boolean)false, AI_URL, new String[0]).addString("ai.tts.service", "player2", AI_URL, new String[0]).addString("ai.tts.voice", "01955d76-ed5b-75ad-afe3-ac5eb3d0a16e", AI_URL, new String[0]).addBoolean("ai.proxy.enable", (Boolean)false, AI_URL, new String[0]).addString("ai.proxy.ip", "", AI_URL, new String[0]).addString("ai.proxy.port", "2080", AI_URL, new String[0]).addBoolean("stats", (Boolean)true, "https://s.cneko.org/toNekoOnlineAPI", "\u542f\u7528\u7edf\u8ba1\u529f\u80fd\uff0c\u7edf\u8ba1\u6570\u636e\u5c06\u53d1\u9001\u5230 toneko API\uff0c\u5982\u4f55\u4f7f\u7528api\u8bf7\u67e5\u770b https://s.cneko.org/toNekoOnlineAPI", "Enable statistics, statistics data will be sent to the toneko API, how to use the api please see https://s.cneko.org/toNekoOnlineAPI").build();
    public static JsonConfiguration CONFIG = CONFIG_BUILDER.createConfig();
    public static boolean IS_BIRTHDAY = false;
    private static final int BIRTHDAY_MONTH = 9;
    private static final int BIRTHDAY_DAY = 26;
    public static boolean IS_FOOL_DAY = false;
    private static final int FOOL_DAY_MONTH = 4;
    private static final int FOOL_DAY_DAY = 1;

    public static void load() {
        CONFIG = CONFIG_BUILDER.createConfig();
        LocalDate today = LocalDate.now();
        int month = today.getMonthValue();
        int day = today.getDayOfMonth();
        if (month == 9 && day == 26) {
            IS_BIRTHDAY = true;
        }
        if (month == 4 && day == 1) {
            IS_FOOL_DAY = true;
        }
        AIUtil.init();
    }

    public static boolean isChatEnable() {
        return CONFIG.getBoolean("chat.enable");
    }

    public static String getChatFormat() {
        return CONFIG.getString("chat.format");
    }

    public static boolean isStatsEnable() {
        return CONFIG.getBoolean("stats");
    }

    public static boolean isAIEnabled() {
        return CONFIG.getBoolean("ai.enable");
    }

    public static String getAIPrompt() {
        return CONFIG.getString("ai.prompt");
    }

    public static String getAIKey() {
        return CONFIG.getString("ai.key");
    }

    public static String getAIModel() {
        return CONFIG.getString("ai.model");
    }

    public static String getAIService() {
        return CONFIG.getString("ai.service");
    }

    public static boolean isAIShowThink() {
        return CONFIG.getBoolean("ai.show_think");
    }

    public static boolean isAIProxyEnabled() {
        return CONFIG.getBoolean("ai.proxy.enable");
    }

    public static String getAIProxyIp() {
        return CONFIG.getString("ai.proxy.ip");
    }

    public static String getAIProxyPort() {
        return CONFIG.getString("ai.proxy.port");
    }

    public static boolean isAITTSEnabled() {
        return CONFIG.getBoolean("ai.tts.enable");
    }

    public static String getAITTSVoice() {
        return CONFIG.getString("ai.tts.voice");
    }
}

