/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.cneko.toneko.common.Bootstrap;

public class FileUtil {
    public static void CreateFile(String file) {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void CreatePath(String path) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean FileExists(String file) {
        try {
            File f = new File(file);
            return f.exists();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void WriteFile(String file, String content) {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f, StandardCharsets.UTF_8);
            fw.write(content);
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void DeleteFile(String file) {
        try {
            File f = new File(file);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyResource(String resourcePath, String targetPath) {
        try {
            InputStream inputStream = FileUtil.class.getClassLoader().getResourceAsStream(resourcePath);
            if (inputStream != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                reader.close();
                FileUtil.WriteFile(targetPath, content.toString());
            } else {
                Bootstrap.LOGGER.error("Cannot find resource: {}", (Object)resourcePath);
            }
        }
        catch (IOException e) {
            Bootstrap.LOGGER.error("Cannot copy resource: ", (Throwable)e);
        }
    }

    public static List<File> getFiles(String path) {
        File directory = new File(path);
        ArrayList<File> files = new ArrayList<File>();
        if (directory.exists() && directory.isDirectory()) {
            FileUtil.getFilesRecursively(directory, files);
        }
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readNumberFromFile(String filePath) {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line = reader.readLine();
            if (line == null) return 0;
            int n = Integer.parseInt(line);
            return n;
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String readStringFromFile(String filePath) {
        String string;
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        try {
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
            string = content.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        reader.close();
        return string;
    }

    private static void getFilesRecursively(File directory, List<File> files) {
        File[] entries = directory.listFiles();
        if (entries != null) {
            for (File entry : entries) {
                if (entry.isDirectory()) {
                    FileUtil.getFilesRecursively(entry, files);
                    continue;
                }
                files.add(entry);
            }
        }
    }

    public static String readFileWithException(String filePath) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        return content.toString();
    }
}

