/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util;

import com.google.gson.Gson;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLException;

public class HttpClient {
    private final Gson gson;
    private final EventLoopGroup group;
    private final boolean autoClose;

    public HttpClient() {
        this(new Gson());
    }

    public HttpClient(Gson gson) {
        this(gson, (EventLoopGroup)new NioEventLoopGroup(), true);
    }

    public HttpClient(Gson gson, EventLoopGroup group, boolean autoClose) {
        this.gson = gson;
        this.group = group;
        this.autoClose = autoClose;
    }

    public void close() {
        if (this.autoClose) {
            this.group.shutdownGracefully();
        }
    }

    public <T> CompletableFuture<T> sendPost(String url, Object body, final Class<T> responseType) {
        final CompletableFuture future = new CompletableFuture();
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
            final String host = uri.getHost();
            final int port = uri.getPort() == -1 ? (scheme.equals("https") ? 443 : 80) : uri.getPort();
            boolean ssl = "https".equalsIgnoreCase(scheme);
            SslContext sslContext = null;
            if (ssl) {
                sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            Bootstrap bootstrap = new Bootstrap();
            final SslContext finalSslContext = sslContext;
            ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (finalSslContext != null) {
                        p.addLast(new ChannelHandler[]{finalSslContext.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                    p.addLast(new ChannelHandler[]{new HttpClientHandler(future, HttpClient.this.gson, responseType)});
                }
            });
            String json = this.gson.toJson(body);
            ByteBuf content = Unpooled.copiedBuffer((CharSequence)json, (Charset)CharsetUtil.UTF_8);
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.getRawPath(), content);
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE).set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
            ChannelFuture connectFuture = bootstrap.connect(host, port);
            connectFuture.addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> HttpClient.lambda$sendPost$0((FullHttpRequest)request, future, arg_0)));
        }
        catch (URISyntaxException | SSLException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public <T> CompletableFuture<T> sendGet(String url, Map<String, String> queryParams, final Class<T> responseType) {
        final CompletableFuture future = new CompletableFuture();
        try {
            URI uri;
            Object fullUrl = url;
            if (queryParams != null && !queryParams.isEmpty()) {
                StringBuilder queryBuilder = new StringBuilder();
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    if (!queryBuilder.isEmpty()) {
                        queryBuilder.append('&');
                    }
                    String encodedKey = URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8);
                    String encodedValue = URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8);
                    queryBuilder.append(encodedKey).append('=').append(encodedValue);
                }
                fullUrl = ((String)fullUrl).contains("?") ? (String)fullUrl + "&" + String.valueOf(queryBuilder) : (String)fullUrl + "?" + String.valueOf(queryBuilder);
            }
            String scheme = (uri = new URI((String)fullUrl)).getScheme() == null ? "http" : uri.getScheme();
            final String host = uri.getHost();
            final int port = uri.getPort() == -1 ? (scheme.equals("https") ? 443 : 80) : uri.getPort();
            boolean ssl = "https".equalsIgnoreCase(scheme);
            SslContext sslContext = null;
            if (ssl) {
                sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            Bootstrap bootstrap = new Bootstrap();
            final SslContext finalSslContext = sslContext;
            ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (finalSslContext != null) {
                        p.addLast(new ChannelHandler[]{finalSslContext.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                    p.addLast(new ChannelHandler[]{new HttpClientHandler(future, HttpClient.this.gson, responseType)});
                }
            });
            Object requestUri = uri.getRawPath();
            String rawQuery = uri.getRawQuery();
            if (rawQuery != null && !rawQuery.isEmpty()) {
                requestUri = (String)requestUri + "?" + rawQuery;
            }
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, (String)requestUri, Unpooled.EMPTY_BUFFER);
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            ChannelFuture connectFuture = bootstrap.connect(host, port);
            connectFuture.addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> HttpClient.lambda$sendGet$1((FullHttpRequest)request, future, arg_0)));
        }
        catch (URISyntaxException | SSLException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static /* synthetic */ void lambda$sendGet$1(FullHttpRequest request, CompletableFuture future, ChannelFuture f) throws Exception {
        if (f.isSuccess()) {
            f.channel().writeAndFlush((Object)request);
        } else {
            future.completeExceptionally(f.cause());
        }
    }

    private static /* synthetic */ void lambda$sendPost$0(FullHttpRequest request, CompletableFuture future, ChannelFuture f) throws Exception {
        if (f.isSuccess()) {
            f.channel().writeAndFlush((Object)request);
        } else {
            future.completeExceptionally(f.cause());
        }
    }

    public static class HttpException
    extends RuntimeException {
        private final HttpResponseStatus status;
        private final String responseBody;

        public HttpException(HttpResponseStatus status, String responseBody) {
            super("HTTP Error " + status.code() + ": " + status.reasonPhrase());
            this.status = status;
            this.responseBody = responseBody;
        }

        public int getStatusCode() {
            return this.status.code();
        }

        public String getResponseBody() {
            return this.responseBody;
        }
    }

    private static class HttpClientHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private final CompletableFuture<Object> future;
        private final Gson gson;
        private final Class<?> responseType;

        public HttpClientHandler(CompletableFuture<Object> future, Gson gson, Class<?> responseType) {
            this.future = future;
            this.gson = gson;
            this.responseType = responseType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
            try {
                String content = msg.content().toString(CharsetUtil.UTF_8);
                if (msg.status().code() != HttpResponseStatus.OK.code()) {
                    this.future.completeExceptionally(new HttpException(msg.status(), content));
                    return;
                }
                if (this.responseType == String.class) {
                    this.future.complete(content);
                } else if (this.responseType == byte[].class) {
                    byte[] bytes = new byte[msg.content().readableBytes()];
                    msg.content().readBytes(bytes);
                    this.future.complete(bytes);
                } else {
                    Object result = this.gson.fromJson(content, this.responseType);
                    this.future.complete(result);
                }
            }
            catch (Exception e) {
                this.future.completeExceptionally(e);
            }
            finally {
                ctx.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.future.completeExceptionally(cause);
            ctx.close();
        }
    }
}

