/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cneko.toneko.common.util.FileUtil;

public class JsonConfiguration {
    private final String original;
    private final JsonObject jsonObject;
    private Path filePath;
    private final Object lock = new Object();

    public JsonConfiguration(String jsonString) {
        JsonObject temp;
        this.original = jsonString;
        Gson gson = new Gson();
        try {
            temp = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            temp = new JsonObject();
        }
        this.jsonObject = temp != null ? temp : new JsonObject();
    }

    public JsonConfiguration(JsonObject jsonObject) {
        this.original = jsonObject.toString();
        this.jsonObject = jsonObject;
    }

    public JsonConfiguration(Path filePath) throws IOException {
        JsonObject temp;
        String content;
        try {
            content = FileUtil.readFileWithException(filePath.toString());
        }
        catch (Exception e) {
            content = "{}";
        }
        if (content.trim().isEmpty()) {
            content = "{}";
        }
        this.original = content;
        Gson gson = new Gson();
        try {
            temp = (JsonObject)gson.fromJson(content, JsonObject.class);
        }
        catch (Exception e) {
            temp = new JsonObject();
        }
        this.jsonObject = temp != null ? temp : new JsonObject();
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement get(String path) {
        Object object = this.lock;
        synchronized (object) {
            return this.jsonObject.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonPrimitive getJsonPrimitive(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonElement element = this.get(path);
            if (element != null && element.isJsonPrimitive()) {
                return element.getAsJsonPrimitive();
            }
            return new JsonPrimitive("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonArray getJsonArray(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonElement element = this.get(path);
            if (element != null && element.isJsonArray()) {
                return element.getAsJsonArray();
            }
            return new JsonArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String path, Object value) {
        Object object = this.lock;
        synchronized (object) {
            if (value instanceof JsonConfiguration) {
                this.jsonObject.add(path, (JsonElement)((JsonConfiguration)value).jsonObject);
                return;
            }
            if (value instanceof JsonElement) {
                this.jsonObject.add(path, (JsonElement)value);
                return;
            }
            if (value instanceof String) {
                this.jsonObject.addProperty(path, (String)value);
                return;
            }
            if (value instanceof Number) {
                this.jsonObject.addProperty(path, (Number)value);
                return;
            }
            if (value instanceof Boolean) {
                this.jsonObject.addProperty(path, (Boolean)value);
                return;
            }
            if (value instanceof Character) {
                this.jsonObject.addProperty(path, (Character)value);
                return;
            }
            if (value instanceof List) {
                this.processList(path, (List)value);
                return;
            }
            if (value != null) {
                this.jsonObject.addProperty(path, value.toString());
            }
        }
    }

    private void processList(String path, List<?> list) {
        JsonArray jsonArray = new JsonArray();
        if (list.isEmpty()) {
            this.jsonObject.add(path, (JsonElement)jsonArray);
            return;
        }
        for (Object o : list) {
            if (o instanceof JsonConfiguration) {
                jsonArray.add((JsonElement)((JsonConfiguration)o).jsonObject);
                continue;
            }
            if (o instanceof JsonElement) {
                jsonArray.add((JsonElement)o);
                continue;
            }
            if (o instanceof String) {
                jsonArray.add((String)o);
                continue;
            }
            if (o instanceof Number) {
                jsonArray.add((Number)o);
                continue;
            }
            if (o instanceof Boolean) {
                jsonArray.add((Boolean)o);
                continue;
            }
            if (o instanceof Character) {
                jsonArray.add((Character)o);
                continue;
            }
            if (o == null) continue;
            jsonArray.add(o.toString());
        }
        this.jsonObject.add(path, (JsonElement)jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Path filePath) {
        Object object = this.lock;
        synchronized (object) {
            if (filePath != null) {
                String content = this.jsonObject.toString();
                FileUtil.WriteFile(filePath.toString(), content);
            }
        }
    }

    public void save() {
        this.save(this.filePath);
    }

    public String getString(String path) {
        try {
            return this.getJsonPrimitive(path).getAsString();
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStringList(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonArray array = this.getJsonArray(path);
            ArrayList<String> list = new ArrayList<String>();
            for (JsonElement e : array) {
                if (!e.isJsonPrimitive()) continue;
                list.add(e.getAsJsonPrimitive().getAsString());
            }
            return list;
        }
    }

    public float getFloat(String path) {
        try {
            return this.getJsonPrimitive(path).getAsFloat();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public double getDouble(String path) {
        try {
            return this.getJsonPrimitive(path).getAsDouble();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public int getInt(String path) {
        try {
            return this.getJsonPrimitive(path).getAsInt();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean getBoolean(String path) {
        try {
            return this.getJsonPrimitive(path).getAsBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getBoolean(String path, boolean defValue) {
        try {
            return this.getJsonPrimitive(path).getAsBoolean();
        }
        catch (Exception e) {
            return defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonConfiguration getJsonConfiguration(String path) {
        Object object = this.lock;
        synchronized (object) {
            try {
                JsonElement element = this.get(path);
                if (element != null && element.isJsonObject()) {
                    return new JsonConfiguration(element.getAsJsonObject());
                }
                return new JsonConfiguration("{}");
            }
            catch (Exception e) {
                return new JsonConfiguration("{}");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.jsonObject.has(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getIntList(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonArray array = this.getJsonArray(path);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (JsonElement e : array) {
                if (!e.isJsonPrimitive()) continue;
                list.add(e.getAsJsonPrimitive().getAsInt());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> getDoubleList(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonArray array = this.getJsonArray(path);
            ArrayList<Double> list = new ArrayList<Double>();
            for (JsonElement e : array) {
                if (!e.isJsonPrimitive()) continue;
                list.add(e.getAsJsonPrimitive().getAsDouble());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Float> getFloatList(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonArray array = this.getJsonArray(path);
            ArrayList<Float> list = new ArrayList<Float>();
            for (JsonElement e : array) {
                if (!e.isJsonPrimitive()) continue;
                list.add(Float.valueOf(e.getAsJsonPrimitive().getAsFloat()));
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JsonConfiguration> getJsonList(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonArray array = this.getJsonArray(path);
            return array.asList().stream().map(e -> new JsonConfiguration(e.getAsJsonObject())).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getList(String path) {
        Object object = this.lock;
        synchronized (object) {
            JsonArray array = this.getJsonArray(path);
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement e : array) {
                if (e.isJsonObject()) {
                    list.add(e.getAsJsonObject());
                    continue;
                }
                if (!e.isJsonPrimitive()) continue;
                JsonPrimitive p = e.getAsJsonPrimitive();
                if (p.isString()) {
                    list.add(p.getAsString());
                    continue;
                }
                if (p.isBoolean()) {
                    list.add(p.getAsBoolean());
                    continue;
                }
                if (!p.isNumber()) continue;
                list.add(p.getAsNumber());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            if (obj instanceof JsonConfiguration) {
                JsonConfiguration other = (JsonConfiguration)obj;
                return this.jsonObject.equals((Object)other.jsonObject);
            }
            return obj.toString().equals(this.jsonObject.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JsonConfiguration> toJsonList() {
        Object object = this.lock;
        synchronized (object) {
            if (this.jsonObject.isJsonArray()) {
                return this.jsonObject.getAsJsonArray().asList().stream().map(e -> new JsonConfiguration(e.getAsJsonObject())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    public JsonObject toGson() {
        return this.jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.jsonObject.toString();
        }
    }

    public static JsonConfiguration of(String jsonString) {
        return new JsonConfiguration(jsonString);
    }

    public static JsonConfiguration fromFile(File file) throws IOException {
        return new JsonConfiguration(file.toPath());
    }

    public static JsonConfiguration fromFile(Path filePath) throws IOException {
        return new JsonConfiguration(filePath);
    }

    @Generated
    public String getOriginal() {
        return this.original;
    }
}

