/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.cneko.toneko.common.util.JsonConfiguration;

public class JsonUtil {
    public static List<JsonObject> jsonListToJsonList(List<JsonConfiguration> list) {
        return JsonUtil.toJsonList(JsonUtil.toStringList(list));
    }

    public static List<JsonObject> toJsonList(List<String> list) {
        ArrayList<JsonObject> json = new ArrayList<JsonObject>();
        for (String s : list) {
            json.add(JsonParser.parseString((String)s).getAsJsonObject());
        }
        return json;
    }

    public static List<String> toStringList(List<JsonConfiguration> json) {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonConfiguration j : json) {
            list.add(j.toString());
        }
        return list;
    }

    public static String listToJson(List<String> list) {
        Gson gson = new Gson();
        return gson.toJson(list);
    }

    public static JsonArray jsonListToGsonArray(List<JsonConfiguration> list) {
        return JsonUtil.listToGson(JsonUtil.toStringList(list));
    }

    public static JsonArray listToGson(List<String> list) {
        Gson gson = new Gson();
        JsonArray jsonArray = new JsonArray();
        for (String str : list) {
            JsonObject jsonObject = JsonParser.parseString((String)str).getAsJsonObject();
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static String jsonListToJson(List<JsonConfiguration> list) {
        return JsonUtil.listToJson(JsonUtil.toStringList(list));
    }
}

