/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.util.network;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cneko.toneko.common.util.JsonConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpBase {

    public static abstract class HttpBaseObject {
        private Map<String, String> cookies;
        protected String url;
        protected Map<String, String> headers;
        protected String response;
        protected int responseCode = 0;
        protected String responseHeaders;
        protected HttpMethod method;
        private Thread asyncThread;
        private String jumpUrl;
        private boolean autoJump = false;

        public HttpBaseObject(@NotNull String url, @Nullable Map<String, String> headers) {
            this.url = url;
            this.headers = headers;
            this.method = this.getMethod();
            this.cookies = new ConcurrentHashMap<String, String>();
        }

        public HttpBaseObject(@NotNull String url) {
            this(url, new ConcurrentHashMap<String, String>());
        }

        public abstract HttpMethod getMethod();

        public void connect() throws IOException {
            String line;
            URL u = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod(this.method.toString());
            for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                conn.setRequestProperty("Cookie", entry.getKey() + "=" + entry.getValue());
            }
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            this.response = response.toString();
            Map<String, List<String>> map = conn.getHeaderFields();
            StringBuilder headers = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                headers.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
            }
            this.responseHeaders = headers.toString();
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public String getResponse() {
            return this.response;
        }

        public String getResponseHeaders() {
            return this.responseHeaders;
        }

        public JsonConfiguration getResponseHeadersJson() {
            String[] lines;
            JsonObject jsonObject = new JsonObject();
            for (String line : lines = this.responseHeaders.split("\n")) {
                String[] parts = line.split(":", 2);
                if (parts.length != 2) continue;
                String key = parts[0].trim();
                String value = parts[1].trim();
                jsonObject.addProperty(key, value);
            }
            return new JsonConfiguration(jsonObject.toString());
        }

        public int getStatusCode() {
            return this.responseCode;
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void saveToFile(Path path) throws IOException {
            if (this.response != null) {
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(this.response);
                }
            } else {
                throw new IllegalStateException("Response is null, cannot save to file.");
            }
        }

        public void asyncConnect() {
            this.asyncThread = new Thread(() -> {
                try {
                    this.connect();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            });
            this.asyncThread.start();
        }

        public void waitAsyncConnect() throws InterruptedException {
            if (this.asyncThread == null) {
                throw new IllegalStateException("No async connect operation has been started.");
            }
            this.asyncThread.join();
        }

        public void saveToFile(File file) throws IOException {
            this.saveToFile(file.toPath());
        }

        public JsonConfiguration getJson() {
            return new JsonConfiguration(this.response);
        }

        public void setJumpUrl() {
            this.jumpUrl = this.getJumpUrl();
        }

        public String getJumpUrl() {
            String locationHeader;
            if (this.responseCode >= 300 && this.responseCode < 400 && this.responseHeaders != null && (locationHeader = this.getResponseHeadersJson().getString("Location")) != null) {
                return locationHeader;
            }
            return this.url;
        }

        public void jump() throws IOException {
            if (this.responseCode >= 300 && this.responseCode < 400) {
                this.url = this.jumpUrl;
            }
            this.connect();
        }

        public void setJump(boolean autoJump) {
            this.autoJump = autoJump;
        }

        public void setCookie(Map<String, String> cookies) {
            this.cookies = cookies;
        }

        public Map<String, String> getCookie() {
            return this.cookies;
        }
    }

    static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE,
        CONNECT;

    }
}

