/*
 * Decompiled with CFR 0.152.
 */
package me.ignjoro.playerhider;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerHider
extends JavaPlugin
implements Listener,
TabExecutor {
    private final Set<UUID> hiddenPlayers = new HashSet<UUID>();
    private final Set<UUID> whitelistedPlayers = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("hideplayer")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("unhideplayer")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("whitelistplayer")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("unwhitelistplayer")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("internalreload")).setExecutor((CommandExecutor)this);
        List hidden = this.getConfig().getStringList("hiddenPlayers");
        for (String uuid : hidden) {
            this.hiddenPlayers.add(UUID.fromString(uuid));
        }
        List whitelisted = this.getConfig().getStringList("whitelistedPlayers");
        for (String string : whitelisted) {
            this.whitelistedPlayers.add(UUID.fromString(string));
        }
        for (UUID uUID : this.hiddenPlayers) {
            Player p = Bukkit.getPlayer((UUID)uUID);
            if (p == null || !p.isOnline()) continue;
            this.hidePlayer(p);
        }
    }

    public void onDisable() {
        this.getConfig().set("hiddenPlayers", this.hiddenPlayers.stream().map(UUID::toString).toList());
        this.getConfig().set("whitelistedPlayers", this.whitelistedPlayers.stream().map(UUID::toString).toList());
        this.saveConfig();
    }

    private void hidePlayer(Player player) {
        for (Player other : Bukkit.getOnlinePlayers()) {
            if (other.equals((Object)player)) continue;
            if (this.whitelistedPlayers.contains(other.getUniqueId())) {
                other.showPlayer((Plugin)this, player);
                player.setGlowing(true);
                continue;
            }
            other.hidePlayer((Plugin)this, player);
        }
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "You are currently hidden.");
    }

    private void unhidePlayer(Player player) {
        for (Player other : Bukkit.getOnlinePlayers()) {
            other.showPlayer((Plugin)this, player);
        }
        player.setGlowing(false);
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "You are no longer hidden.");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.hiddenPlayers.contains(player.getUniqueId())) {
            this.hidePlayer(player);
            event.joinMessage(null);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        if (this.hiddenPlayers.contains(event.getPlayer().getUniqueId())) {
            event.quitMessage(null);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        if (this.hiddenPlayers.contains(event.getEntity().getUniqueId())) {
            event.deathMessage(null);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (this.hiddenPlayers.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot chat while hidden.");
        }
    }

    @EventHandler
    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        if (this.hiddenPlayers.contains(event.getPlayer().getUniqueId()) && event.message() != null) {
            event.message(null);
        }
    }

    @EventHandler
    public void onPing(PaperServerListPingEvent event) {
        int visibleCount = 0;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (this.hiddenPlayers.contains(p.getUniqueId())) continue;
            ++visibleCount;
        }
        event.setNumPlayers(visibleCount);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.isOp()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission.");
            return true;
        }
        switch (command.getName().toLowerCase()) {
            case "hideplayer": {
                if (args.length != 1) {
                    return false;
                }
                Player toHide = Bukkit.getPlayer((String)args[0]);
                if (toHide != null) {
                    this.hiddenPlayers.add(toHide.getUniqueId());
                    this.hidePlayer(toHide);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + toHide.getName() + " is now hidden.");
                }
                return true;
            }
            case "unhideplayer": {
                if (args.length != 1) {
                    return false;
                }
                Player toUnhide = Bukkit.getPlayer((String)args[0]);
                if (toUnhide != null) {
                    this.hiddenPlayers.remove(toUnhide.getUniqueId());
                    this.unhidePlayer(toUnhide);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + toUnhide.getName() + " is no longer hidden.");
                }
                return true;
            }
            case "whitelistplayer": {
                if (args.length != 1) {
                    return false;
                }
                Player toWhitelist = Bukkit.getPlayer((String)args[0]);
                if (toWhitelist != null) {
                    this.whitelistedPlayers.add(toWhitelist.getUniqueId());
                    for (UUID uuid : this.hiddenPlayers) {
                        Player player = Bukkit.getPlayer((UUID)uuid);
                        if (player == null) continue;
                        toWhitelist.showPlayer((Plugin)this, player);
                        player.setGlowing(true);
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + toWhitelist.getName() + " can now see hidden players.");
                }
                return true;
            }
            case "unwhitelistplayer": {
                if (args.length != 1) {
                    return false;
                }
                Player toUnwhitelist = Bukkit.getPlayer((String)args[0]);
                if (toUnwhitelist != null) {
                    this.whitelistedPlayers.remove(toUnwhitelist.getUniqueId());
                    for (UUID uUID : this.hiddenPlayers) {
                        Player hidden = Bukkit.getPlayer((UUID)uUID);
                        if (hidden == null) continue;
                        toUnwhitelist.hidePlayer((Plugin)this, hidden);
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + toUnwhitelist.getName() + " can no longer see hidden players.");
                }
                return true;
            }
            case "internalreload": {
                this.reloadConfig();
                this.hiddenPlayers.clear();
                this.whitelistedPlayers.clear();
                for (String string : this.getConfig().getStringList("hiddenPlayers")) {
                    this.hiddenPlayers.add(UUID.fromString(string));
                }
                for (String string : this.getConfig().getStringList("whitelistedPlayers")) {
                    this.whitelistedPlayers.add(UUID.fromString(string));
                }
                for (UUID uUID : this.hiddenPlayers) {
                    Player p = Bukkit.getPlayer((UUID)uUID);
                    if (p == null || !p.isOnline()) continue;
                    this.hidePlayer(p);
                }
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "InternalSystem reloaded.");
                return true;
            }
        }
        return false;
    }
}

