/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.fasterminecarts;

import org.bukkit.Bukkit;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FasterMinecarts
extends JavaPlugin
implements Listener {
    private double maxSpeed;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadSettings();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("FasterMinecarts enabled! Max speed = " + this.maxSpeed);
    }

    private void loadSettings() {
        this.maxSpeed = this.getConfig().getDouble("max-speed", 1.2);
    }

    @EventHandler
    public void onMinecartSpawn(VehicleCreateEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Minecart) {
            Minecart cart = (Minecart)vehicle;
            cart.setMaxSpeed(this.maxSpeed);
        }
    }

    @EventHandler
    public void onMinecartEnter(VehicleEnterEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Minecart) {
            Minecart cart = (Minecart)vehicle;
            cart.setMaxSpeed(this.maxSpeed);
        }
    }
}

