/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config;

import java.util.function.Function;
import net.replaceitem.reconfigure.api.Bindable;
import net.replaceitem.reconfigure.config.AbstractBindable;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class MappedBindable<T, U>
extends AbstractBindable<T> {
    @Nullable
    private T cached;
    private boolean invalid = true;
    private final Function<U, T> mapper;
    private final Bindable<U> upstream;

    MappedBindable(Function<U, T> mapper, Bindable<U> upstream) {
        this.mapper = mapper;
        this.upstream = upstream;
        this.upstream.addListener(u -> {
            this.invalid = true;
            if (this.hasListeners()) {
                this.callListeners(this.get());
            }
        });
    }

    @Override
    public @UnknownNullability T get() {
        if (this.invalid) {
            this.cached = this.mapper.apply(this.upstream.get());
        }
        this.invalid = false;
        return this.cached;
    }
}

