/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.property.builder;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.replaceitem.reconfigure.api.property.EnumPropertyBuilder;
import net.replaceitem.reconfigure.config.property.PropertyBuildContext;
import net.replaceitem.reconfigure.config.property.builder.PropertyBuilderImpl;
import net.replaceitem.reconfigure.config.serialization.Intermediary;
import net.replaceitem.reconfigure.config.serialization.TypeAdapter;
import net.replaceitem.reconfigure.config.widget.builder.CyclingButtonWidgetBuilderImpl;

public class EnumPropertyBuilderImpl<T>
extends PropertyBuilderImpl<EnumPropertyBuilder<T>, T>
implements EnumPropertyBuilder<T> {
    private final Collection<T> values;

    public EnumPropertyBuilderImpl(PropertyBuildContext propertyBuildContext, class_2960 id, Collection<T> values) {
        super(propertyBuildContext, id, values.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("EnumProperty " + String.valueOf(id) + " cannot have no values, must be at least one.")));
        this.values = values;
    }

    @Override
    public CyclingButtonWidgetBuilderImpl<T> asCyclingButton() {
        return new CyclingButtonWidgetBuilderImpl<T>(this.propertyBuildContext, this, this.values).valueToText(value -> class_2561.method_43471((String)this.id.method_48747("reconfigure.property", "enum." + value.toString().toLowerCase())));
    }

    @Override
    protected TypeAdapter<T, Intermediary.IntermediaryString> getTypeAdapter() {
        return TypeAdapter.forEnum(this.values);
    }

    @Override
    protected void preBuild() {
        super.preBuild();
        if (!this.values.contains(this.defaultValue)) {
            throw new RuntimeException("Default value isn't one of the values " + this.values.stream().map(Objects::toString).collect(Collectors.joining(", ")) + " of enum property " + String.valueOf(this.id));
        }
    }
}

