/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.property.builder;

import java.util.function.Function;
import net.minecraft.class_2960;
import net.replaceitem.reconfigure.api.Property;
import net.replaceitem.reconfigure.api.Validator;
import net.replaceitem.reconfigure.api.property.PropertyBuilder;
import net.replaceitem.reconfigure.config.BaseSettings;
import net.replaceitem.reconfigure.config.PropertyHolder;
import net.replaceitem.reconfigure.config.ValidatorList;
import net.replaceitem.reconfigure.config.property.PropertyBuildContext;
import net.replaceitem.reconfigure.config.property.PropertyImpl;
import net.replaceitem.reconfigure.config.serialization.TypeAdapter;
import net.replaceitem.reconfigure.config.widget.ConfigWidgetFactory;
import net.replaceitem.reconfigure.config.widget.builder.CustomWidgetBuilderImpl;

public abstract class PropertyBuilderImpl<SELF extends PropertyBuilder<SELF, T>, T>
implements PropertyBuilder<SELF, T> {
    protected final PropertyBuildContext propertyBuildContext;
    protected T defaultValue;
    protected final class_2960 id;
    protected final ValidatorList<T> validators = new ValidatorList();

    protected PropertyBuilderImpl(PropertyBuildContext propertyBuildContext, class_2960 id, T defaultValue) {
        this.propertyBuildContext = propertyBuildContext;
        this.id = id;
        this.defaultValue = defaultValue;
    }

    @Override
    public SELF defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this.self();
    }

    @Override
    public SELF addValidator(Validator<T> validator) {
        this.validators.add(validator);
        return this.self();
    }

    @Override
    public CustomWidgetBuilderImpl<T> asCustomWidget(Function<BaseSettings, ConfigWidgetFactory<T>> widgetFactorySupplier) {
        return new CustomWidgetBuilderImpl<T>(this.propertyBuildContext, this, widgetFactorySupplier);
    }

    @Override
    public Property<T> buildWithoutWidget() {
        PropertyHolder<T> propertyHolder = this.build();
        this.propertyBuildContext.addProperty(propertyHolder);
        return propertyHolder.getProperty();
    }

    public class_2960 getId() {
        return this.id;
    }

    protected abstract TypeAdapter<T, ?> getTypeAdapter();

    protected void preBuild() {
    }

    protected void postBuild(PropertyHolder<T> property) {
    }

    public final PropertyHolder<T> build() {
        this.preBuild();
        PropertyHolder<T> property = this.buildImpl();
        this.postBuild(property);
        return property;
    }

    protected PropertyHolder<T> buildImpl() {
        PropertyImpl<T> property = new PropertyImpl<T>(this.id, this.defaultValue, this.validators);
        return new PropertyHolder<T>(property, this.getTypeAdapter(), null);
    }

    protected SELF self() {
        return (SELF)this;
    }
}

