/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.serialization;

import java.util.List;
import net.replaceitem.reconfigure.Reconfigure;
import net.replaceitem.reconfigure.config.serialization.Intermediary;
import net.replaceitem.reconfigure.config.serialization.IntermediaryType;
import net.replaceitem.reconfigure.config.serialization.SerializationException;
import net.replaceitem.reconfigure.config.serialization.SerializationTarget;
import net.replaceitem.reconfigure.config.serialization.TypeAdapter;

public abstract class Marshaller<T> {
    public abstract T marshall(Intermediary<?> var1);

    public <M extends Intermediary<?>> M unmarshall(T value, IntermediaryType<M> type) throws SerializationException {
        if (type == IntermediaryType.STRING) {
            return type.cast(new Intermediary.IntermediaryString(this.unmarshallString(value)));
        }
        if (type == IntermediaryType.INTEGER) {
            return type.cast(new Intermediary.IntermediaryInteger(this.unmarshallInteger(value)));
        }
        if (type == IntermediaryType.DOUBLE) {
            return type.cast(new Intermediary.IntermediaryDouble(this.unmarshallDouble(value)));
        }
        if (type == IntermediaryType.BOOLEAN) {
            return type.cast(new Intermediary.IntermediaryBoolean(this.unmarshallBoolean(value)));
        }
        if (type == IntermediaryType.LIST) {
            return type.cast(new Intermediary.IntermediaryList(this.unmarshallList(value)));
        }
        throw new SerializationException("Cannot unmarshall to type " + String.valueOf(type));
    }

    protected abstract String unmarshallString(T var1) throws SerializationException;

    protected abstract Integer unmarshallInteger(T var1) throws SerializationException;

    protected abstract Double unmarshallDouble(T var1) throws SerializationException;

    protected abstract Boolean unmarshallBoolean(T var1) throws SerializationException;

    protected abstract List<String> unmarshallList(T var1) throws SerializationException;

    public <P> void setProperty(SerializationTarget.SerializationProperty<P> holder, T value) {
        TypeAdapter<P, ?> typeAdapter = holder.getTypeAdapter();
        try {
            P propertyValue = this.convertToProperty(typeAdapter, value);
            holder.setOrDefault(propertyValue);
        }
        catch (SerializationException e) {
            Reconfigure.LOGGER.error("Could not set property {}", (Object)holder.getId(), (Object)e);
        }
    }

    protected <P, M extends Intermediary<?>> P convertToProperty(TypeAdapter<P, M> typeAdapter, T value) throws SerializationException {
        M intermediary = this.unmarshall(value, typeAdapter.getType());
        return typeAdapter.fromIntermediary(intermediary);
    }

    public <P> T getProperty(SerializationTarget.SerializationProperty<P> holder) {
        P propertyValue = holder.get();
        return this.convertFromProperty(holder.getTypeAdapter(), propertyValue);
    }

    protected <P, M extends Intermediary<?>> T convertFromProperty(TypeAdapter<P, M> typeAdapter, P propertyValue) {
        M intermediary = typeAdapter.toIntermediary(propertyValue);
        return this.marshall((Intermediary<?>)intermediary);
    }
}

