/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import net.replaceitem.reconfigure.Reconfigure;
import net.replaceitem.reconfigure.config.serialization.Marshaller;
import net.replaceitem.reconfigure.config.serialization.SerializationTarget;
import org.jetbrains.annotations.Nullable;

public abstract class Serializer<T, C> {
    @Nullable
    private final Consumer<C> preLoad;
    @Nullable
    private final Consumer<C> preWrite;

    protected Serializer(@Nullable Consumer<C> preLoad, @Nullable Consumer<C> preWrite) {
        this.preLoad = preLoad;
        this.preWrite = preWrite;
    }

    protected abstract void write(OutputStream var1, C var2) throws IOException;

    protected abstract C read(InputStream var1) throws IOException;

    protected abstract void load(SerializationTarget var1, C var2) throws IOException;

    protected abstract C save(SerializationTarget var1) throws IOException;

    public abstract String getFileExtension();

    public abstract Marshaller<T> getMarshaller();

    public void serialize(SerializationTarget serializationTarget, OutputStream outputStream) throws IOException {
        C saved = this.save(serializationTarget);
        if (this.preWrite != null) {
            this.preWrite.accept(saved);
        }
        this.write(outputStream, saved);
    }

    public void deserialize(SerializationTarget serializationTarget, InputStream outputStream) throws IOException {
        C read = this.read(outputStream);
        if (this.preLoad != null) {
            this.preLoad.accept(read);
        }
        this.load(serializationTarget, read);
    }

    protected void setProperty(SerializationTarget target, String key, T value) {
        SerializationTarget.SerializationProperty<?> property = target.getProperty(key);
        if (property == null) {
            Reconfigure.LOGGER.info("Could not load property {} from file because it is not defined in the config", (Object)key);
            return;
        }
        this.getMarshaller().setProperty(property, value);
    }

    protected T getProperty(SerializationTarget.SerializationProperty<?> property) {
        return this.getMarshaller().getProperty(property);
    }
}

