/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.serialization;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.replaceitem.reconfigure.config.serialization.Intermediary;
import net.replaceitem.reconfigure.config.serialization.IntermediaryType;
import net.replaceitem.reconfigure.config.serialization.SerializationException;

public abstract class TypeAdapter<T, M extends Intermediary<?>> {
    private final IntermediaryType<M> type;
    public static final TypeAdapter<String, Intermediary.IntermediaryString> STRING = TypeAdapter.simple(IntermediaryType.STRING, Intermediary.IntermediaryString::new);
    public static final TypeAdapter<Integer, Intermediary.IntermediaryInteger> INTEGER = TypeAdapter.simple(IntermediaryType.INTEGER, Intermediary.IntermediaryInteger::new);
    public static final TypeAdapter<Double, Intermediary.IntermediaryDouble> DOUBLE = TypeAdapter.simple(IntermediaryType.DOUBLE, Intermediary.IntermediaryDouble::new);
    public static final TypeAdapter<Boolean, Intermediary.IntermediaryBoolean> BOOLEAN = TypeAdapter.simple(IntermediaryType.BOOLEAN, Intermediary.IntermediaryBoolean::new);
    public static final TypeAdapter<List<String>, Intermediary.IntermediaryList> LIST = TypeAdapter.simple(IntermediaryType.LIST, Intermediary.IntermediaryList::new);

    protected TypeAdapter(IntermediaryType<M> type) {
        this.type = type;
    }

    public IntermediaryType<M> getType() {
        return this.type;
    }

    public abstract T fromIntermediary(M var1) throws SerializationException;

    public abstract M toIntermediary(T var1);

    public static <T> TypeAdapter<T, Intermediary.IntermediaryString> forEnum(final Collection<T> values) {
        return new TypeAdapter<T, Intermediary.IntermediaryString>(IntermediaryType.STRING){

            @Override
            public T fromIntermediary(Intermediary.IntermediaryString intermediary) throws SerializationException {
                String name = (String)intermediary.getValue();
                return values.stream().filter(t -> Objects.equals(t.toString(), name)).findFirst().orElseThrow(() -> new SerializationException("Expected one of " + values.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }

            @Override
            public Intermediary.IntermediaryString toIntermediary(T t) {
                return new Intermediary.IntermediaryString(t.toString());
            }
        };
    }

    private static <T, M extends Intermediary<T>> TypeAdapter<T, M> simple(IntermediaryType<M> type, final Function<T, M> constructor) {
        return new TypeAdapter<T, M>(type){

            @Override
            public T fromIntermediary(M intermediaryType) {
                return ((Intermediary)intermediaryType).getValue();
            }

            @Override
            public M toIntermediary(T t) {
                return (Intermediary)constructor.apply(t);
            }
        };
    }
}

