/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.serialization.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.replaceitem.reconfigure.config.serialization.CharSerializer;
import net.replaceitem.reconfigure.config.serialization.Intermediary;
import net.replaceitem.reconfigure.config.serialization.Marshaller;
import net.replaceitem.reconfigure.config.serialization.SerializationException;
import net.replaceitem.reconfigure.config.serialization.SerializationTarget;
import org.jetbrains.annotations.Nullable;

public class JsonSerializer
extends CharSerializer<JsonElement, JsonObject> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static final JsonMarshaller MARSHALLER = new JsonMarshaller();

    public JsonSerializer(@Nullable Consumer<JsonObject> preLoad, @Nullable Consumer<JsonObject> preWrite) {
        super(preLoad, preWrite);
    }

    @Override
    public Marshaller<JsonElement> getMarshaller() {
        return MARSHALLER;
    }

    @Override
    protected JsonObject read(Reader reader) throws IOException, JsonParseException {
        JsonElement jsonElement;
        try (JsonReader jsonReader = GSON.newJsonReader(reader);){
            jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
        }
        if (!(jsonElement instanceof JsonObject)) {
            throw new JsonParseException("Expected a json object");
        }
        JsonObject jsonObject = (JsonObject)jsonElement;
        return jsonObject;
    }

    @Override
    protected void write(Writer writer, JsonObject compound) throws IOException, JsonParseException {
        try (JsonWriter jsonWriter = GSON.newJsonWriter(writer);){
            GSON.toJson((JsonElement)compound, jsonWriter);
        }
    }

    @Override
    protected void load(SerializationTarget target, JsonObject compound) {
        for (Map.Entry entry : compound.entrySet()) {
            this.setProperty(target, (String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    @Override
    protected JsonObject save(SerializationTarget target) {
        JsonObject jsonObject = new JsonObject();
        for (SerializationTarget.SerializationProperty<?> property : target.getProperties()) {
            JsonElement jsonElement = (JsonElement)this.getProperty(property);
            jsonObject.add(property.getId().method_12832(), jsonElement);
        }
        return jsonObject;
    }

    @Override
    public String getFileExtension() {
        return "json";
    }

    private static class JsonMarshaller
    extends Marshaller<JsonElement> {
        private JsonMarshaller() {
        }

        @Override
        public JsonElement marshall(Intermediary<?> intermediary) {
            Intermediary<?> intermediary2 = intermediary;
            Objects.requireNonNull(intermediary2);
            Intermediary<?> intermediary3 = intermediary2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Intermediary.IntermediaryString.class, Intermediary.IntermediaryInteger.class, Intermediary.IntermediaryDouble.class, Intermediary.IntermediaryBoolean.class, Intermediary.IntermediaryList.class}, intermediary3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Intermediary.IntermediaryString intermediaryString = (Intermediary.IntermediaryString)intermediary3;
                    yield new JsonPrimitive((String)intermediaryString.getValue());
                }
                case 1 -> {
                    Intermediary.IntermediaryInteger intermediaryInteger = (Intermediary.IntermediaryInteger)intermediary3;
                    yield new JsonPrimitive((Number)intermediaryInteger.getValue());
                }
                case 2 -> {
                    Intermediary.IntermediaryDouble intermediaryDouble = (Intermediary.IntermediaryDouble)intermediary3;
                    yield new JsonPrimitive((Number)intermediaryDouble.getValue());
                }
                case 3 -> {
                    Intermediary.IntermediaryBoolean intermediaryBoolean = (Intermediary.IntermediaryBoolean)intermediary3;
                    yield new JsonPrimitive((Boolean)intermediaryBoolean.getValue());
                }
                case 4 -> {
                    Intermediary.IntermediaryList intermediaryList = (Intermediary.IntermediaryList)intermediary3;
                    yield JsonOps.INSTANCE.createList(((List)intermediaryList.getValue()).stream().map(JsonPrimitive::new));
                }
            };
        }

        @Override
        protected String unmarshallString(JsonElement value) throws SerializationException {
            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isString()) {
                throw new SerializationException("Expected a string");
            }
            return value.getAsString();
        }

        @Override
        protected Integer unmarshallInteger(JsonElement value) throws SerializationException {
            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isNumber()) {
                throw new SerializationException("Expected an integer");
            }
            return value.getAsInt();
        }

        @Override
        protected Double unmarshallDouble(JsonElement value) throws SerializationException {
            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isNumber()) {
                throw new SerializationException("Expected a double");
            }
            return value.getAsDouble();
        }

        @Override
        protected Boolean unmarshallBoolean(JsonElement value) throws SerializationException {
            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isBoolean()) {
                throw new SerializationException("Expected a boolean");
            }
            return value.getAsBoolean();
        }

        @Override
        protected List<String> unmarshallList(JsonElement value) throws SerializationException {
            if (!value.isJsonArray()) {
                throw new SerializationException("Expected a list");
            }
            return new ArrayList<String>(value.getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList());
        }
    }
}

