/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.serialization.serializer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.replaceitem.reconfigure.config.serialization.Intermediary;
import net.replaceitem.reconfigure.config.serialization.Marshaller;
import net.replaceitem.reconfigure.config.serialization.SerializationException;
import net.replaceitem.reconfigure.config.serialization.SerializationTarget;
import net.replaceitem.reconfigure.config.serialization.Serializer;
import org.jetbrains.annotations.Nullable;

public class NbtSerializer
extends Serializer<class_2520, class_2487> {
    private static final NbtMarshaller MARSHALLER = new NbtMarshaller();

    public NbtSerializer(@Nullable Consumer<class_2487> preLoad, @Nullable Consumer<class_2487> preWrite) {
        super(preLoad, preWrite);
    }

    @Override
    protected void write(OutputStream outputStream, class_2487 compound) throws IOException {
        class_2507.method_10628((class_2487)compound, (DataOutput)new DataOutputStream(outputStream));
    }

    @Override
    protected class_2487 read(InputStream inputStream) throws IOException {
        return class_2507.method_10625((DataInput)new DataInputStream(inputStream), (class_2505)class_2505.method_53898());
    }

    @Override
    protected void load(SerializationTarget target, class_2487 compound) {
        for (String key : compound.method_10541()) {
            class_2520 value = compound.method_10580(key);
            if (value == null) continue;
            this.setProperty(target, key, value);
        }
    }

    @Override
    protected class_2487 save(SerializationTarget target) {
        class_2487 nbtCompound = new class_2487();
        for (SerializationTarget.SerializationProperty<?> property : target.getProperties()) {
            class_2520 value = (class_2520)this.getProperty(property);
            nbtCompound.method_10566(property.getId().method_12832(), value);
        }
        return nbtCompound;
    }

    @Override
    public String getFileExtension() {
        return "nbt";
    }

    @Override
    public Marshaller<class_2520> getMarshaller() {
        return MARSHALLER;
    }

    private static class NbtMarshaller
    extends Marshaller<class_2520> {
        private NbtMarshaller() {
        }

        @Override
        public class_2520 marshall(Intermediary<?> intermediary) {
            Intermediary<?> intermediary2 = intermediary;
            Objects.requireNonNull(intermediary2);
            Intermediary<?> intermediary3 = intermediary2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Intermediary.IntermediaryString.class, Intermediary.IntermediaryInteger.class, Intermediary.IntermediaryDouble.class, Intermediary.IntermediaryBoolean.class, Intermediary.IntermediaryList.class}, intermediary3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Intermediary.IntermediaryString intermediaryString = (Intermediary.IntermediaryString)intermediary3;
                    yield class_2519.method_23256((String)((String)intermediaryString.getValue()));
                }
                case 1 -> {
                    Intermediary.IntermediaryInteger intermediaryInteger = (Intermediary.IntermediaryInteger)intermediary3;
                    yield class_2497.method_23247((int)((Integer)intermediaryInteger.getValue()));
                }
                case 2 -> {
                    Intermediary.IntermediaryDouble intermediaryDouble = (Intermediary.IntermediaryDouble)intermediary3;
                    yield class_2489.method_23241((double)((Double)intermediaryDouble.getValue()));
                }
                case 3 -> {
                    Intermediary.IntermediaryBoolean intermediaryBoolean = (Intermediary.IntermediaryBoolean)intermediary3;
                    yield class_2481.method_23234((boolean)((Boolean)intermediaryBoolean.getValue()));
                }
                case 4 -> {
                    Intermediary.IntermediaryList intermediaryList = (Intermediary.IntermediaryList)intermediary3;
                    yield NbtMarshaller.createStringList((List)intermediaryList.getValue());
                }
            };
        }

        @Override
        protected String unmarshallString(class_2520 value) throws SerializationException {
            return (String)value.method_68658().orElseThrow(() -> new SerializationException("Expected a string"));
        }

        @Override
        protected Integer unmarshallInteger(class_2520 value) throws SerializationException {
            if (!(value instanceof class_2514)) {
                throw new SerializationException("Expected a number");
            }
            class_2514 nbtNumber = (class_2514)value;
            return nbtNumber.method_10701();
        }

        @Override
        protected Double unmarshallDouble(class_2520 value) throws SerializationException {
            if (!(value instanceof class_2514)) {
                throw new SerializationException("Expected a number");
            }
            class_2514 nbtNumber = (class_2514)value;
            return nbtNumber.method_10697();
        }

        @Override
        protected Boolean unmarshallBoolean(class_2520 value) throws SerializationException {
            if (!(value instanceof class_2481)) {
                throw new SerializationException("Expected a byte");
            }
            class_2481 nbtNumber = (class_2481)value;
            return nbtNumber.method_10698() != 0;
        }

        @Override
        protected List<String> unmarshallList(class_2520 value) throws SerializationException {
            if (!(value instanceof class_2499)) {
                throw new SerializationException("Expected a list");
            }
            class_2499 nbtList = (class_2499)value;
            return new ArrayList<String>(nbtList.stream().map(class_2520::toString).toList());
        }

        private static class_2499 createStringList(List<String> strings) {
            class_2499 nbtList = new class_2499();
            nbtList.addAll(strings.stream().map(class_2519::method_23256).toList());
            return nbtList;
        }
    }
}

