/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.widget.builder;

import java.util.function.DoubleFunction;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.replaceitem.reconfigure.api.widget.SliderWidgetBuilder;
import net.replaceitem.reconfigure.config.BaseSettings;
import net.replaceitem.reconfigure.config.PropertyHolder;
import net.replaceitem.reconfigure.config.property.PropertyBuildContext;
import net.replaceitem.reconfigure.config.property.builder.PropertyBuilderImpl;
import net.replaceitem.reconfigure.config.widget.ConfigWidgetFactory;
import net.replaceitem.reconfigure.config.widget.builder.WidgetBuilderImpl;
import net.replaceitem.reconfigure.screen.widget.config.SliderConfigWidget;
import org.jetbrains.annotations.Nullable;

public abstract class SliderWidgetBuilderImpl<SELF extends SliderWidgetBuilderImpl<SELF, T>, T extends Number>
extends WidgetBuilderImpl<SELF, T>
implements SliderWidgetBuilder<SELF, T> {
    @Nullable
    protected T min;
    @Nullable
    protected T max;
    @Nullable
    protected T step;
    @Nullable
    private DoubleFunction<T> controlToValue;
    @Nullable
    private Function<T, Double> valueToControl;
    @Nullable
    private Function<T, class_2561> valueToText;

    protected SliderWidgetBuilderImpl(PropertyBuildContext propertyBuildContext, PropertyBuilderImpl<?, T> propertyBuilder) {
        super(propertyBuildContext, propertyBuilder);
    }

    @Override
    public SELF min(T min) {
        this.min = min;
        return (SELF)((SliderWidgetBuilderImpl)this.self());
    }

    @Override
    public SELF max(T max) {
        this.max = max;
        return (SELF)((SliderWidgetBuilderImpl)this.self());
    }

    @Override
    public SELF step(T step) {
        this.step = step;
        return (SELF)((SliderWidgetBuilderImpl)this.self());
    }

    @Override
    protected void preBuild(PropertyHolder<T> property) {
        super.preBuild(property);
        if (this.min == null) {
            throw new RuntimeException("Missing min value for slider widget " + String.valueOf(property.getId()));
        }
        if (this.max == null) {
            throw new RuntimeException("Missing max value for slider widget " + String.valueOf(property.getId()));
        }
        if (this.controlToValue == null) {
            this.controlToValue = this.defaultControlToNumber(this.min, this.max);
        }
        if (this.valueToControl == null) {
            this.valueToControl = this.defaultNumberToControl(this.min, this.max);
        }
        if (this.valueToText == null) {
            this.valueToText = this.defaultNumberToText(this.min, this.max);
        }
    }

    @Override
    protected ConfigWidgetFactory<T> buildWidgetFactory(BaseSettings baseSettings) {
        assert (this.controlToValue != null);
        assert (this.valueToControl != null);
        assert (this.valueToText != null);
        return (parent, property) -> new SliderConfigWidget<T>(parent, property, baseSettings, this.controlToValue, this.valueToControl, this.valueToText);
    }

    protected abstract DoubleFunction<T> defaultControlToNumber(T var1, T var2);

    protected abstract Function<T, Double> defaultNumberToControl(T var1, T var2);

    protected abstract Function<T, class_2561> defaultNumberToText(T var1, T var2);

    public static IntSliderWidgetBuilder createInt(PropertyBuildContext propertyBuildContext, PropertyBuilderImpl<?, Integer> propertyBuilder) {
        return new IntSliderWidgetBuilder(propertyBuildContext, propertyBuilder);
    }

    public static DoubleSliderWidgetBuilder createDouble(PropertyBuildContext propertyBuildContext, PropertyBuilderImpl<?, Double> propertyBuilder) {
        return new DoubleSliderWidgetBuilder(propertyBuildContext, propertyBuilder);
    }

    private static double floorToMultiple(double val, double multiple) {
        return multiple * Math.floor(val / multiple);
    }

    private static double roundToMultiple(double val, double multiple) {
        return multiple * (double)Math.round(val / multiple);
    }

    private static int roundToMultiple(double val, int multiple) {
        return (int)((long)multiple * Math.round(val / (double)multiple));
    }

    private static int floorToMultiple(int val, int multiple) {
        return multiple * Math.floorDiv(val, multiple);
    }

    public static class IntSliderWidgetBuilder
    extends SliderWidgetBuilderImpl<IntSliderWidgetBuilder, Integer> {
        protected IntSliderWidgetBuilder(PropertyBuildContext propertyBuildContext, PropertyBuilderImpl<?, Integer> propertyBuilder) {
            super(propertyBuildContext, propertyBuilder);
        }

        @Override
        protected DoubleFunction<Integer> defaultControlToNumber(Integer min, Integer max) {
            int multiple = this.step == null ? 1 : (Integer)this.step;
            int diff = SliderWidgetBuilderImpl.floorToMultiple(max - min, multiple);
            return value -> min + SliderWidgetBuilderImpl.roundToMultiple(value * (double)diff, multiple);
        }

        @Override
        protected Function<Integer, Double> defaultNumberToControl(Integer min, Integer max) {
            int diff = max - min;
            return value -> (double)(class_3532.method_15340((int)value, (int)min, (int)max) - min) / (double)diff;
        }

        @Override
        protected Function<Integer, class_2561> defaultNumberToText(Integer min, Integer max) {
            return number -> class_2561.method_43470((String)number.toString());
        }
    }

    public static class DoubleSliderWidgetBuilder
    extends SliderWidgetBuilderImpl<DoubleSliderWidgetBuilder, Double> {
        private static final int RELEVANT_DIGITS = 4;

        protected DoubleSliderWidgetBuilder(PropertyBuildContext propertyBuildContext, PropertyBuilderImpl<?, Double> propertyBuilder) {
            super(propertyBuildContext, propertyBuilder);
        }

        @Override
        protected DoubleFunction<Double> defaultControlToNumber(Double min, Double max) {
            if (this.step == null) {
                double diff = max - min;
                return value -> min + value * diff;
            }
            double diff = SliderWidgetBuilderImpl.floorToMultiple(max - min, (Double)this.step);
            return value -> min + SliderWidgetBuilderImpl.roundToMultiple(value * diff, (Double)this.step);
        }

        @Override
        protected Function<Double, Double> defaultNumberToControl(Double min, Double max) {
            double diff = max - min;
            return value -> (class_3532.method_15350((double)value, (double)min, (double)max) - min) / diff;
        }

        @Override
        protected Function<Double, class_2561> defaultNumberToText(Double min, Double max) {
            int decimalDigits = Math.max(1, 4 - (int)Math.floor(Math.log10(Math.max(Math.abs(min), Math.abs(max)))));
            String formatString = "%." + decimalDigits + "f";
            return number -> class_2561.method_43470((String)String.format(formatString, number));
        }
    }
}

