/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.screen.widget.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_342;
import net.minecraft.class_5481;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_9848;
import net.replaceitem.reconfigure.config.BaseSettings;
import net.replaceitem.reconfigure.config.property.PropertyImpl;
import net.replaceitem.reconfigure.screen.ConfigWidgetList;
import net.replaceitem.reconfigure.screen.widget.ColorPlanePickerWidget;
import net.replaceitem.reconfigure.screen.widget.ColorPreviewWidget;
import net.replaceitem.reconfigure.screen.widget.GradientSlider;
import net.replaceitem.reconfigure.screen.widget.config.PropertyConfigWidget;
import net.replaceitem.reconfigure.util.ColorUtil;
import net.replaceitem.reconfigure.util.ScopedThreadLocal;
import org.jetbrains.annotations.Nullable;

public class ColorPickerConfigWidget
extends PropertyConfigWidget<Integer> {
    private final class_342 textField;
    private final ColorPreviewWidget colorPreviewWidget;
    private final ColorPlanePickerWidget colorPlanePickerWidget;
    private final GradientSlider hueSlider;
    private final GradientSlider saturationSlider;
    private final GradientSlider valueSlider;
    private final GradientSlider alphaSlider;
    private final class_7845 grid = new class_7845(0, 0);
    private boolean isOpen = false;
    private boolean isInvalid = false;
    private int color;
    private static final int EXPANSION_HEIGHT = 104;
    private static final int SPACING = 8;
    private final ScopedThreadLocal<Boolean> update = new ScopedThreadLocal();
    private static final Pattern HEX_PATTERN = Pattern.compile("^#?([\\dA-F]{3,8})$");

    public ColorPickerConfigWidget(ConfigWidgetList listWidget, PropertyImpl<Integer> property, BaseSettings baseSettings) {
        super(listWidget, 26, property, baseSettings);
        this.colorPreviewWidget = new ColorPreviewWidget(0, 0, 20, 20){

            public void method_25348(class_11909 click, boolean doubled) {
                if (click.method_74245() == 0) {
                    ColorPickerConfigWidget.this.setOpen(!ColorPickerConfigWidget.this.isOpen);
                }
            }
        };
        this.textField = new class_342(listWidget.getTextRenderer(), 70, 20, (class_2561)class_2561.method_43473());
        this.textField.method_1863(this::setColorFromTextField);
        this.textField.method_73210((string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)(this.isInvalid ? class_2583.field_24360.method_10977(class_124.field_1061) : class_2583.field_24360)));
        this.colorPlanePickerWidget = new ColorPlanePickerWidget(0, 0, 0, 104){

            @Override
            public void onColorChanged(float hue, float saturation, float value) {
                ColorPickerConfigWidget.this.setColor(new BiFormatColor(new ColorUtil.HSVColor(hue, saturation, value), (float)ColorPickerConfigWidget.this.alphaSlider.getValue()), UpdateTargets.PLANE);
            }
        };
        this.hueSlider = new GradientSlider(0, 0, 0, 20, (class_2561)class_2561.method_43473(), 0.0, v -> class_9848.method_61318((float)1.0f, (float)v, (float)0.5f, (float)0.5f)){

            @Override
            protected void method_25344() {
                ColorPickerConfigWidget.this.setColorFromSliders();
            }
        };
        this.saturationSlider = new GradientSlider(0, 0, 0, 20, (class_2561)class_2561.method_43473(), 1.0, v -> ColorUtil.hsvToRgb((float)this.hueSlider.getValue(), v, 1.0f)){

            @Override
            protected void method_25344() {
                ColorPickerConfigWidget.this.setColorFromSliders();
            }
        };
        this.valueSlider = new GradientSlider(0, 0, 0, 20, (class_2561)class_2561.method_43473(), 1.0, v -> ColorUtil.hsvToRgb((float)this.hueSlider.getValue(), (float)this.saturationSlider.getValue(), v)){

            @Override
            protected void method_25344() {
                ColorPickerConfigWidget.this.setColorFromSliders();
            }
        };
        this.alphaSlider = new GradientSlider(0, 0, 0, 20, (class_2561)class_2561.method_43473(), 1.0, v -> class_9848.method_61330((int)(v * 255), (int)ColorUtil.hsvToRgb((float)this.hueSlider.getValue(), (float)this.saturationSlider.getValue(), (float)this.valueSlider.getValue()))){

            @Override
            protected void method_25344() {
                ColorPickerConfigWidget.this.setColorFromSliders();
            }
        };
        this.hueSlider.setHsv(true);
        this.grid.method_48637(8);
        this.grid.method_46453((class_8021)this.colorPlanePickerWidget, 0, 0, 4, 1);
        this.grid.method_46452((class_8021)this.hueSlider, 0, 1);
        this.grid.method_46452((class_8021)this.saturationSlider, 1, 1);
        this.grid.method_46452((class_8021)this.valueSlider, 2, 1);
        this.grid.method_46452((class_8021)this.alphaSlider, 3, 1);
        this.grid.method_48206(this.children::add);
        this.children.add(this.textField);
        this.children.add(this.colorPreviewWidget);
        this.loadValue(property.get());
        this.setOpen(false);
    }

    private void setColor(BiFormatColor color, @Nullable UpdateTargets excludeUpdate) {
        if (this.update.get() == Boolean.FALSE) {
            return;
        }
        this.color = color.argb();
        this.colorPreviewWidget.setColor(color.argb());
        try (ScopedThreadLocal.ScopedValueCloseable ignored = this.update.with(false);){
            ColorUtil.HSVColor hsv = color.hsv();
            if (excludeUpdate != UpdateTargets.PLANE) {
                this.colorPlanePickerWidget.setFromHsv(hsv.hue(), hsv.saturation(), hsv.value());
            }
            if (excludeUpdate != UpdateTargets.SLIDERS) {
                this.hueSlider.setValue(hsv.hue());
                this.saturationSlider.setValue(hsv.saturation());
                this.valueSlider.setValue(hsv.value());
                this.alphaSlider.setValue(color.alpha());
            }
            if (excludeUpdate != UpdateTargets.TEXT_FIELD) {
                this.textField.method_1852(String.format("#%08X", color.argb()));
            }
        }
        this.onValueChanged();
    }

    private void setColorFromSliders() {
        float hue = (float)this.hueSlider.getValue();
        float saturation = (float)this.saturationSlider.getValue();
        float value = (float)this.valueSlider.getValue();
        float alpha = (float)this.alphaSlider.getValue();
        this.setColor(new BiFormatColor(new ColorUtil.HSVColor(hue, saturation, value), alpha), UpdateTargets.SLIDERS);
    }

    private void setColorFromTextField(String s) {
        Matcher matcher = HEX_PATTERN.matcher(s = s.toUpperCase());
        if (!matcher.matches()) {
            this.isInvalid = true;
            return;
        }
        String hex = matcher.group(1);
        if (hex.length() != 3 && hex.length() != 4 && hex.length() != 6 && hex.length() != 8) {
            this.isInvalid = true;
            return;
        }
        int hexInt = (int)Long.parseUnsignedLong(hex, 16);
        if (hex.length() <= 4) {
            hexInt = (hexInt & 0xF000) * 69632 | (hexInt & 0xF00) * 4352 | (hexInt & 0xF0) * 272 | (hexInt & 0xF) * 17;
        }
        if (hex.length() % 3 == 0) {
            hexInt |= 0xFF000000;
        }
        this.setColor(new BiFormatColor(hexInt), UpdateTargets.TEXT_FIELD);
        this.isInvalid = false;
    }

    private void setOpen(boolean open) {
        this.isOpen = open;
        this.setContentHeight(26 + (open ? 107 : 0));
        this.grid.method_48206(clickableWidget -> {
            clickableWidget.field_22764 = open;
        });
        this.parent.reposition();
    }

    @Override
    public void refreshPosition() {
        super.refreshPosition();
        int topRowY = this.method_73382() + 3;
        this.colorPreviewWidget.method_48229(this.method_73389() - 3 - this.resetButtonWidget.method_25368() - this.colorPreviewWidget.method_25368(), topRowY);
        this.textField.method_48229(this.colorPreviewWidget.method_46426() - this.textField.method_25368(), topRowY);
        int contentWidth = this.method_73387() - 6;
        this.colorPlanePickerWidget.method_25358(contentWidth / 2);
        int sliderWidth = contentWidth - this.colorPlanePickerWidget.method_25368() - 8;
        this.hueSlider.method_25358(sliderWidth);
        this.saturationSlider.method_25358(sliderWidth);
        this.valueSlider.method_25358(sliderWidth);
        this.alphaSlider.method_25358(sliderWidth);
        this.grid.method_48229(this.method_73380() + 3, this.method_73382() + 26);
        this.grid.method_48222();
    }

    @Override
    protected Integer getSaveValue() {
        return this.color;
    }

    @Override
    protected void loadValue(Integer value) {
        this.setColor(new BiFormatColor(value), null);
    }

    private record BiFormatColor(int argb, ColorUtil.HSVColor hsv, float alpha) {
        public BiFormatColor(int argb) {
            this(argb, ColorUtil.rgbToHsvFloats(argb), class_9848.method_65100((int)argb));
        }

        public BiFormatColor(ColorUtil.HSVColor hsv, float alpha) {
            this(class_9848.method_61330((int)class_9848.method_61326((float)alpha), (int)ColorUtil.hsvToRgb(hsv.hue(), hsv.saturation(), hsv.value())), hsv, alpha);
        }
    }

    private static enum UpdateTargets {
        PLANE,
        SLIDERS,
        TEXT_FIELD;

    }
}

