/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.screen.widget.config;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_8662;
import net.replaceitem.reconfigure.Reconfigure;
import net.replaceitem.reconfigure.api.ValidationResult;
import net.replaceitem.reconfigure.config.BaseSettings;
import net.replaceitem.reconfigure.config.property.PropertyImpl;
import net.replaceitem.reconfigure.screen.ConfigWidgetList;
import net.replaceitem.reconfigure.screen.widget.TooltippedTextWidget;
import net.replaceitem.reconfigure.screen.widget.config.ConfigWidget;

public abstract class PropertyConfigWidget<P>
extends ConfigWidget {
    public static final int INNER_PADDING = 3;
    public static final int BASIC_WIDGET_SIZE = 20;
    public static final int NAME_HEIGHT = 20;
    public static final int DEFAULT_HEIGHT = 26;
    private static final class_2960 RESET_ICON = Reconfigure.id("reconfigure/reset");
    protected final int textPadding;
    protected final PropertyImpl<P> property;
    private final BaseSettings baseSettings;
    protected ValidationResult validationResult = ValidationResult.valid();
    protected final TooltippedTextWidget nameWidget;
    protected final class_4185 resetButtonWidget;

    public PropertyConfigWidget(ConfigWidgetList listWidget, int contentHeight, PropertyImpl<P> property, BaseSettings baseSettings) {
        super(listWidget, contentHeight);
        this.property = property;
        this.baseSettings = baseSettings;
        this.nameWidget = new TooltippedTextWidget((class_2561)class_2561.method_43473(), this.parent.getTextRenderer());
        this.children.add(this.nameWidget);
        this.resetButtonWidget = class_8662.method_52723((class_2561)class_2561.method_43473(), button -> this.loadValue(this.property.getDefaultValue()), (boolean)true).method_52727(RESET_ICON, 10, 10).method_52725(20).method_52724();
        this.resetButtonWidget.field_22763 = !property.isDefault();
        this.children.add(this.resetButtonWidget);
        Objects.requireNonNull(this.parent.getTextRenderer());
        this.textPadding = 13 - 9 / 2;
        this.setNameText(this.property.get());
    }

    @Override
    public void refreshPosition() {
        super.refreshPosition();
        this.positionName();
        this.positionResetButton();
    }

    private void positionResetButton() {
        this.resetButtonWidget.method_48229(this.method_73389() - 3 - this.resetButtonWidget.method_25368(), this.method_73382() + 3);
    }

    protected void positionName() {
        int maxNameWidth = this.method_73387() / 2 - this.textPadding;
        this.nameWidget.method_73396(Math.min(this.parent.getTextRenderer().method_30880(this.nameWidget.method_25369().method_30937()), maxNameWidth));
        this.nameWidget.method_48229(this.method_73380() + this.textPadding, this.method_73382() + this.textPadding);
    }

    protected void positionNameFullWidth() {
        int maxNameWidth = this.method_73387() - 2 * this.textPadding;
        this.nameWidget.method_73396(Math.min(this.parent.getTextRenderer().method_30880(this.nameWidget.method_25369().method_30937()), maxNameWidth));
        this.nameWidget.method_48229(this.method_73380() + this.textPadding, this.method_73382() + this.textPadding);
    }

    @Override
    public void onSave() {
        this.property.set(this.getSaveValue());
    }

    protected void onValueChanged() {
        P saveValue = this.getSaveValue();
        this.validate(saveValue);
        this.setNameText(saveValue);
        this.resetButtonWidget.field_22763 = !this.property.isDefault(saveValue);
    }

    private void validate(P saveValue) {
        this.validationResult = this.property.validate(saveValue);
    }

    private void setNameText(P saveValue) {
        boolean wasChanged = !Objects.equals(saveValue, this.property.get());
        this.nameWidget.method_25355((class_2561)this.baseSettings.displayName().method_27661().method_27694(style -> {
            style = style.method_10978(Boolean.valueOf(wasChanged));
            if (this.validationResult.isInvalid()) {
                style = style.method_10977(class_124.field_1061);
            }
            return style;
        }));
        class_5250 tooltipText = class_2561.method_43473();
        if (this.baseSettings.tooltip() != null) {
            tooltipText.method_10852(this.baseSettings.tooltip());
        }
        if (this.baseSettings.tooltip() != null && this.validationResult.isInvalid()) {
            tooltipText.method_27693("\n");
        }
        if (this.validationResult.isInvalid()) {
            tooltipText.method_10852((class_2561)this.validationResult.getMessage().method_27661().method_27695(new class_124[0]).method_27694(style -> {
                if (style.method_10973() != null) {
                    return style;
                }
                return style.method_27706(class_124.field_1061);
            }));
        }
        this.nameWidget.setAdditionalTooltip((class_2561)tooltipText);
    }

    protected abstract P getSaveValue();

    protected abstract void loadValue(P var1);
}

