/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.screen.widget.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_7838;
import net.minecraft.class_7847;
import net.minecraft.class_8021;

public class FlowWidget
extends class_7838 {
    private final List<class_8021> children = new ArrayList<class_8021>();
    private final List<Element> elements = new ArrayList<Element>();
    private final class_7847 mainPositioner = class_7847.method_46481();
    private int flowSpacing = 0;
    private int wrapSpacing = 0;
    private final DisplayAxis flowAxis;

    public FlowWidget(DisplayAxis flowAxis) {
        this(0, 0, 0, 0, flowAxis);
    }

    public FlowWidget(int x, int y, int width, int height, DisplayAxis flowAxis) {
        super(x, y, width, height);
        this.flowAxis = flowAxis;
    }

    public void setFlowSpacing(int flowSpacing) {
        this.flowSpacing = flowSpacing;
    }

    public void setWrapSpacing(int wrapSpacing) {
        this.wrapSpacing = wrapSpacing;
    }

    public void setFlowWidth(int size) {
        switch (this.flowAxis.ordinal()) {
            case 0: {
                this.field_41813 = size;
                break;
            }
            case 1: {
                this.field_41814 = size;
            }
        }
    }

    public <T extends class_8021> T add(T widget) {
        return this.add(widget, this.getMainPositioner());
    }

    public <T extends class_8021> T add(T widget, class_7847 positioner) {
        this.elements.add(new Element(widget, positioner));
        this.children.add(widget);
        return widget;
    }

    public void method_48227(Consumer<class_8021> consumer) {
        this.children.forEach(consumer);
    }

    public void method_48222() {
        super.method_48222();
        int flowAxisPos = 0;
        int flowAxisTotalSize = this.flowAxis.getLength((class_8021)this);
        int flowAxisOrigin = this.flowAxis.getCoordinate((class_8021)this);
        int wrapAxisPos = 0;
        int wrapAxisOrigin = this.flowAxis.other().getCoordinate((class_8021)this);
        ArrayList<Element> thisRowElements = new ArrayList<Element>();
        for (Element element : this.elements) {
            int flowAxisElementSize = this.flowAxis.getLength(element);
            if (flowAxisPos + flowAxisElementSize >= flowAxisTotalSize && !thisRowElements.isEmpty()) {
                int maxWrapAxisSize = thisRowElements.stream().mapToInt(e -> this.flowAxis.other().getLength((Element)((Object)e))).max().orElse(0);
                for (Element thisRowElement : thisRowElements) {
                    this.flowAxis.other().setCoordinate(thisRowElement, wrapAxisOrigin + wrapAxisPos, maxWrapAxisSize);
                }
                thisRowElements.clear();
                wrapAxisPos += maxWrapAxisSize + this.wrapSpacing;
                flowAxisPos = 0;
            }
            thisRowElements.add(element);
            this.flowAxis.setCoordinate(element, flowAxisOrigin + flowAxisPos, element.method_46424());
            flowAxisPos += this.flowAxis.getLength(element) + this.flowSpacing;
        }
        int maxWrapAxisSize = thisRowElements.stream().mapToInt(e -> this.flowAxis.other().getLength((Element)((Object)e))).max().orElse(0);
        for (Element thisRowElement : thisRowElements) {
            this.flowAxis.other().setCoordinate(thisRowElement, wrapAxisOrigin + wrapAxisPos, maxWrapAxisSize);
        }
        thisRowElements.clear();
        switch (this.flowAxis.ordinal()) {
            case 0: {
                this.field_41814 = wrapAxisPos + maxWrapAxisSize;
                break;
            }
            case 1: {
                this.field_41813 = wrapAxisPos + maxWrapAxisSize;
            }
        }
    }

    public class_7847 copyPositioner() {
        return this.mainPositioner.method_46478();
    }

    public class_7847 getMainPositioner() {
        return this.mainPositioner;
    }

    public static enum DisplayAxis {
        HORIZONTAL,
        VERTICAL;


        DisplayAxis other() {
            return DisplayAxis.values()[1 - this.ordinal()];
        }

        int getCoordinate(class_8021 widget) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> widget.method_46426();
                case 1 -> widget.method_46427();
            };
        }

        int getLength(class_8021 widget) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> widget.method_25368();
                case 1 -> widget.method_25364();
            };
        }

        int getLength(Element element) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> element.method_46424();
                case 1 -> element.method_46422();
            };
        }

        void setCoordinate(Element element, int low, int high) {
            switch (this.ordinal()) {
                case 0: {
                    element.method_46423(low, high);
                    break;
                }
                case 1: {
                    element.method_46425(low, high);
                }
            }
        }
    }

    protected static class Element
    extends class_7838.class_7839 {
        protected Element(class_8021 widget, class_7847 positioner) {
            super(widget, positioner);
        }
    }
}

