/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.util;

import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public class ScopedThreadLocal<T> {
    public final ThreadLocal<Stack<T>> threadLocal = ThreadLocal.withInitial(Stack::new);

    public ScopedValueCloseable with(T t) {
        this.threadLocal.get().push(t);
        return new ScopedValueCloseable(t);
    }

    @Nullable
    public T get() {
        Stack<T> stack = this.threadLocal.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public class ScopedValueCloseable
    implements AutoCloseable {
        private final T value;

        public ScopedValueCloseable(T value) {
            this.value = value;
        }

        @Override
        public void close() {
            Stack stack = ScopedThreadLocal.this.threadLocal.get();
            if (stack.peek() != this.value) {
                throw new IllegalStateException("Closing scoped value didn't have the same value anymore");
            }
            stack.pop();
        }
    }
}

