/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.replaceitem.reconfigure.Reconfigure;
import net.replaceitem.reconfigure.api.Config;
import net.replaceitem.reconfigure.api.ConfigTabBuilder;
import net.replaceitem.reconfigure.config.PropertyHolder;
import net.replaceitem.reconfigure.config.serialization.SerializationTarget;
import net.replaceitem.reconfigure.config.serialization.Serializer;
import net.replaceitem.reconfigure.config.widget.ConfigTabBuilderImpl;
import net.replaceitem.reconfigure.config.widget.ConfigTabImpl;
import net.replaceitem.reconfigure.screen.ConfigScreen;
import org.jetbrains.annotations.Nullable;

public class ConfigImpl
implements Config,
SerializationTarget {
    private final String namespace;
    private final class_2561 title;
    private final List<ConfigTabImpl> tabs = new ArrayList<ConfigTabImpl>();
    private boolean hasSingleDefaultTab = false;
    @Nullable
    private final Serializer<?, ?> serializer;
    private boolean dirty = false;
    @Nullable
    private Timer saveTimer;
    protected final Map<class_2960, PropertyHolder<?>> properties = new LinkedHashMap();

    protected ConfigImpl(String namespace, class_2561 title, @Nullable Serializer<?, ?> serializer) {
        this.namespace = namespace;
        this.title = title;
        this.serializer = serializer;
    }

    @Override
    public ConfigTabBuilder createTab(String name) {
        return new ConfigTabBuilderImpl(this, name);
    }

    @Override
    public ConfigTabBuilder createDefaultTab() {
        this.hasSingleDefaultTab = true;
        return new ConfigTabBuilderImpl(this, "default");
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public List<ConfigTabImpl> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    public boolean hasSingleDefaultTab() {
        return this.hasSingleDefaultTab;
    }

    @Nullable
    public PropertyHolder<?> getProperty(class_2960 key) {
        return this.properties.get(key);
    }

    @Nullable
    public PropertyHolder<?> getProperty(String key) {
        return this.getProperty(class_2960.method_60655((String)this.namespace, (String)key));
    }

    public Collection<PropertyHolder<?>> getProperties() {
        return this.properties.values();
    }

    public void addTab(ConfigTabImpl configTab) {
        if (this.hasSingleDefaultTab && !this.tabs.isEmpty()) {
            throw new RuntimeException("Tried adding more than one tab to a config with a default tab. If you use config.createDefaultTab() your config can only have one tab.");
        }
        this.tabs.add(configTab);
    }

    public void addProperty(PropertyHolder<?> property) {
        if (this.properties.containsKey(property.getId())) {
            throw new RuntimeException("Config " + this.namespace + " already contains a property with id " + String.valueOf(property.getId()));
        }
        property.getProperty().addListener(o -> this.markDirty());
        this.properties.put(property.getId(), property);
    }

    @Override
    @Deprecated
    public ConfigScreen createScreen(@Nullable class_437 parent) {
        return new ConfigScreen(this, parent);
    }

    private static File getConfigFile(String namespace, Serializer<?, ?> serializer) throws IOException {
        Path configDir = FabricLoader.getInstance().getConfigDir().normalize();
        Files.createDirectories(configDir, new FileAttribute[0]);
        return configDir.resolve(namespace + "." + serializer.getFileExtension()).normalize().toFile();
    }

    @Override
    public void save() {
        try {
            if (this.serializer == null) {
                Reconfigure.LOGGER.warn("Not saving config {} because no serializer is defined", (Object)this.namespace);
                return;
            }
            File configFile = ConfigImpl.getConfigFile(this.namespace, this.serializer);
            try (FileOutputStream fileOutputStream = new FileOutputStream(configFile);){
                this.serializer.serialize(this, fileOutputStream);
            }
            this.dirty = false;
        }
        catch (IOException e) {
            Reconfigure.LOGGER.error("Could save config", (Throwable)e);
        }
    }

    @Override
    public void load() {
        block9: {
            try {
                if (this.serializer == null) {
                    Reconfigure.LOGGER.warn("Not loading config {} because no serializer is defined", (Object)this.namespace);
                    return;
                }
                File configFile = ConfigImpl.getConfigFile(this.namespace, this.serializer);
                if (configFile.exists()) {
                    try (FileInputStream fileInputStream = new FileInputStream(configFile);){
                        this.serializer.deserialize(this, fileInputStream);
                        break block9;
                    }
                }
                this.save();
                Reconfigure.LOGGER.info("Created {}", (Object)configFile.getName());
            }
            catch (IOException e) {
                Reconfigure.LOGGER.error("Could load config", (Throwable)e);
            }
        }
    }

    protected void markDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void saveIfDirty() {
        if (this.isDirty()) {
            this.save();
        }
    }

    @Override
    public void scheduleSave(Duration duration) {
        final class_310 client = class_310.method_1551();
        if (this.saveTimer != null) {
            this.saveTimer.cancel();
        }
        this.saveTimer = new Timer();
        this.saveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                client.method_63588(ConfigImpl.this::saveIfDirty);
            }
        }, duration.toMillis());
    }
}

