/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.property;

import java.util.Objects;
import net.minecraft.class_2960;
import net.replaceitem.reconfigure.api.Property;
import net.replaceitem.reconfigure.api.ValidationResult;
import net.replaceitem.reconfigure.config.AbstractBindable;
import net.replaceitem.reconfigure.config.ValidatorList;

public class PropertyImpl<T>
extends AbstractBindable<T>
implements Property<T> {
    protected T value;
    private final class_2960 id;
    private final T defaultValue;
    private final ValidatorList<T> validators;

    public PropertyImpl(class_2960 id, T defaultValue, ValidatorList<T> validators) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.validators = validators;
        if (this.validate(defaultValue).isInvalid()) {
            throw new IllegalArgumentException("The default value " + String.valueOf(defaultValue) + " of property " + String.valueOf(id) + " is invalid with the provided validators");
        }
    }

    @Override
    public T get() {
        return this.value;
    }

    private void setInternal(T value) {
        if (!Objects.equals(this.value, value)) {
            this.value = value;
            this.callListeners(this.value);
        }
    }

    @Override
    public void set(T value) {
        ValidationResult result = this.validate(value);
        if (result.isInvalid()) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(this.id) + " to " + String.valueOf(value) + ": " + String.valueOf(result.getMessage()));
        }
        this.setInternal(value);
    }

    @Override
    public void setIfValid(T value) {
        if (this.validate(value).isValid()) {
            this.setInternal(value);
        }
    }

    @Override
    public void setOrDefault(T value) {
        this.setInternal(this.validate(value).isValid() ? value : this.defaultValue);
    }

    @Override
    public void reset() {
        this.set(this.defaultValue);
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault(this.value);
    }

    @Override
    public boolean isDefault(T value) {
        return Objects.equals(value, this.defaultValue);
    }

    public ValidationResult validate(T value) {
        return this.validators.validate(value);
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }
}

