/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.serialization.serializer;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.replaceitem.reconfigure.config.serialization.CharSerializer;
import net.replaceitem.reconfigure.config.serialization.Intermediary;
import net.replaceitem.reconfigure.config.serialization.Marshaller;
import net.replaceitem.reconfigure.config.serialization.SerializationException;
import net.replaceitem.reconfigure.config.serialization.SerializationTarget;
import net.replaceitem.reconfigure.util.OrderedProperties;
import org.jetbrains.annotations.Nullable;

public class PropertiesSerializer
extends CharSerializer<String, Properties> {
    private static final PropertiesMarshaller MARSHALLER = new PropertiesMarshaller();

    public PropertiesSerializer(@Nullable Consumer<Properties> preLoad, @Nullable Consumer<Properties> preWrite) {
        super(preLoad, preWrite);
    }

    @Override
    public Marshaller<String> getMarshaller() {
        return MARSHALLER;
    }

    @Override
    protected Properties read(Reader reader) throws IOException, JsonParseException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }

    @Override
    protected void write(Writer writer, Properties compound) throws IOException {
        compound.store(writer, "");
    }

    @Override
    protected void load(SerializationTarget target, Properties compound) {
        for (Map.Entry<Object, Object> entry : compound.entrySet()) {
            this.setProperty(target, entry.getKey().toString(), entry.getValue().toString());
        }
    }

    @Override
    protected Properties save(SerializationTarget target) {
        OrderedProperties properties = new OrderedProperties();
        for (SerializationTarget.SerializationProperty<?> holder : target.getProperties()) {
            properties.setProperty(holder.getId().method_12832(), (String)this.getProperty(holder));
        }
        return properties;
    }

    @Override
    public String getFileExtension() {
        return "properties";
    }

    private static class PropertiesMarshaller
    extends Marshaller<String> {
        private static final String ESCAPED_COMMA_REPLACEMENT = Matcher.quoteReplacement("\\,");
        private static final Pattern SPLIT_LIST_REGEX = Pattern.compile("(?<!\\\\),");

        private PropertiesMarshaller() {
        }

        @Override
        public String marshall(Intermediary<?> intermediary) {
            Intermediary<?> intermediary2 = intermediary;
            Objects.requireNonNull(intermediary2);
            Intermediary<?> intermediary3 = intermediary2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Intermediary.IntermediaryString.class, Intermediary.IntermediaryInteger.class, Intermediary.IntermediaryDouble.class, Intermediary.IntermediaryBoolean.class, Intermediary.IntermediaryList.class}, intermediary3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Intermediary.IntermediaryString intermediaryString = (Intermediary.IntermediaryString)intermediary3;
                    yield (String)intermediaryString.getValue();
                }
                case 1 -> {
                    Intermediary.IntermediaryInteger intermediaryInteger = (Intermediary.IntermediaryInteger)intermediary3;
                    yield Integer.toString((Integer)intermediaryInteger.getValue());
                }
                case 2 -> {
                    Intermediary.IntermediaryDouble intermediaryDouble = (Intermediary.IntermediaryDouble)intermediary3;
                    yield Double.toString((Double)intermediaryDouble.getValue());
                }
                case 3 -> {
                    Intermediary.IntermediaryBoolean intermediaryBoolean = (Intermediary.IntermediaryBoolean)intermediary3;
                    yield Boolean.toString((Boolean)intermediaryBoolean.getValue());
                }
                case 4 -> {
                    Intermediary.IntermediaryList intermediaryList = (Intermediary.IntermediaryList)intermediary3;
                    yield ((List)intermediaryList.getValue()).stream().map(s -> s.replaceAll(",", ESCAPED_COMMA_REPLACEMENT)).collect(Collectors.joining(","));
                }
            };
        }

        @Override
        protected String unmarshallString(String value) {
            return value;
        }

        @Override
        protected Integer unmarshallInteger(String value) throws SerializationException {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        protected Double unmarshallDouble(String value) throws SerializationException {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        protected Boolean unmarshallBoolean(String value) throws SerializationException {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw new SerializationException("Could not parse boolean. Expected 'true' or 'false'");
        }

        @Override
        protected List<String> unmarshallList(String value) {
            return new ArrayList<String>(SPLIT_LIST_REGEX.splitAsStream(value).map(s -> s.replace("\\,", ",")).toList());
        }
    }
}

