/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.config.widget.builder;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.replaceitem.reconfigure.api.widget.CyclingButtonWidgetBuilder;
import net.replaceitem.reconfigure.config.BaseSettings;
import net.replaceitem.reconfigure.config.PropertyHolder;
import net.replaceitem.reconfigure.config.property.PropertyBuildContext;
import net.replaceitem.reconfigure.config.property.builder.BooleanPropertyBuilderImpl;
import net.replaceitem.reconfigure.config.property.builder.PropertyBuilderImpl;
import net.replaceitem.reconfigure.config.widget.ConfigWidgetFactory;
import net.replaceitem.reconfigure.config.widget.builder.WidgetBuilderImpl;
import net.replaceitem.reconfigure.screen.widget.config.CyclingButtonConfigWidget;
import org.jetbrains.annotations.Nullable;

public class CyclingButtonWidgetBuilderImpl<T>
extends WidgetBuilderImpl<CyclingButtonWidgetBuilder<T>, T>
implements CyclingButtonWidgetBuilder<T> {
    private Collection<T> values;
    private final Collection<T> allValues;
    @Nullable
    private Function<T, class_2561> valueToText;
    private static final List<Boolean> BOOLEAN_VALUES = List.of(Boolean.FALSE, Boolean.TRUE);

    public CyclingButtonWidgetBuilderImpl(PropertyBuildContext propertyBuildContext, PropertyBuilderImpl<?, T> propertyBuilder, Collection<T> values) {
        super(propertyBuildContext, propertyBuilder);
        this.values = values;
        this.allValues = values.stream().toList();
    }

    public static CyclingButtonWidgetBuilderImpl<Boolean> createBoolean(PropertyBuildContext propertyBuildContext, BooleanPropertyBuilderImpl propertyBuilder) {
        return new CyclingButtonWidgetBuilderImpl<Boolean>(propertyBuildContext, propertyBuilder, BOOLEAN_VALUES).valueToText(value -> value != false ? class_5244.field_24332 : class_5244.field_24333);
    }

    @Override
    public CyclingButtonWidgetBuilderImpl<T> values(Collection<T> values) {
        this.values = values;
        return this;
    }

    @Override
    public CyclingButtonWidgetBuilderImpl<T> valueToText(Function<T, class_2561> valueToText) {
        this.valueToText = valueToText;
        return this;
    }

    @Override
    protected void preBuild(PropertyHolder<T> property) {
        if (this.values.stream().anyMatch(Predicate.not(this.allValues::contains))) {
            String invalidValues = this.values.stream().filter(Predicate.not(this.allValues::contains)).map(Objects::toString).collect(Collectors.joining(", "));
            String validValues = this.allValues.stream().map(Objects::toString).collect(Collectors.joining(", "));
            throw new RuntimeException("The value(s) " + invalidValues + " assigned to the enum widget are not in the values " + validValues + " for its property " + String.valueOf(property.getId()));
        }
        if (this.valueToText == null) {
            throw new RuntimeException("valueToText is required for a cycling button widget");
        }
        super.preBuild(property);
    }

    @Override
    protected ConfigWidgetFactory<T> buildWidgetFactory(BaseSettings baseSettings) {
        assert (this.valueToText != null);
        return (parent, property) -> new CyclingButtonConfigWidget<T>(parent, property, baseSettings, this.valueToText, this.values);
    }
}

